/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk.table;

import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.PKTempTables;
import kd.bos.db.pktemptable.adapter.PKTempTableAdapter;
import kd.bos.db.temptable.pk.PKTempTable;
import kd.bos.db.temptable.pk.config.PKTempTableConfig;
import kd.bos.db.temptable.pk.table.AbstractPKTempTable;
import kd.bos.db.temptable.pk.table.PKTempTablePoolObject;
import kd.bos.db.temptable.pk.table.PKTempTableType;
import kd.bos.db.temptable.pk.table.PKTempTableUnPoolObject;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public final class PKTempTableFactory {
    public static PKTempTable createPKLong(DBRoute route) {
        return PKTempTableFactory.createNewVersionPKTempTable(route, PKTempTableType.PK_LONG);
    }

    public static PKTempTable createPKString(DBRoute route) {
        return PKTempTableFactory.createNewVersionPKTempTable(route, PKTempTableType.PK_STRING);
    }

    public static PKTempTable createPKBigString(DBRoute route) {
        return PKTempTableFactory.createNewVersionPKTempTable(route, PKTempTableType.PK_BIGSTRING);
    }

    private static PKTempTable createNewVersionPKTempTable(DBRoute route, PKTempTableType type) {
        switch (type) {
            case PK_LONG: {
                return new PKTempTableAdapter(PKTempTables.createPKLong(route));
            }
            case PK_STRING: {
                return new PKTempTableAdapter(PKTempTables.createPKString(route));
            }
            case PK_BIGSTRING: {
                return new PKTempTableAdapter(PKTempTables.createPKBigString(route));
            }
        }
        throw new UnsupportedOperationException("Unknown PKTempTableType: " + type.name());
    }

    private static PKTempTable createOldVersionPKTempTable(DBRoute route, PKTempTableType type) {
        try (TraceSpan ts = Tracer.create((String)"temptable.get", (String)"temptable.get");){
            AbstractPKTempTable abstractPKTempTable = PKTempTableConfig.isNoPool() ? new PKTempTableUnPoolObject(route, type) : new PKTempTablePoolObject(route, type);
            return abstractPKTempTable;
        }
    }

    private static boolean isNewVersion() {
        return kd.bos.db.pktemptable.config.PKTempTableConfig.isNewVersion();
    }
}

