/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.temptable.pk.table;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.pktemptable.utils.PKTempTableThreadUtils;
import kd.bos.db.temptable.pk.config.PKTempTableConfig;
import kd.bos.db.temptable.pk.stats.PKTempTableStats;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.util.Pair;

final class PKTempTableReleaser {
    private static final Log log = LogFactory.getLog((String)"DB");
    private static final BlockingQueue<Pair<ReleaseAction, RequestContextInfo>> releaseQueue = new LinkedBlockingQueue<Pair<ReleaseAction, RequestContextInfo>>();
    private static final Thread releaseThread = new Thread(){

        @Override
        public void run() {
            PKTempTableReleaser.runRelease();
        }
    };
    private static final ExecutorService es;

    PKTempTableReleaser() {
    }

    private static void runRelease() {
        while (!Thread.interrupted()) {
            PKTempTableThreadUtils.resetThread();
            try {
                Pair<ReleaseAction, RequestContextInfo> item = releaseQueue.take();
                PKTempTableReleaser.submitRelease(item);
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Exception e) {
                log.error("runRelease error: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void submitRelease(Pair<ReleaseAction, RequestContextInfo> item) {
        es.submit(() -> {
            try (AutoCloseable ac = ((RequestContextInfo)item.getValue()).setupThreadRequestContext();){
                ((ReleaseAction)item.getKey()).release();
            }
            catch (Exception e) {
                log.error("release pktemptable " + item + " failed: " + e.getMessage(), (Throwable)e);
            }
            PKTempTableStats.incReleased();
            PKTempTableStats.decUnReleased();
        });
    }

    static void release(ReleaseAction action) {
        Pair item = new Pair((Object)action, (Object)RequestContextInfo.get());
        try {
            releaseQueue.put((Pair<ReleaseAction, RequestContextInfo>)item);
            PKTempTableStats.incUnReleased();
        }
        catch (InterruptedException e) {
            throw ExceptionUtil.asRuntimeException((Throwable)e);
        }
    }

    static {
        releaseThread.setDaemon(true);
        releaseThread.setName(PKTempTableReleaser.class.getSimpleName());
        releaseThread.start();
        es = Executors.newFixedThreadPool(PKTempTableConfig.getReleaseThread(), new ThreadFactory(){
            private int i = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(ThreadLifeCycleManager.wrapRunnable((Runnable)r));
                t.setDaemon(true);
                t.setName(PKTempTableReleaser.class.getSimpleName() + "Thread-" + ++this.i);
                return t;
            }
        });
    }

    static interface ReleaseAction {
        public void release();

        public String toString();
    }
}

