/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.tx;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.bundle.Resources;
import kd.bos.db.QueryResource;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.DataSourceMXBeanImpl;
import kd.bos.db.datasource.DataSourceURLs;
import kd.bos.db.tx.ConnectionOptimizer;
import kd.bos.db.tx.DBTypeTransUtils;
import kd.bos.db.tx.DelegateCallableStatement;
import kd.bos.db.tx.DelegatePreparedStatement;
import kd.bos.db.tx.DelegateStatement;
import kd.bos.db.tx.ParallelConnectionSupplier;
import kd.bos.db.tx.Propagation;
import kd.bos.db.tx.RWTableInfo;
import kd.bos.db.tx.ShardingArchiveConnectionSupplier;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXContext;
import kd.bos.db.tx.TXImplicitObject;
import kd.bos.exception.SecureExceptionUtil;
import kd.bos.exception.XDBErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.DisCardUtil;
import kd.bos.util.StringUtils;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.datasource.AbstractParallelConnectionHolder;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.exception.LimitedSQLException;

public final class DelegateConnection
extends AbstractParallelConnectionHolder
implements Connection {
    private static final Log log = LogFactory.getLog(DelegateConnection.class);
    private static AtomicLong idSeq = new AtomicLong();
    private final long id;
    private String simpleURL;
    private boolean autoCommit = true;
    private final boolean inTX;
    private final TXContext ctx;
    private final Connection con;
    private final String routeKey;
    private final DBConfig dbConfig;
    private final DBType dbType;
    private boolean writed = false;
    private AtomicBoolean closed = new AtomicBoolean();
    private int ref = 0;
    private final boolean useForReadOnly;
    private List<String> writeSqlList = new LinkedList<String>();
    private List<QueryResource> unReleaseResources = new LinkedList<QueryResource>();
    private final ParallelConnectionSupplier pcs;
    private final ShardingArchiveConnectionSupplier acs;
    private final Set<AutoCloseable> __stmtResources = new HashSet<AutoCloseable>();
    private boolean mainHappened;
    private String currentSchema;
    private List<Connection> pcons = Collections.synchronizedList(new ArrayList());
    private List<Connection> acons = Collections.synchronizedList(new ArrayList());

    public DelegateConnection(TXContext ctx, Connection con, String routeKey, boolean readOnly, DBConfig dbConfig, ParallelConnectionSupplier pcs, ShardingArchiveConnectionSupplier acs) throws SQLException {
        this.id = idSeq.incrementAndGet();
        this.ctx = ctx;
        this.con = con;
        this.routeKey = routeKey;
        this.dbConfig = dbConfig;
        this.useForReadOnly = readOnly;
        this.inTX = ctx.propagation() != Propagation.NOT_SUPPORTED;
        ctx.getStat().requestConnection(this);
        DataSourceMXBeanImpl.statConnectionOnCreate(this);
        this.dbType = DBTypeTransUtils.trans(dbConfig.getDBType());
        this.pcs = pcs;
        this.acs = acs;
    }

    public boolean currentIsUseForReadOnly() {
        return this.useForReadOnly && !this.writed;
    }

    public DBConfig getDBConfig() {
        return this.dbConfig;
    }

    public boolean inTX() {
        return this.inTX;
    }

    public TXContext getCtx() {
        return this.ctx;
    }

    public Propagation getTXPropagation() {
        return this.ctx.propagation();
    }

    public String getRouteKey() {
        return this.routeKey;
    }

    public int getRef() {
        return this.ref;
    }

    int incRef() {
        return ++this.ref;
    }

    int decRef() {
        return --this.ref;
    }

    void resetRef() {
        this.ref = 0;
    }

    public void addWrited(String writeSql) {
        if (this.inTX()) {
            int size;
            if (!this.writed) {
                this.writed = true;
            }
            if ((size = this.writeSqlList.size()) < 126) {
                this.writeSqlList.add(writeSql);
            } else if (size == 127) {
                this.writeSqlList.add("[can not log more]...");
            } else {
                DisCardUtil.discard();
            }
        }
    }

    public boolean isMainHappened() {
        return this.mainHappened;
    }

    public void mainHappened() {
        this.mainHappened = true;
    }

    public void checkMultiDBRouteWrited(boolean isMain, String dbRoute) {
        if (isMain) {
            if (!StringUtils.isEmpty((String)this.archiveRouteKey)) {
                StringBuilder msg = new StringBuilder(1024);
                msg.append("Can not write more than one database: ").append(this.archiveRouteKey).append(" has written,").append(dbRoute).append(" can not write.");
                throw new LimitedSQLException(XDBErrorCode.xdbMultiDBWrited, msg.toString());
            }
        } else {
            if (this.isMainHappened()) {
                StringBuilder msg = new StringBuilder(1024);
                msg.append("Can not write more than one database: ").append(this.routeKey).append(" has written,").append(dbRoute).append(" can not write.");
                throw new LimitedSQLException(XDBErrorCode.xdbMultiDBWrited, msg.toString());
            }
            if (!StringUtils.isEmpty((String)this.archiveRouteKey) && !dbRoute.equalsIgnoreCase(this.archiveRouteKey)) {
                StringBuilder msg = new StringBuilder(1024);
                msg.append("Can not write more than one database: ").append(this.archiveRouteKey).append(" has written,").append(dbRoute).append(" can not write.");
                throw new LimitedSQLException(XDBErrorCode.xdbMultiDBWrited, msg.toString());
            }
        }
    }

    void clearWritedOnCommitOrRollback() {
        this.writeSqlList.clear();
        this.writed = false;
    }

    public boolean isWrited() {
        return this.writed;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.con.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.close(false);
    }

    List<String> getWriteSqlList() {
        return this.writeSqlList;
    }

    public String getArchiveRouteKey() {
        return this.archiveRouteKey;
    }

    public Map<String, Connection> getArchiveConMap() {
        return this.archiveConMap;
    }

    public Connection getArchiveCon(String dbRoute) {
        return (Connection)this.archiveConMap.get(dbRoute);
    }

    public void addReleaseResource(QueryResource resource) {
        if (resource != null) {
            if (this.unReleaseResources.size() > 100 && Boolean.parseBoolean(System.getProperty("db.check.resultset", "false"))) {
                throw new RuntimeException("Too many active resultset: " + this.unReleaseResources.size());
            }
            this.unReleaseResources.add(resource);
        }
    }

    public boolean removeReleaseResource(QueryResource resource) {
        return this.unReleaseResources.remove(resource);
    }

    public void close(boolean shouldRollback) throws SQLException {
        if (shouldRollback && this.inTX()) {
            TX.doMarkRollback();
        }
        if (this.decRef() <= 0) {
            if (this.ctx.isImplicitTX()) {
                this.realClose();
            } else if (!this.isWrited()) {
                this.realClose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void realClose() throws SQLException {
        block35: {
            Iterator<Object> iterator;
            if (!this.closed.compareAndSet(false, true)) return;
            try {
                this.beforeRelease();
                this.resetRef();
                if (this.pcons.isEmpty()) break block35;
                iterator = new ArrayList<Connection>(this.pcons).iterator();
            }
            catch (Throwable throwable) {
                this.resetRef();
                if (!this.pcons.isEmpty()) {
                    for (Connection con : new ArrayList<Connection>(this.pcons)) {
                        if (con.isClosed()) continue;
                        try {
                            ConnectionOptimizer.skipMoreResults(con, this.dbType);
                            if (DataSourceURLs.isPgUseCursorFetch() && !this.inTX && TXImplicitObject.isPgSeries(this.dbType) && !XDBExternal.isNotSupportedAlways() && !con.getAutoCommit()) {
                                con.commit();
                            }
                            con.close();
                        }
                        catch (Exception e) {
                            DisCardUtil.discard();
                        }
                    }
                    this.pcons.clear();
                }
                if (!this.acons.isEmpty()) {
                    for (Connection con : new ArrayList<Connection>(this.acons)) {
                        if (con.isClosed()) continue;
                        try {
                            ConnectionOptimizer.skipMoreResults(con, this.dbType);
                            if (DataSourceURLs.isPgUseCursorFetch() && !this.inTX && TXImplicitObject.isPgSeries(this.dbType) && !XDBExternal.isNotSupportedAlways() && !con.getAutoCommit()) {
                                con.commit();
                            }
                            con.close();
                        }
                        catch (Exception e) {
                            DisCardUtil.discard();
                        }
                    }
                    this.acons.clear();
                }
                try {
                    ConnectionOptimizer.skipMoreResults(this.con, this.dbType);
                    if (DataSourceURLs.isPgUseCursorFetch() && !this.inTX && TXImplicitObject.isPgSeries(this.dbType) && !XDBExternal.isNotSupportedAlways() && !this.con.getAutoCommit()) {
                        this.con.commit();
                    }
                    for (Map.Entry entry : this.archiveConMap.entrySet()) {
                        Connection archiveCon = (Connection)entry.getValue();
                        if (archiveCon == null) continue;
                        ConnectionOptimizer.skipMoreResults(archiveCon, this.dbType);
                        archiveCon.close();
                    }
                    this.con.close();
                    throw throwable;
                }
                catch (Exception e) {
                    DisCardUtil.discard();
                    throw throwable;
                }
                finally {
                    this.ctx.getStat().returnConnection(this);
                }
            }
            while (iterator.hasNext()) {
                Connection connection = iterator.next();
                if (connection.isClosed()) continue;
                try {
                    ConnectionOptimizer.skipMoreResults(connection, this.dbType);
                    if (DataSourceURLs.isPgUseCursorFetch() && !this.inTX && TXImplicitObject.isPgSeries(this.dbType) && !XDBExternal.isNotSupportedAlways() && !connection.getAutoCommit()) {
                        connection.commit();
                    }
                    connection.close();
                }
                catch (Exception e) {
                    DisCardUtil.discard();
                }
            }
            this.pcons.clear();
        }
        if (!this.acons.isEmpty()) {
            for (Connection connection : new ArrayList<Connection>(this.acons)) {
                if (connection.isClosed()) continue;
                try {
                    ConnectionOptimizer.skipMoreResults(connection, this.dbType);
                    if (DataSourceURLs.isPgUseCursorFetch() && !this.inTX && TXImplicitObject.isPgSeries(this.dbType) && !XDBExternal.isNotSupportedAlways() && !connection.getAutoCommit()) {
                        connection.commit();
                    }
                    connection.close();
                }
                catch (Exception e) {
                    DisCardUtil.discard();
                }
            }
            this.acons.clear();
        }
        try {
            ConnectionOptimizer.skipMoreResults(this.con, this.dbType);
            if (DataSourceURLs.isPgUseCursorFetch() && !this.inTX && TXImplicitObject.isPgSeries(this.dbType) && !XDBExternal.isNotSupportedAlways() && !this.con.getAutoCommit()) {
                this.con.commit();
            }
            for (Map.Entry entry : this.archiveConMap.entrySet()) {
                Connection archiveCon = (Connection)entry.getValue();
                if (archiveCon == null) continue;
                ConnectionOptimizer.skipMoreResults(archiveCon, this.dbType);
                archiveCon.close();
            }
            this.con.close();
            return;
        }
        catch (Exception e) {
            DisCardUtil.discard();
            return;
        }
        finally {
            this.ctx.getStat().returnConnection(this);
        }
    }

    private void beforeRelease() throws SQLException {
        if (!this.unReleaseResources.isEmpty()) {
            for (QueryResource res : new ArrayList<QueryResource>(this.unReleaseResources)) {
                if (res == null) continue;
                try {
                    res.close();
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        for (Map.Entry entry : this.archiveConMap.entrySet()) {
            Connection archiveCon = (Connection)entry.getValue();
            if (archiveCon == null) continue;
            archiveCon.commit();
        }
        this.con.commit();
        this.clearWritedOnCommitOrRollback();
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement stmt = this.con.createStatement();
        DelegateStatement delegateStmt = new DelegateStatement(stmt, this);
        this.registerStmtCloseListener(delegateStmt);
        return delegateStmt;
    }

    private void registerStmtCloseListener(DelegateStatement stmt) {
        if (this.__stmtResources.isEmpty()) {
            return;
        }
        stmt.registerListener(new DelegateStatement.Listener(){
            final Set<AutoCloseable> resources;
            final AtomicBoolean closed;
            {
                this.resources = new HashSet<AutoCloseable>(DelegateConnection.this.__stmtResources);
                this.closed = new AtomicBoolean(false);
            }

            @Override
            public void afterClosed() {
                if (this.closed.compareAndSet(false, true) && !this.resources.isEmpty()) {
                    for (AutoCloseable resource : this.resources) {
                        try {
                            resource.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        });
        this.__stmtResources.clear();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement stmt = this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        DelegateStatement delegateStmt = new DelegateStatement(stmt, this);
        this.registerStmtCloseListener(delegateStmt);
        return delegateStmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement stmt = this.con.createStatement(resultSetType, resultSetConcurrency);
        DelegateStatement delegateStmt = new DelegateStatement(stmt, this);
        this.registerStmtCloseListener(delegateStmt);
        return delegateStmt;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.con.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.con.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.con.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.con.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.con.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed.get() || this.con.isClosed();
    }

    boolean hasCallClosed() {
        return this.closed.get();
    }

    public boolean isUseForReadOnly() {
        return this.useForReadOnly;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.con.isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.con.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement stmt = this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        DelegateCallableStatement delegateStmt = new DelegateCallableStatement(stmt, this);
        this.registerStmtCloseListener(delegateStmt);
        return delegateStmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement stmt = this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
        DelegateCallableStatement delegateStmt = new DelegateCallableStatement(stmt, this);
        this.registerStmtCloseListener(delegateStmt);
        return delegateStmt;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement stmt = this.con.prepareCall(sql);
        DelegateCallableStatement delegateStmt = new DelegateCallableStatement(stmt, this);
        this.registerStmtCloseListener(delegateStmt);
        return delegateStmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement stmt = this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        DelegatePreparedStatement delegateStmt = new DelegatePreparedStatement(stmt, this);
        this.registerStmtCloseListener(delegateStmt);
        return delegateStmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement stmt = this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
        DelegatePreparedStatement delegateStmt = new DelegatePreparedStatement(stmt, this);
        this.registerStmtCloseListener(delegateStmt);
        return delegateStmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement stmt = this.con.prepareStatement(sql, autoGeneratedKeys);
        DelegatePreparedStatement delegateStmt = new DelegatePreparedStatement(stmt, this);
        this.registerStmtCloseListener(delegateStmt);
        return delegateStmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement stmt = this.con.prepareStatement(sql, columnIndexes);
        DelegatePreparedStatement delegateStmt = new DelegatePreparedStatement(stmt, this);
        this.registerStmtCloseListener(delegateStmt);
        return delegateStmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement stmt = this.con.prepareStatement(sql, columnNames);
        DelegatePreparedStatement delegateStmt = new DelegatePreparedStatement(stmt, this);
        this.registerStmtCloseListener(delegateStmt);
        return delegateStmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement stmt = this.con.prepareStatement(sql);
        DelegatePreparedStatement delegateStmt = new DelegatePreparedStatement(stmt, this);
        this.registerStmtCloseListener(delegateStmt);
        return delegateStmt;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (StringUtils.isNotEmpty((String)this.archiveRouteKey) && this.archiveConMap.get(this.archiveRouteKey) != null) {
            ((Connection)this.archiveConMap.get(this.archiveRouteKey)).releaseSavepoint(savepoint);
        } else {
            this.con.releaseSavepoint(savepoint);
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (StringUtils.isNotEmpty((String)this.archiveRouteKey) && this.archiveConMap.get(this.archiveRouteKey) != null) {
            ((Connection)this.archiveConMap.get(this.archiveRouteKey)).rollback();
        } else {
            this.con.rollback();
        }
        this.clearWritedOnCommitOrRollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (StringUtils.isNotEmpty((String)this.archiveRouteKey) && this.archiveConMap.get(this.archiveRouteKey) != null) {
            ((Connection)this.archiveConMap.get(this.archiveRouteKey)).rollback(savepoint);
        } else {
            this.con.rollback(savepoint);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        throw new UnsupportedOperationException(Resources.get((String)"bos-dbengine", (String)"DelegateConnection_2", (String)"\u7981\u7528setAutoCommit", (Object[])new Object[0]));
    }

    public void __setAutoCommit(boolean autoCommit) throws SQLException {
        this.con.setAutoCommit(autoCommit);
        this.autoCommit = autoCommit;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.con.setCatalog(catalog);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.con.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.con.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        if (StringUtils.isNotEmpty((String)this.archiveRouteKey) && this.archiveConMap.get(this.archiveRouteKey) != null) {
            return ((Connection)this.archiveConMap.get(this.archiveRouteKey)).setSavepoint();
        }
        return this.con.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        if (StringUtils.isNotEmpty((String)this.archiveRouteKey) && this.archiveConMap.get(this.archiveRouteKey) != null) {
            return ((Connection)this.archiveConMap.get(this.archiveRouteKey)).setSavepoint(name);
        }
        return this.con.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        throw new UnsupportedOperationException(Resources.get((String)"bos-dbengine", (String)"DelegateConnection_3", (String)"\u7981\u7528setTransactionIsolation", (Object[])new Object[0]));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.con.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.con.isWrapperFor(iface);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.con.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.con.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.con.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.con.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.con.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.con.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.con.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.con.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.con.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.con.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.con.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.con.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.con.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.con.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.con.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.con.getNetworkTimeout();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.con.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.con.setTypeMap(map);
    }

    public long id() {
        return this.id;
    }

    public String getSimpleURL() throws SQLException {
        if (this.simpleURL == null) {
            int p;
            String url = this.getMetaData().getURL();
            if (url != null && (p = url.indexOf(63)) != -1) {
                url = url.substring(0, p);
            }
            this.simpleURL = url;
        }
        return this.simpleURL;
    }

    public DBType getDBType() {
        return this.dbType;
    }

    public String toString() {
        try {
            return super.toString() + ", #con" + this.id + '_' + this.con + ", ref=" + this.ref + ", closed=" + this.isClosed() + ", autoCommit=" + this.getAutoCommit() + ", routeKey=" + this.routeKey + ", DBConfig.id=" + this.dbConfig.getId() + ", url=" + this.getSimpleURL();
        }
        catch (SQLException e) {
            return super.toString();
        }
    }

    protected Connection createConnection(boolean main, String querySQL) throws SQLException {
        if (main || querySQL == null) {
            return this;
        }
        RWTableInfo si = RWTableInfo.parseRWTableInfo(querySQL);
        RequestContextInfo rc = RequestContextInfo.get();
        if (!TX.inTX() || TX.__canQueryOnReadOnlyDB(rc.getTenantId(), this.routeKey, rc.getAccountId(), si.getAllTables().toArray(new String[si.getAllTables().size()]))) {
            Connection con = this.pcs.getConnection();
            if (DataSourceURLs.isPgUseCursorFetch() && TXImplicitObject.isPgSeries(this.dbType) && con.getAutoCommit() && !XDBExternal.isNotSupportedAlways()) {
                con.setAutoCommit(false);
            }
            this.pcons.add(con);
            return con;
        }
        return this;
    }

    protected Connection createArchiveConnection(boolean isRouteMain, boolean foUpdate, String dbRoute) throws SQLException {
        if (!isRouteMain) {
            Connection con = this.acs.getConnection(dbRoute);
            if (DataSourceURLs.isPgUseCursorFetch() && TXImplicitObject.isPgSeries(this.dbType) && con.getAutoCommit() && !XDBExternal.isNotSupportedAlways()) {
                con.setAutoCommit(false);
            }
            this.acons.add(con);
            return con;
        }
        if (foUpdate) {
            this.checkMultiDBRouteWrited(false, dbRoute);
            this.archiveRouteKey = dbRoute;
        }
        if (this.archiveConMap.get(dbRoute) == null) {
            Connection archiveCon = this.acs.getConnection(dbRoute);
            try {
                if (archiveCon.getAutoCommit()) {
                    archiveCon.setAutoCommit(false);
                }
            }
            catch (SQLException e) {
                throw SecureExceptionUtil.wrapSQLException((SQLException)e);
            }
            this.archiveConMap.put(dbRoute, archiveCon);
        }
        return (Connection)this.archiveConMap.get(dbRoute);
    }

    protected Connection createAloneConnection() throws SQLException {
        Connection con = this.pcs.getConnection();
        this.pcons.add(con);
        return con;
    }

    protected void closeConnection(boolean main, Connection con) throws SQLException {
        if (!main) {
            ConnectionOptimizer.skipMoreResults(con, this.dbType);
            if (DataSourceURLs.isPgUseCursorFetch() && !this.inTX && TXImplicitObject.isPgSeries(this.dbType) && !XDBExternal.isNotSupportedAlways() && !con.getAutoCommit()) {
                con.commit();
            }
            con.close();
        }
    }

    protected void rollbackConnection(boolean main, Connection con) throws SQLException {
        if (TX.inTX()) {
            if (!main) {
                con.rollback();
            }
            this.ctx.setRollback(true);
        }
    }

    public String getLifeCycleMessage() {
        return null;
    }

    public void __addStmtResource(AutoCloseable closeable) {
        if (closeable != null) {
            this.__stmtResources.add(closeable);
        }
    }

    public String getCurrentSchema() {
        return this.currentSchema;
    }

    public void setCurrentSchema(String currentSchema) {
        this.currentSchema = currentSchema;
    }
}

