/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.tx;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.KDExceptionKit;
import kd.bos.ksql.parser.Lexer;
import kd.bos.ksql.parser.Token;
import kd.bos.xdb.util.LRUCacheMap;

public class RWTableInfo {
    private String mainTable;
    private Set<String> allTables = new HashSet<String>();
    private boolean writedSQL = true;
    private boolean isDDL = false;
    private static int sql_rwtable_cache_size = 1024;
    private static ThreadLocal<Map<String, RWTableInfo>> threadCacheMap;

    public String getMainTable() {
        return this.mainTable;
    }

    public Set<String> getAllTables() {
        return this.allTables;
    }

    public boolean isWritedSQL() {
        return this.writedSQL || this.isDDL;
    }

    public static RWTableInfo parseRWTableInfo(String sql) {
        return threadCacheMap.get().computeIfAbsent(sql, k -> {
            try {
                String cmd;
                RWTableInfo ret = new RWTableInfo();
                ret.writedSQL = true;
                Lexer lexer = new Lexer(sql, true);
                Token t = lexer.next();
                while (t.type == 0 || t.type == 14) {
                    t = lexer.next();
                }
                switch (cmd = t.value.toLowerCase()) {
                    case "select": 
                    case "explain": {
                        ret.isDDL = false;
                        ret.writedSQL = false;
                        break;
                    }
                    case "delete": 
                    case "update": 
                    case "insert": {
                        ret.isDDL = false;
                        break;
                    }
                    default: {
                        ret.isDDL = true;
                    }
                }
                block18 : switch (cmd) {
                    case "select": {
                        do {
                            t = lexer.next();
                            if (t.type != 3) continue;
                            String lv = t.value.toLowerCase();
                            if ("from".equals(lv)) {
                                ret.mainTable = RWTableInfo.unwrapTableName(lexer.next().getOrgValue().toLowerCase());
                                ret.allTables.add(ret.mainTable);
                                continue;
                            }
                            if (!"join".equals(lv)) continue;
                            ret.allTables.add(RWTableInfo.unwrapTableName(lexer.next().getOrgValue().toLowerCase()));
                        } while (t.type != 12);
                        break;
                    }
                    case "delete": {
                        do {
                            t = lexer.next();
                            if (t.type == 3 && "from".equals(t.value.toLowerCase())) {
                                ret.mainTable = RWTableInfo.unwrapTableName(lexer.next().getOrgValue().toLowerCase());
                                ret.allTables.add(ret.mainTable);
                                break block18;
                            }
                            String tableName = t.getOrgValue().toLowerCase();
                            if ("*".equals(tableName)) continue;
                            ret.mainTable = RWTableInfo.unwrapTableName(tableName);
                            ret.allTables.add(ret.mainTable);
                            break block18;
                        } while (t.type != 12);
                        break;
                    }
                    case "update": {
                        ret.mainTable = RWTableInfo.unwrapTableName(lexer.next().getOrgValue().toLowerCase());
                        ret.allTables.add(ret.mainTable);
                        break;
                    }
                    case "insert": {
                        t = lexer.next();
                        if (!"into".equals(t.value.toLowerCase())) break;
                        ret.mainTable = RWTableInfo.unwrapTableName(lexer.next().getOrgValue().toLowerCase());
                        ret.allTables.add(ret.mainTable);
                    }
                }
                return ret;
            }
            catch (Exception e) {
                throw KDExceptionKit.wrapRuntimeException((Throwable)e);
            }
        });
    }

    private static String unwrapTableName(String tableName) {
        if (tableName.charAt(0) == '[') {
            tableName = tableName.substring(1, tableName.length() - 1).trim();
        }
        return tableName;
    }

    static {
        String size = System.getProperty("xdb.sql.rwtable.cache.size");
        if (size != null && size.matches("\\d+")) {
            sql_rwtable_cache_size = Integer.parseInt(size);
        }
        threadCacheMap = ThreadLocal.withInitial(() -> new LRUCacheMap(sql_rwtable_cache_size));
    }
}

