/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.tx;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.bundle.Resources;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.archive.ArchiveName;
import kd.bos.db.archive.ArchiveRoute;
import kd.bos.db.archive.DBArchiveManager;
import kd.bos.db.archive.LogicArchiveRoute;
import kd.bos.db.archive.UnmodifiableArchiveDataException;
import kd.bos.db.archive.WriteArchiveContext;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.DataSourceInfo;
import kd.bos.db.datasource.DataSourceInfoProvider;
import kd.bos.db.datasource.DataSourceURLs;
import kd.bos.db.splittingread.SplittingReadConfig;
import kd.bos.db.splittingread.SplittingReadWriteMode;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.CommitListenerException;
import kd.bos.db.tx.ConnectionOptimizer;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.Pair;
import kd.bos.db.tx.ParallelConnectionSupplier;
import kd.bos.db.tx.Propagation;
import kd.bos.db.tx.ShardingArchiveConnectionSupplier;
import kd.bos.db.tx.TXHandle;
import kd.bos.db.tx.TXImplicitObject;
import kd.bos.db.tx.TXStat;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceConfig;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.DisCardUtil;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.XDBExternal;

public final class TXContext
implements AutoCloseable {
    private static Log logger = LogFactory.getLog(TXContext.class);
    private static final ThreadLocal<AtomicInteger> thGetConnectionCount = ThreadLocals.create(() -> new AtomicInteger());
    private static final AtomicLong idseq = new AtomicLong();
    private static final ThreadLocal<Boolean> thIgnoreCheckThreadGetMaxConnectionCount = ThreadLocals.create(() -> Boolean.FALSE);
    private static int getMaxConnectionCount = 0;
    private static boolean log_stack = false;
    private static boolean logSetRollback = false;
    private static boolean throwCommitListenerExcepts = true;
    private final TXStat txStat;
    private String txStack;
    private String endError;
    private final Propagation propagation;
    private final TXContext parent;
    private final TXContext transRootCtx;
    private final Set<String> forceMasterRouteSet;
    private final TransactionTree transactionTree;
    private boolean ended = false;
    private boolean halt = false;
    private TXHandle handle;
    private final long id;
    private String tag;
    private LinkedList<String> refTags;
    private int refCount = 1;
    private final Map<String, TransactionManager> tmMap;
    private boolean inTX;
    private boolean isImplicitTX;
    private final String accountId;
    private TXImplicitObject txImplicitObject = new TXImplicitObject();
    private static final String trace_endTX = "endTX";
    private static final String tip = "\nNot allowed to write multiple databases in the same transaction: ";

    static void setIgnoreCheckThreadGetMaxConnectionCount(boolean b) {
        thIgnoreCheckThreadGetMaxConnectionCount.set(b);
    }

    TXContext(Propagation propagation, TXContext parent, String tag, boolean isImplicitTX) {
        this.accountId = RequestContextInfo.get().getAccountId();
        this.id = idseq.incrementAndGet();
        if (!(parent != null && parent.propagation != Propagation.NOT_SUPPORTED || propagation != Propagation.REQUIRED && propagation != Propagation.NESTED)) {
            propagation = Propagation.REQUIRES_NEW;
        }
        this.propagation = propagation;
        this.parent = parent;
        this.isImplicitTX = isImplicitTX;
        this.transRootCtx = this.peekTMRoot();
        boolean currentIsRoot = this.transRootCtx == this;
        this.tmMap = currentIsRoot ? new HashMap() : this.transRootCtx.tmMap;
        this.forceMasterRouteSet = currentIsRoot ? new HashSet() : this.transRootCtx.forceMasterRouteSet;
        this.transactionTree = currentIsRoot ? new TransactionTree(this) : this.transRootCtx.transactionTree;
        this.tag = tag;
        this.txStat = parent == null ? new TXStat() : parent.txStat;
        this.txStat.enter(this.id, currentIsRoot && !isImplicitTX);
        switch (propagation) {
            case SUPPORTS: {
                this.inTX = parent != null ? parent.inTX : false;
                break;
            }
            case REQUIRED: 
            case REQUIRES_NEW: 
            case NESTED: {
                this.inTX = true;
                break;
            }
            case NOT_SUPPORTED: {
                this.inTX = false;
            }
        }
        if (!currentIsRoot) {
            DelegateConnection writtenConnection;
            TransactionTreeNode node = this.transactionTree.addChildren(this);
            if (propagation == Propagation.NESTED && (writtenConnection = node.ctx.getWrittenConnection()) != null) {
                try {
                    this.transactionTree.savepoint = writtenConnection.setSavepoint();
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{e.getMessage()});
                }
            }
        }
        if (log_stack) {
            StringWriter sw = new StringWriter();
            sw.append("///").append(Thread.currentThread().getName()).append('#').append(new Date().toString()).append('#');
            new Exception().printStackTrace(new PrintWriter(sw));
            sw.append("///");
            this.txStack = sw.toString();
        }
    }

    String getAccountId() {
        return this.accountId;
    }

    TXContext getTransRoot() {
        return this.transRootCtx;
    }

    boolean isImplicitTX() {
        return this.isImplicitTX;
    }

    public void setImplicitTX(boolean implicitTX) {
        this.isImplicitTX = implicitTX;
    }

    public TXImplicitObject getImplicitObject() {
        return this.txImplicitObject;
    }

    boolean isInTX() {
        return this.inTX;
    }

    void setRollback(boolean rollback) {
        this.setRollback(this.transactionTree.getStatusRootNode(this), rollback);
        if (logSetRollback) {
            logger.error((Throwable)new Exception("[Trace] logSetRollback"));
        }
    }

    private void setRollback(TransactionTreeNode node, boolean rollback) {
        node.rollback = rollback;
        if (!node.children.isEmpty()) {
            Iterator iter = node.children.iterator();
            while (iter.hasNext()) {
                this.setRollback((TransactionTreeNode)iter.next(), rollback);
            }
        }
    }

    public boolean isRollback() {
        return this.transactionTree.getStatusRootNode(this).rollback;
    }

    void addCommitListener(CommitListener cl) {
        this.transactionTree.getStatusRootNode(this).clList.add(cl);
    }

    void setRouteForceMaster(String routeKey) {
        this.forceMasterRouteSet.add(routeKey.toLowerCase());
    }

    private List<CommitListenerException> preCommit() {
        ArrayList<CommitListenerException> occurExceptionRet = new ArrayList<CommitListenerException>();
        for (TransactionTreeNode node : this.getWalkTransactionNodes()) {
            if (node.done || node.clList.isEmpty()) continue;
            if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)trace_endTX)) {
                TraceSpan ts = Tracer.create((String)trace_endTX, (String)"preCommit");
                Throwable throwable = null;
                try {
                    for (CommitListener cl : node.clList) {
                        try {
                            cl.preCommit();
                        }
                        catch (Throwable th) {
                            logger.error("Transaction listener @node{" + node + "} FROM @listener {" + cl + "} preCommit occur error:" + th.getMessage(), th);
                            if (!throwCommitListenerExcepts) continue;
                            occurExceptionRet.add(new CommitListenerException(BosErrorCode.sQLTranslate, "Transaction listener @node{" + node + "} FROM @listener {" + cl + "} preCommit occur error:" + th.getMessage(), th));
                        }
                    }
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ts == null) continue;
                    if (throwable != null) {
                        try {
                            ts.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ts.close();
                    continue;
                }
            }
            for (CommitListener cl : node.clList) {
                try {
                    cl.preCommit();
                }
                catch (Throwable th) {
                    logger.error("Transaction listener @node{" + node + "} FROM @listener {" + cl + "} preCommit occur error:" + th.getMessage(), th);
                    if (!throwCommitListenerExcepts) continue;
                    occurExceptionRet.add(new CommitListenerException(BosErrorCode.sQLTranslate, "Transaction listener @node{" + node + "} FROM @listener {" + cl + "} preCommit occur error:" + th.getMessage(), th));
                }
            }
        }
        return occurExceptionRet;
    }

    private List<CommitListenerException> preRollback() {
        ArrayList<CommitListenerException> occurExceptionRet = new ArrayList<CommitListenerException>();
        for (TransactionTreeNode node : this.getWalkTransactionNodes()) {
            if (node.done || node.clList.isEmpty()) continue;
            if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)trace_endTX)) {
                TraceSpan ts = Tracer.create((String)trace_endTX, (String)"preRollback");
                Throwable throwable = null;
                try {
                    for (CommitListener cl : node.clList) {
                        try {
                            cl.preRollback();
                        }
                        catch (Throwable th) {
                            logger.error("Transaction listener @node{" + node + "} FROM @listener {" + cl + "} preRollback occur error:" + th.getMessage(), th);
                            if (!throwCommitListenerExcepts) continue;
                            occurExceptionRet.add(new CommitListenerException(BosErrorCode.sQLTranslate, "Transaction listener @node{" + node + "} FROM @listener {" + cl + "} preRollback occur error:" + th.getMessage(), th));
                        }
                    }
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ts == null) continue;
                    if (throwable != null) {
                        try {
                            ts.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ts.close();
                    continue;
                }
            }
            for (CommitListener cl : node.clList) {
                try {
                    cl.preRollback();
                }
                catch (Throwable th) {
                    logger.error("Transaction listener @node{" + node + "} FROM @listener {" + cl + "} preRollback occur error:" + th.getMessage(), th);
                    if (!throwCommitListenerExcepts) continue;
                    occurExceptionRet.add(new CommitListenerException(BosErrorCode.sQLTranslate, "Transaction listener @node{" + node + "} FROM @listener {" + cl + "} preRollback occur error:" + th.getMessage(), th));
                }
            }
        }
        return occurExceptionRet;
    }

    private List<CommitListenerException> onRollbacked() {
        ArrayList<CommitListenerException> occurExceptionRet = new ArrayList<CommitListenerException>();
        for (TransactionTreeNode node : this.getWalkTransactionNodes()) {
            if (node.done) continue;
            if (!node.clList.isEmpty()) {
                if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)trace_endTX)) {
                    try (TraceSpan ts = Tracer.create((String)trace_endTX, (String)"onRollbacked");){
                        for (CommitListener cl : node.clList) {
                            try {
                                cl.onRollbacked();
                            }
                            catch (Throwable th) {
                                logger.error("Transaction listener @node{" + node + "} FROM @listener {" + cl + "} onRollbacked occur error:" + th.getMessage(), th);
                                if (!throwCommitListenerExcepts) continue;
                                occurExceptionRet.add(new CommitListenerException(BosErrorCode.sQLTranslate, "Transaction listener @node{" + node + "} FROM @listener {" + cl + "} onRollbacked occur error:" + th.getMessage(), th));
                            }
                        }
                    }
                } else {
                    for (CommitListener cl : node.clList) {
                        try {
                            cl.onRollbacked();
                        }
                        catch (Throwable th) {
                            logger.error("Transaction listener @node{" + node + "} FROM @listener {" + cl + "} onRollbacked occur error:" + th.getMessage(), th);
                            if (!throwCommitListenerExcepts) continue;
                            occurExceptionRet.add(new CommitListenerException(BosErrorCode.sQLTranslate, "Transaction listener @node{" + node + "} FROM @listener {" + cl + "} onRollbacked occur error:" + th.getMessage(), th));
                        }
                    }
                }
            }
            node.done = true;
        }
        return occurExceptionRet;
    }

    private List<CommitListenerException> onCommitted() {
        ArrayList<CommitListenerException> occurExceptionRet = new ArrayList<CommitListenerException>();
        for (TransactionTreeNode node : this.getWalkTransactionNodes()) {
            if (node.done) continue;
            if (!node.clList.isEmpty()) {
                if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)trace_endTX)) {
                    try (TraceSpan ts = Tracer.create((String)trace_endTX, (String)"onCommitted");){
                        for (CommitListener cl : node.clList) {
                            try {
                                cl.onCommitted();
                            }
                            catch (Throwable th) {
                                logger.error("Transaction listener @node{" + node + "} FROM @listener {" + cl + "} onCommitted occur error:" + th.getMessage(), th);
                                if (!throwCommitListenerExcepts) continue;
                                occurExceptionRet.add(new CommitListenerException(BosErrorCode.sQLTranslate, "Transaction listener @node{" + node + "} FROM @listener {" + cl + "} onCommitted occur error:" + th.getMessage(), th));
                            }
                        }
                    }
                } else {
                    for (CommitListener cl : node.clList) {
                        try {
                            cl.onCommitted();
                        }
                        catch (Throwable th) {
                            logger.error("Transaction listener @node{" + node + "} FROM @listener {" + cl + "} onCommitted occur error:" + th.getMessage(), th);
                            if (!throwCommitListenerExcepts) continue;
                            occurExceptionRet.add(new CommitListenerException(BosErrorCode.sQLTranslate, "Transaction listener @node{" + node + "} FROM @listener {" + cl + "} onCommitted occur error:" + th.getMessage(), th));
                        }
                    }
                }
            }
            node.done = true;
        }
        return occurExceptionRet;
    }

    private List<TransactionTreeNode> getWalkTransactionNodes() {
        ArrayList<TransactionTreeNode> nodes = new ArrayList<TransactionTreeNode>(2);
        this.transactionTree.deepWalk(node -> nodes.add(node));
        return nodes;
    }

    void onEnded() {
        ArrayList<CommitListenerException> occurExceptionRet = new ArrayList<CommitListenerException>();
        if (this.propagation == Propagation.NESTED) {
            return;
        }
        for (TransactionTreeNode node : this.getWalkTransactionNodes()) {
            if (node.clList.isEmpty()) continue;
            if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)trace_endTX)) {
                try (TraceSpan ts = Tracer.create((String)trace_endTX, (String)"onEnded");){
                    ts.addTag("rollback", String.valueOf(node.rollback));
                    for (CommitListener cl : node.clList) {
                        try {
                            cl.onEnded(node.rollback);
                        }
                        catch (Throwable th) {
                            logger.error("Transaction listener @node{" + node + "} FROM @listener {" + cl + "} onEnded occur error:" + th.getMessage(), th);
                            if (!throwCommitListenerExcepts) continue;
                            occurExceptionRet.add(new CommitListenerException(BosErrorCode.sQLTranslate, "Transaction listener @node{" + node + "} FROM @listener {" + cl + "} onEnded occur error:" + th.getMessage(), th));
                        }
                    }
                }
            } else {
                for (CommitListener cl : node.clList) {
                    try {
                        cl.onEnded(node.rollback);
                    }
                    catch (Throwable th) {
                        logger.error("Transaction listener @node{" + node + "} FROM @listener {" + cl + "} onEnded occur error:" + th.getMessage(), th);
                        if (!throwCommitListenerExcepts) continue;
                        occurExceptionRet.add(new CommitListenerException(BosErrorCode.sQLTranslate, "Transaction listener @node{" + node + "} FROM @listener {" + cl + "} onEnded occur error:" + th.getMessage(), th));
                    }
                }
            }
            node.clList.clear();
        }
        if (!occurExceptionRet.isEmpty()) {
            throw CommitListenerException.unwrapExceptionList(occurExceptionRet);
        }
    }

    DelegateConnection getConnection(String tenantId, String routeKey, String accountId, boolean requestForReadOnly, SplittingReadWriteMode threadRWMode, DataSourceInfoProvider connectionProvider, String mainTable, String ... useTables) {
        int count;
        if (getMaxConnectionCount > 0 && !thIgnoreCheckThreadGetMaxConnectionCount.get().booleanValue() && (count = thGetConnectionCount.get().getAndIncrement()) > getMaxConnectionCount) {
            throw new RuntimeException("getConnection count exceed limited " + getMaxConnectionCount + " at current thead.");
        }
        if (routeKey == null || routeKey.trim().length() == 0) {
            throw new IllegalArgumentException(Resources.get((String)"bos-dbengine", (String)"TXContext_2", (String)"routeKey\u4e0d\u80fd\u4e3a\u7a7a:", (Object[])new Object[0]) + routeKey);
        }
        routeKey = routeKey.trim().toLowerCase(Locale.ENGLISH);
        ArchiveRoute ar = ArchiveRoute.get();
        if (ar != null && ar.isEffective() && routeKey.equals(ar.getRouteKey())) {
            String archiveRouteKey = ar.getArchiveRouteKey();
            LogicArchiveRoute logicArchiveRoute = LogicArchiveRoute.of(archiveRouteKey);
            if (!routeKey.equals(archiveRouteKey = logicArchiveRoute.getRealArchiveKey())) {
                WriteArchiveContext wa;
                boolean isSkipArchive = true;
                for (String useTable : useTables) {
                    String tableName = ArchiveName.of(useTable).getOriginalName() + logicArchiveRoute.getLogicSuffix();
                    ArchiveConfig config = DBArchiveManager.get().getArchiveConfigProvider().getConfig(tableName);
                    if (config == null) continue;
                    isSkipArchive = false;
                    break;
                }
                if (!isSkipArchive && !logicArchiveRoute.isCurrentArchive()) {
                    routeKey = archiveRouteKey;
                }
                if (!(requestForReadOnly || (wa = WriteArchiveContext.get()) != null && (wa.getRouteKey().equals(ar.getRouteKey()) || wa.getRouteKey().equals(archiveRouteKey)))) {
                    throw new UnmodifiableArchiveDataException(ar.getRouteKey(), archiveRouteKey);
                }
            }
        }
        TransactionManager tm = this.getOrCreateRootTM(tenantId, routeKey, accountId, connectionProvider);
        if (requestForReadOnly && ((TransactionManager)tm).rootCtx.forceMasterRouteSet.contains(tm.rw_routeKey)) {
            requestForReadOnly = false;
        }
        return tm.getConnection(tenantId, routeKey, accountId, requestForReadOnly, threadRWMode, mainTable, useTables);
    }

    private TransactionManager getOrCreateRootTM(String tenantId, String routeKey, String accountId, DataSourceInfoProvider connectionProvider) {
        TXContext rootCtx = this.transRootCtx;
        if (routeKey == null || routeKey.trim().length() == 0) {
            throw new IllegalArgumentException(Resources.get((String)"bos-dbengine", (String)"TXContext_2", (String)"routeKey\u4e0d\u80fd\u4e3a\u7a7a:", (Object[])new Object[0]) + routeKey);
        }
        routeKey = routeKey.trim().toLowerCase(Locale.ENGLISH);
        String tmKey = tenantId + '#' + accountId + '#' + routeKey;
        TransactionManager rootTM = rootCtx.tmMap.get(tmKey);
        if (rootTM == null) {
            String sharedRouteKey = connectionProvider.getSharedRouteKey(tenantId, routeKey, accountId);
            if (!routeKey.equals(sharedRouteKey)) {
                return this.getOrCreateRootTM(tenantId, sharedRouteKey, accountId, connectionProvider);
            }
            rootTM = new TransactionManager(routeKey, connectionProvider, this);
            rootCtx.tmMap.put(tmKey, rootTM);
        }
        return rootTM;
    }

    public TXContext __peekTMRoot() {
        if (this.transRootCtx != null) {
            return this.transRootCtx;
        }
        return this.peekTMRoot();
    }

    private TXContext peekTMRoot() {
        TXContext cur = this;
        while (cur.parent != null) {
            switch (cur.propagation) {
                case SUPPORTS: 
                case REQUIRED: 
                case NESTED: {
                    break;
                }
                case REQUIRES_NEW: 
                case NOT_SUPPORTED: {
                    return cur;
                }
            }
            cur = cur.parent;
        }
        return cur;
    }

    boolean canQueryOnReadOnlyDB(String tenantId, String routeKey, String accountId, DataSourceInfoProvider connectionProvider, String ... useTables) {
        return this.getOrCreateRootTM(tenantId, routeKey, accountId, connectionProvider).canQueryOnReadOnlyDB(accountId, useTables);
    }

    boolean tryCloseOutTXConnection(DelegateConnection specialConn, boolean shouldRollback, boolean implicit_last_rollbacked_committed) {
        try {
            if (!implicit_last_rollbacked_committed && specialConn.isWrited() && !specialConn.getAutoCommit()) {
                ConnectionOptimizer.skipMoreResults(specialConn, specialConn.getDBType());
                if (shouldRollback) {
                    specialConn.rollback();
                } else {
                    specialConn.commit();
                }
            }
        }
        catch (SQLException e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{e.getMessage()});
        }
        finally {
            try {
                specialConn.realClose();
            }
            catch (SQLRecoverableException e) {
                logger.warn("Exception when close connection: " + specialConn, (Throwable)e);
            }
            catch (SQLException e) {
                logger.warn((Throwable)e);
            }
        }
        return true;
    }

    Pair<TXContext, RuntimeException> end() {
        if (this.ended) {
            return new Pair<TXContext, Object>(this.parent, null);
        }
        if (this.decRefCount() > 0) {
            return null;
        }
        if (this.propagation == Propagation.NESTED) {
            return this.commit(true, true);
        }
        this.halt = true;
        return this.commit(false, false);
    }

    Pair<TXContext, RuntimeException> commitCurrent() {
        Pair<TXContext, RuntimeException> ret = this.commit(true, false);
        for (TransactionTreeNode node : this.getWalkTransactionNodes()) {
            node.done = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    Pair<TXContext, RuntimeException> commit(boolean commitCurrent, boolean commitNested) {
        Object exception;
        ArrayList<CommitListenerException> commitListenerExceptions;
        Pair<TXContext, RuntimeException> pair;
        block43: {
            pair = new Pair<TXContext, RuntimeException>();
            commitListenerExceptions = new ArrayList<CommitListenerException>();
            if (commitCurrent || this.transRootCtx == this) {
                if (this.inTX) {
                    if (this.transactionTree.getStatusRootNode(this).rollback) {
                        if (!commitNested) {
                            commitListenerExceptions.addAll(this.preRollback());
                        }
                        for (TransactionManager tm : this.tmMap.values()) {
                            try {
                                if (tm.conRW == null || tm.conRW.hasCallClosed() || tm.conRW.getAutoCommit()) continue;
                                for (Map.Entry<String, Connection> entry : tm.conRW.getArchiveConMap().entrySet()) {
                                    Connection archiveCon = entry.getValue();
                                    if (archiveCon == null) continue;
                                    ConnectionOptimizer.skipMoreResults(archiveCon, tm.conRW.getDBType());
                                }
                                ConnectionOptimizer.skipMoreResults(tm.conRW, tm.conRW.getDBType());
                                if (!tm.conRW.isWrited()) continue;
                                if (Boolean.getBoolean("db.tx.rollback.logstack")) {
                                    logger.error((Throwable)new Exception("Transaction rollback!"));
                                }
                                if (commitNested && this.transactionTree.savepoint != null) {
                                    tm.conRW.rollback(this.transactionTree.savepoint);
                                    continue;
                                }
                                if (this.transactionTree.savepoint != null) {
                                    this.transactionTree.savepoint = null;
                                }
                                tm.conRW.rollback();
                            }
                            finally {
                                if (commitCurrent) continue;
                                tm.closeConnection();
                            }
                        }
                        if (!commitNested) {
                            commitListenerExceptions.addAll(this.onRollbacked());
                        }
                    } else {
                        if (!commitNested) {
                            commitListenerExceptions.addAll(this.preCommit());
                        }
                        for (TransactionManager tm : this.tmMap.values()) {
                            try {
                                if (tm.conRW == null || tm.conRW.hasCallClosed() || tm.conRW.getAutoCommit()) continue;
                                for (Map.Entry<String, Connection> entry : tm.conRW.getArchiveConMap().entrySet()) {
                                    Connection archiveCon = entry.getValue();
                                    if (archiveCon == null) continue;
                                    ConnectionOptimizer.skipMoreResults(archiveCon, tm.conRW.getDBType());
                                }
                                ConnectionOptimizer.skipMoreResults(tm.conRW, tm.conRW.getDBType());
                                if (!tm.conRW.isWrited()) continue;
                                if (commitNested) {
                                    this.transactionTree.savepoint = tm.conRW.setSavepoint();
                                    continue;
                                }
                                if (this.transactionTree.savepoint != null) {
                                    this.transactionTree.savepoint = null;
                                }
                                tm.conRW.commit();
                            }
                            finally {
                                if (commitCurrent) continue;
                                tm.closeConnection();
                            }
                        }
                        if (!commitNested) {
                            commitListenerExceptions.addAll(this.onCommitted());
                        }
                    }
                } else {
                    commitListenerExceptions.addAll(this.preCommit());
                    for (TransactionManager tm : this.tmMap.values()) {
                        try {
                            if (tm.conRW == null || tm.conRW.hasCallClosed() || tm.conRW.getAutoCommit()) continue;
                            for (Map.Entry<String, Connection> entry : tm.conRW.getArchiveConMap().entrySet()) {
                                Connection archiveCon = entry.getValue();
                                if (archiveCon == null) continue;
                                ConnectionOptimizer.skipMoreResults(archiveCon, tm.conRW.getDBType());
                            }
                            ConnectionOptimizer.skipMoreResults(tm.conRW, tm.conRW.getDBType());
                            if (!tm.conRW.isWrited()) continue;
                            tm.conRW.commit();
                        }
                        finally {
                            tm.closeConnection();
                        }
                    }
                    commitListenerExceptions.addAll(this.onCommitted());
                }
            }
            pair.setKey(this.parent);
            if (commitCurrent) break block43;
            try {
                this.txStat.exit(this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.ended = true;
            break block43;
            catch (Throwable e2222222) {
                try {
                    this.endError = this.recordThrowMes(e2222222);
                    if (e2222222 instanceof RuntimeException) {
                        pair.setValue((RuntimeException)e2222222);
                    } else {
                        pair.setValue((RuntimeException)((Object)new KDException(e2222222, BosErrorCode.sQL, new Object[]{e2222222.getMessage()})));
                    }
                    pair.setKey(this.parent);
                    if (commitCurrent) break block43;
                }
                catch (Throwable throwable) {
                    pair.setKey(this.parent);
                    if (!commitCurrent) {
                        try {
                            this.txStat.exit(this);
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        this.ended = true;
                    }
                    throw throwable;
                }
                try {
                    this.txStat.exit(this);
                }
                catch (Throwable e2222222) {
                    // empty catch block
                }
                this.ended = true;
            }
        }
        if (!commitListenerExceptions.isEmpty() && (exception = (RuntimeException)pair.getValue()) == null) {
            exception = CommitListenerException.unwrapExceptionList(commitListenerExceptions);
            this.endError = this.recordThrowMes((Throwable)exception);
            pair.setValue((RuntimeException)exception);
        }
        return pair;
    }

    private String recordThrowMes(Throwable th) {
        StringWriter sw = new StringWriter();
        sw.append("///").append(Thread.currentThread().getName()).append('#').append(new Date().toString()).append('#');
        th.printStackTrace(new PrintWriter(sw));
        sw.append("///");
        return sw.toString();
    }

    String getWrittenRouteKey() {
        if (this.inTX && this.transRootCtx.tmMap.size() > 0) {
            for (TransactionManager tm : this.transRootCtx.tmMap.values()) {
                if (tm.conRW == null || !tm.conRW.isWrited()) continue;
                return tm.rw_routeKey;
            }
        }
        return null;
    }

    private DelegateConnection getWrittenConnection() {
        if (this.inTX && this.transRootCtx.tmMap.size() > 0) {
            for (TransactionManager tm : this.transRootCtx.tmMap.values()) {
                if (tm.conRW == null || !tm.conRW.isWrited()) continue;
                return tm.conRW;
            }
        }
        return null;
    }

    void checkMultiDBWrited() {
        if (this.inTX && this.tmMap.size() > 0) {
            HashSet<String> sharedWrittedDbKey = new HashSet<String>(2);
            TreeMap<String, ArrayList<List<String>>> routeWriteSQLMap = new TreeMap<String, ArrayList<List<String>>>();
            for (TransactionManager tm : this.tmMap.values()) {
                try {
                    if (tm.rootCtx != this || tm.conRW == null || !tm.conRW.isWrited() || tm.conRW.getAutoCommit()) continue;
                    sharedWrittedDbKey.add(tm.rw_routeKey);
                    ArrayList<List<String>> list = (ArrayList<List<String>>)routeWriteSQLMap.get(tm.rw_routeKey);
                    if (list == null) {
                        list = new ArrayList<List<String>>();
                        list.add(tm.conRW.getWriteSqlList());
                        routeWriteSQLMap.put(tm.rw_routeKey, list);
                        continue;
                    }
                    list.add(tm.conRW.getWriteSqlList());
                }
                catch (SQLException sQLException) {}
            }
            if (sharedWrittedDbKey.size() > 1) {
                StringBuilder msg = new StringBuilder(1024);
                msg.append("TX can not write more than one database: ").append(sharedWrittedDbKey);
                msg.append("\r\ntmMap=").append(this.tmMap);
                msg.append("\r\n").append(tip);
                msg.append("\r\ncurrentThread=").append(Thread.currentThread());
                msg.append("\r\ncurrentTX=").append(this);
                msg.append("\r\n[write-sql]\r\n");
                msg.append(routeWriteSQLMap);
                throw new KDException(BosErrorCode.sQL, new Object[]{msg.toString()});
            }
        }
    }

    @Override
    public void close() throws Exception {
        Pair<TXContext, RuntimeException> ret = this.end();
        if (ret != null) {
            if (ret.getValue() != null) {
                throw ret.getValue();
            }
            this.onEnded();
        }
    }

    TXHandle getHandle() {
        return this.handle;
    }

    void setHandle(TXHandle handle) {
        this.handle = handle;
    }

    public TXContext parent() {
        return this.parent;
    }

    TXStat getStat() {
        return this.txStat;
    }

    String getTag() {
        return this.tag;
    }

    Propagation propagation() {
        return this.propagation;
    }

    public long id() {
        return this.id;
    }

    void incRefCount(String tag) {
        ++this.refCount;
        if (this.refTags == null) {
            this.refTags = new LinkedList();
            this.refTags.add(this.tag);
        }
        this.refTags.add(tag);
        this.tag = tag;
    }

    private int decRefCount() {
        if (this.refTags != null && !this.refTags.isEmpty()) {
            this.tag = this.refTags.removeLast();
        }
        return --this.refCount;
    }

    public String toString() {
        TXContext ctx = this;
        int level = 1;
        while (ctx.parent != null) {
            ctx = ctx.parent;
            ++level;
        }
        String s = this.getClass().getSimpleName() + "." + this.id + ":tag=" + this.tag + ", level=" + level + ", propagation=" + (Object)((Object)this.propagation) + ", rollback=" + this.isRollback() + ", halt=" + this.halt + ", ended=" + this.ended;
        if (log_stack) {
            s = s + "\n[CreateThreadStack]\n" + this.txStack;
        }
        if (this.endError != null) {
            s = s + "\n[EndError]\n" + this.endError;
        }
        return s;
    }

    static {
        ConfigurationUtil.observeBoolean((String)"db.tx.log.stack", (boolean)log_stack, v -> {
            log_stack = v;
        });
        ConfigurationUtil.observeInteger((String)"db.thread.getMaxConnectionCount", (int)getMaxConnectionCount, v -> {
            getMaxConnectionCount = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.tx.log.setRollback", (boolean)logSetRollback, v -> {
            logSetRollback = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.tx.throwCommitListenerExcepts", (boolean)throwCommitListenerExcepts, v -> {
            throwCommitListenerExcepts = v;
        });
    }

    private static class TransactionManager {
        private Set<String> updatedTables = new HashSet<String>();
        private TXContext ctx;
        private TXContext rootCtx;
        private DataSourceInfoProvider cp;
        private String rw_routeKey;
        private Map<String, DelegateConnection> conR_map = new HashMap<String, DelegateConnection>();
        private DelegateConnection conRW;

        private TransactionManager(String rw_routeKey, DataSourceInfoProvider cp, TXContext ctx) {
            this.rw_routeKey = rw_routeKey;
            this.cp = cp;
            this.ctx = ctx;
            this.rootCtx = ctx.transRootCtx;
        }

        private void closeConnection() throws SQLException {
            try {
                for (DelegateConnection conR : this.conR_map.values()) {
                    conR.realClose();
                }
            }
            finally {
                if (this.conRW != null) {
                    this.conRW.realClose();
                }
            }
        }

        private boolean canQueryOnReadOnlyDB(String accountId, String ... useTables) {
            if (SplittingReadConfig.isSplittingReadEnable()) {
                if (useTables != null && useTables.length > 0) {
                    for (String table : useTables) {
                        if (!this.updatedTables.contains(table.trim().toLowerCase())) continue;
                        return false;
                    }
                }
                return SplittingReadConfig.allowSplittingRead(accountId, useTables);
            }
            return false;
        }

        private void checkHalt() {
            if (this.rootCtx.halt) {
                IllegalArgumentException e = new IllegalArgumentException(Resources.get((String)"bos-dbengine", (String)"TXContext_0", (String)"TX\u5df2\u7ed3\u675f\uff0c\u4e0d\u53ef\u518d\u83b7\u53d6\u6570\u636e\u8fde\u63a5\u3002", (Object[])new Object[0]));
                logger.error((Throwable)e);
                throw e;
            }
        }

        private DelegateConnection getConnection(String tenantId, String r_routeKey, String accountId, boolean requestForReadOnly, SplittingReadWriteMode threadRWMode, String mainTable, String ... useTables) {
            DelegateConnection con;
            block34: {
                this.checkHalt();
                boolean readOnly = false;
                if (requestForReadOnly) {
                    switch (threadRWMode) {
                        case auto: {
                            if (!this.canQueryOnReadOnlyDB(accountId, useTables)) break;
                            readOnly = true;
                            break;
                        }
                        case read: {
                            readOnly = true;
                            break;
                        }
                        case write: {
                            DisCardUtil.discard();
                        }
                    }
                } else if (mainTable != null) {
                    this.updatedTables.add(mainTable);
                }
                con = readOnly ? this.conR_map.get(r_routeKey) : this.conRW;
                String routeKey = readOnly ? r_routeKey : this.rw_routeKey;
                DBConfig dbConfig = null;
                try {
                    if (con != null && !con.isClosed()) break block34;
                    if (this.ctx.inTX && !readOnly && con != null && con.isWrited()) {
                        String msg = Resources.get((String)"bos-dbengine", (String)"TXContext_1", (String)"[\u8bfb\u5199\u578b]\u6570\u636e\u5e93\u8fde\u63a5\u5df2\u65ad\u5f00: ", (Object[])new Object[0]) + con;
                        throw new RuntimeException(msg);
                    }
                    DataSourceInfo dsi = this.cp.getDataSourceInfo(tenantId, routeKey, accountId, readOnly);
                    dbConfig = dsi.getDBConfig();
                    boolean pReadOnly = readOnly;
                    ParallelConnectionSupplier pcs = () -> this.cp.getDataSourceInfo(tenantId, routeKey, accountId, pReadOnly).getDataSource().getConnection();
                    ShardingArchiveConnectionSupplier acs = shardingArchiveRoute -> this.cp.getDataSourceInfo(tenantId, shardingArchiveRoute, accountId, pReadOnly).getDataSource().getConnection();
                    try (TraceSpan ts = Tracer.create((String)"DB", (String)"dogetconnection");){
                        int wait = 100;
                        for (int i = 0; i < 8; ++i) {
                            try {
                                con = new DelegateConnection(this.ctx, dsi.getDataSource().getConnection(), routeKey, readOnly, dbConfig, pcs, acs);
                                if (DataSourceURLs.isPgUseCursorFetch() && TXImplicitObject.isPgSeries(con.getDBType()) && con.getAutoCommit() && !XDBExternal.isNotSupportedAlways()) {
                                    con.__setAutoCommit(false);
                                }
                                break;
                            }
                            catch (Exception e) {
                                Thread.sleep(wait);
                                wait *= 2;
                                if (i != 7) continue;
                                throw new KDException(BosErrorCode.sQL, new Object[]{"Can't get connection from pool, " + e.getMessage()});
                            }
                        }
                    }
                    if (readOnly) {
                        this.conR_map.put(r_routeKey, con);
                    } else {
                        this.conRW = con;
                    }
                }
                catch (KDException e) {
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (con != null && !con.hasCallClosed()) {
                            con.realClose();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new RuntimeException("getConnection failed routeKey=" + routeKey + "@" + dbConfig + ": " + e.getMessage(), e);
                }
            }
            if (con != null) {
                con.incRef();
            }
            return con;
        }

        public String toString() {
            return "TM{rw_routeKey:" + this.rw_routeKey + ", updatedTables:" + this.updatedTables + ", conR_map:" + this.conR_map + ", conRW:" + this.conRW + "}";
        }
    }

    private static class TransactionTreeNode {
        private LinkedList<TransactionTreeNode> children = new LinkedList();
        private final TXContext ctx;
        private List<CommitListener> clList = new LinkedList<CommitListener>();
        private boolean rollback;
        private boolean done;

        private TransactionTreeNode(TXContext ctx, TransactionTreeNode parent) {
            this.ctx = ctx;
            if (parent != null) {
                parent.children.add(this);
            }
        }

        public String toString() {
            return this.ctx.toString();
        }
    }

    @FunctionalInterface
    private static interface TransactionTreeWalker {
        public void walk(TransactionTreeNode var1);
    }

    private static class TransactionTree {
        private final Map<TXContext, TransactionTreeNode> allNodes = new HashMap<TXContext, TransactionTreeNode>();
        private final TransactionTreeNode rootNode;
        private Savepoint savepoint;

        private TransactionTree(TXContext rootCtx) {
            this.rootNode = new TransactionTreeNode(rootCtx, null);
            this.allNodes.put(rootCtx, this.rootNode);
        }

        public TransactionTreeNode addChildren(TXContext ctx) {
            TXContext pctx = ctx;
            do {
                if (pctx.propagation != Propagation.NESTED) continue;
                TransactionTreeNode node = this.allNodes.get(pctx);
                if (node == null) {
                    node = new TransactionTreeNode(pctx, this.getParentTransactionTreeNode(pctx));
                    this.allNodes.put(pctx, node);
                }
                return node;
            } while ((pctx = pctx.parent) != this.rootNode.ctx);
            return this.rootNode;
        }

        private TransactionTreeNode getParentTransactionTreeNode(TXContext ctx) {
            TXContext pctx = ctx.parent;
            TransactionTreeNode parent;
            while ((parent = this.allNodes.get(pctx)) == null) {
                pctx = pctx.parent;
            }
            return parent;
        }

        public TransactionTreeNode getStatusRootNode(TXContext ctx) {
            if (ctx == this.rootNode.ctx) {
                return this.rootNode;
            }
            if (ctx.propagation == Propagation.NESTED) {
                return this.allNodes.get(ctx);
            }
            return this.getParentTransactionTreeNode(ctx);
        }

        public void deepWalk(TransactionTreeWalker w) {
            this.doDeepWalk(this.rootNode, w);
        }

        private void doDeepWalk(TransactionTreeNode node, TransactionTreeWalker w) {
            if (!node.children.isEmpty()) {
                Iterator iter = node.children.iterator();
                while (iter.hasNext()) {
                    this.doDeepWalk((TransactionTreeNode)iter.next(), w);
                }
            }
            w.walk(node);
        }
    }
}

