/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.tx;

import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.bundle.Resources;
import kd.bos.db.tx.Pair;
import kd.bos.db.tx.Propagation;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TXHandle
implements AutoCloseable {
    private static Log logger = LogFactory.getLog(TXHandle.class);
    private static final String AUDIT_TX_DURATION_NAME = "tx_duration";
    private TXContext tc;
    private Auditable audit_max_writted_duration;

    public static TXHandle get() {
        return TX.__getTXContext().getHandle();
    }

    TXHandle(TXContext tc) {
        this.tc = tc;
        tc.setHandle(this);
    }

    public TXHandle setRollback(boolean rollback) {
        if (rollback != this.tc.isRollback()) {
            this.tc.setRollback(rollback);
        }
        return this;
    }

    public boolean isRollback() {
        return this.tc.isRollback();
    }

    public void markRollback() {
        this.setRollback(true);
    }

    @SdkInternal
    public String getTag() {
        return this.tc.getTag();
    }

    public Propagation getPropagation() {
        return this.tc.propagation();
    }

    public void commit() {
        Pair<TXContext, RuntimeException> ret = this.tc.commitCurrent();
        if (ret.getValue() != null) {
            throw ret.getValue();
        }
        this.setRollback(false);
    }

    @Deprecated
    @SdkInternal
    public void end() {
        this.close();
    }

    @Override
    public void close() {
        try {
            TXContext cur = TX.getCtx();
            if (cur != this.tc) {
                IllegalStateException e = new IllegalStateException(Resources.get((String)"bos-dbengine", (String)"TXHandle_0", (String)"\u4e8b\u52a1\u7ed3\u675f\u4e0d\u6b63\u786e(\u671f\u671b=%1$s, \u5b9e\u9645=%2$s)", (Object[])new Object[]{this.tc, cur}));
                logger.error((Throwable)e);
                throw e;
            }
            TX.doEnd();
        }
        finally {
            if (this.audit_max_writted_duration != null) {
                this.audit_max_writted_duration.close();
            }
            this.audit_max_writted_duration = null;
        }
    }

    @SdkInternal
    public void __beginOfWrittedDuration() {
        if (this.audit_max_writted_duration == null) {
            this.audit_max_writted_duration = Audit.audit((String)AUDIT_TX_DURATION_NAME, (Object[])new Object[]{this.tc});
        }
    }

    @SdkInternal
    public String toString() {
        return this.tc.toString() + " [PARENT]=" + this.tc.parent();
    }
}

