/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dc.mc;

import java.util.List;
import java.util.Map;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBObject;
import kd.bos.dc.mc.TripInfo;
import kd.bos.dc.mc.impl.LoginMCServiceApiImpl;
import kd.bos.dc.mc.impl.LoginMCServiceDbImpl;
import kd.bos.dc.mc.impl.LoginMCServiceZKImpl;
import kd.bos.dc.mc.tenant.LptaParameter;
import kd.bos.mc.webclient.WebClientFiles;
import kd.bos.tenant.TenantInfo;

public interface LoginMCService {
    public static LoginMCService create() {
        String typeString = System.getProperty("mc.type");
        if ("API".equalsIgnoreCase(typeString)) {
            return new LoginMCServiceApiImpl();
        }
        if ("ZK".equalsIgnoreCase(typeString)) {
            return new LoginMCServiceZKImpl();
        }
        if ("CUSTOM".equalsIgnoreCase(typeString)) {
            String className = System.getProperty("loginmcservice.customimpl.classname", "kd.bos.dc.mc.impl.LoginMCServiceZKImpl");
            try {
                return (LoginMCService)Class.forName(className).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException var3) {
                return new LoginMCServiceDbImpl();
            }
        }
        return new LoginMCServiceDbImpl();
    }

    public static String getCacheCombKey(String tenantNo, String sandboxNo) {
        return tenantNo + "::::" + sandboxNo;
    }

    public LptaParameter getLptaParameter(Account var1);

    public List<Account> getAllAccounts(String var1);

    public Account getSingleAccount(String var1, String var2);

    public List<TenantInfo> getWholeTenantsByCurrentEnv();

    public List<TripInfo> getTripInfo(String var1);

    public WebClientFiles getWebClientFiles(String var1, String var2) throws Exception;

    public void setWebClientFiles(WebClientFiles var1) throws Exception;

    public void setMCData(String var1, String var2, String var3) throws Exception;

    public String getMCData(String var1, String var2) throws Exception;

    public List<DBObject> getDbInstanceList(String var1) throws Exception;

    public Boolean getGrayEnvironmentInfo() throws Exception;

    public void updateGrayUserInfo(Map<String, Object> var1) throws Exception;

    public Map<String, Object> getGrayAppGroup() throws Exception;

    public void upgradeGrayStrategy(Map<String, Object> var1) throws Exception;

    default public String callMcApiService(String url, String contentType, Map<String, String> header, Map<String, Object> params, int timeOut) throws Exception {
        return null;
    }
}

