/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dc.mc.impl;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBObject;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.dc.mc.TripInfo;
import kd.bos.dc.mc.tenant.LptaParameter;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCApiUtil;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mc.webclient.File;
import kd.bos.mc.webclient.WebClientFiles;
import kd.bos.security.KDCallerInfo;
import kd.bos.security.KDReflection;
import kd.bos.security.PermissionManager;
import kd.bos.tenant.TenantInfo;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.DBResources;

public class LoginMCServiceDbImpl
implements LoginMCService {
    private Log logger = LogFactory.getLog(LoginMCServiceDbImpl.class);
    private static final String MC_API_GETWEBCLIENTFILESSERVICE = "/kapi/app/mc/GetWebClientFilesService";
    private static final String MC_API_WEBCLIENTFILESSAVESERVICE = "/kapi/app/mc/WebClientFilesSaveService";
    private static final String MC_API_GET_MC_DATA = "/datasave/get";
    private static final String MC_API_SET_MC_DATA = "/datasave/set";
    private static final String MC_API_GETGRAYENVIRONMENTINFO = "/kapi/app/mc/getGrayEnvironmentInfo";
    private static final String MC_API_UPDATEGRAYUSERINFO = "/kapi/app/mc/updateGrayUserInfo";
    private static final String MC_API_GETGRAYAPPGROUP = "/kapi/app/mc/getGrayAppGroup";
    private static final String MC_API_UPGRADEGRAYSTRATEGY = " /kapi/app/mc/upgradeGrayStrategy";

    private String[] getMCMainDBInfo() {
        String driver = System.getProperty("mcdbdriver_ksql");
        String url = System.getProperty("mcdburl_ksql");
        url = Encrypters.decode((String)url);
        return new String[]{driver, url};
    }

    private static void forbidCustomerCalling() {
        KDCallerInfo caller;
        if (KDReflection.isEnableSecurity() && KDReflection.isCustomerClass((Class)(caller = KDReflection.getCallerClassUntilNot((Class[])new Class[]{AccountUtils.class, LoginMCServiceDbImpl.class})).getCallerClass())) {
            String msg = DBResources.getString((String)"\u7981\u6b62\u8c03\u7528LoginMCServiceDbImpl: ", (String)"LoginMCServiceDbImpl_0", (String)"bos-dbengine", (Object[])new Object[0]) + caller.getCallerClass().getName() + "#" + KDReflection.getCallerMethodName((int)caller.getCallStackDepth());
            throw KDReflection.securityException((String)msg);
        }
    }

    public String[] getTenantDBInfo(String tenantid, String sandboxId1) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block8: {
            String[] stringArray;
            PermissionManager.check();
            String[] mcDBInfo = this.getMCMainDBInfo();
            conn = null;
            stmt = null;
            rs = null;
            try {
                Class.forName(mcDBInfo[0]);
                conn = DriverManager.getConnection(mcDBInfo[1]);
                String sql = "select fdbip,fdbport,fdbinstance,fdbuser,fdbpassword,fdbtype from t_mc_datacenter where ftenantId=? and (froutekey in ('','basedata'))";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, tenantid);
                rs = stmt.executeQuery();
                if (!rs.next()) break block8;
                String[] dbInfo = new String[2];
                String user = rs.getString("fdbuser");
                String password = rs.getString("fdbpassword");
                password = Encrypters.decode((String)password);
                int dbtype = rs.getInt("fdbtype");
                String ip = rs.getString("fdbip");
                String port = rs.getString("fdbport");
                String instance = rs.getString("fdbinstance");
                if (dbtype == 0) {
                    dbInfo[0] = "oracle.jdbc.driver.OracleDriver";
                    dbInfo[1] = "jdbc:oracle:thin:" + user + "/" + password + "@" + ip + ":" + port + ":" + instance;
                } else if (dbtype == 2) {
                    dbInfo[0] = "com.mysql.cj.jdbc.Driver";
                    dbInfo[1] = "jdbc:mysql://" + ip + ":" + port + "/" + instance + "?user=" + user + "&password=" + password;
                } else {
                    dbInfo[0] = "org.postgresql.Driver";
                    dbInfo[1] = "jdbc:postgresql://" + ip + ":" + port + "/" + instance + "?user=" + user + "&password=" + password;
                }
                stringArray = dbInfo;
            }
            catch (Exception e) {
                try {
                    this.logger.error("Can't connect MC", (Throwable)e);
                    throw new KDException((Throwable)e, BosErrorCode.configNotFound, new Object[]{DBResources.getString((String)"\u65e0\u6cd5\u83b7\u53d6\u79df\u6237\u6570\u636e\u5e93\u8fde\u63a5:", (String)"LoginMCServiceDbImpl_1", (String)"bos-dbengine", (Object[])new Object[0]) + tenantid});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup(rs, stmt, conn);
            return stringArray;
        }
        SQLUtils.cleanup(rs, stmt, conn);
        return new String[0];
    }

    @Override
    public LptaParameter getLptaParameter(Account currentCenter) {
        PermissionManager.check();
        LptaParameter para = null;
        String[] mcDBInfo = this.getMCMainDBInfo();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Class.forName(mcDBInfo[0]);
            conn = DriverManager.getConnection(mcDBInfo[1]);
            String sql = "select FExpiration, FSecret, FIsLMBCSEncode from t_mc_tenants where ftenantid = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, currentCenter.getTenantId());
            rs = stmt.executeQuery();
            if (rs.next()) {
                para = new LptaParameter(currentCenter.getTenantId(), rs.getString("FSecret"), rs.getString("FExpiration"), rs.getString("FIsLMBCSEncode"));
            }
        }
        catch (Exception e) {
            try {
                this.logger.error("Can't connect MC", (Throwable)e);
                throw new KDException((Throwable)e, BosErrorCode.configNotFound, new Object[]{DBResources.getString((String)"\u83b7\u53d6\u79df\u6237SSO\u4fe1\u606f\u9519\u8bef\u3002", (String)"LoginMCServiceDbImpl_2", (String)"bos-dbengine", (Object[])new Object[0])});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, stmt, conn);
        return para;
    }

    @Override
    public List<Account> getAllAccounts(String tenantNo) {
        PermissionManager.check();
        ArrayList<Account> returnList = new ArrayList<Account>();
        String[] mcDBInfo = this.getMCMainDBInfo();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = MCDBUtil.getConnection(mcDBInfo[0], mcDBInfo[1]);
            String sql = "select t.fid, te.fname ,t.FNumber,t.FDefault,t.FDbIP,t.FDbPassword,t.FDbPort,t.FDbType,t.FDbUser from t_mc_datacenter t,t_mc_tenants te where t.FTenantID=te.Fid and te.FNumber=?  ";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, tenantNo);
            rs = stmt.executeQuery();
            while (rs.next()) {
                Account center = new Account();
                center.setAccountId(rs.getString("fid"));
                center.setAccountName(rs.getString("fname"));
                center.setAccountNumber(rs.getString("FNumber"));
                if ("1".equalsIgnoreCase(rs.getString("FDefault"))) {
                    center.setDefault(true);
                } else {
                    center.setDefault(false);
                }
                returnList.add(center);
            }
        }
        catch (Exception e) {
            try {
                this.logger.error("Can't connect MC", (Throwable)e);
                throw new KDException((Throwable)e, BosErrorCode.configNotFound, new Object[]{DBResources.getString((String)"\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u4fe1\u606f\u9519\u8bef\u3002", (String)"LoginMCServiceDbImpl_3", (String)"bos-dbengine", (Object[])new Object[0])});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, stmt, conn);
        return returnList;
    }

    @Override
    public Account getSingleAccount(String accountId, String tenantId) {
        PermissionManager.check();
        Account account = null;
        String[] mcDBInfo = this.getMCMainDBInfo();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = MCDBUtil.getConnection(mcDBInfo[0], mcDBInfo[1]);
            String sql = "select t.fid, te.fname ,t.FNumber,t.FDefault,t.FDbIP,t.FDbPassword,t.FDbPort,t.FDbType,t.FDbUser from t_mc_datacenter t,t_mc_tenants te where t.FTenantID=te.Fid and t.FID=? ";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, accountId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                account = new Account();
                account.setAccountId(rs.getString("fid"));
                account.setAccountName(rs.getString("fname"));
                account.setAccountNumber(rs.getString("FNumber"));
                if ("1".equalsIgnoreCase(rs.getString("FDefault"))) {
                    account.setDefault(true);
                } else {
                    account.setDefault(false);
                }
                account.setTenantId(tenantId);
            }
        }
        catch (Exception e) {
            try {
                this.logger.error("Can't connect MC", (Throwable)e);
                throw new KDException((Throwable)e, BosErrorCode.configNotFound, new Object[]{DBResources.getString((String)"\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u4fe1\u606f\u9519\u8bef\u3002", (String)"LoginMCServiceDbImpl_3", (String)"bos-dbengine", (Object[])new Object[0])});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, stmt, conn);
        return account;
    }

    @Override
    public List<TenantInfo> getWholeTenantsByCurrentEnv() {
        return null;
    }

    @Override
    public List<TripInfo> getTripInfo(String outsystemflag) {
        return null;
    }

    @Override
    public WebClientFiles getWebClientFiles(String tenantId, String keys) throws Exception {
        PermissionManager.check();
        if (StringUtils.isEmpty((String)tenantId)) {
            throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230tenantId\u4e3a\u7a7a", (String)"LoginMCServiceDbImpl_4", (String)"bos-dbengine", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)keys)) {
            throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230keys\u4e3a\u7a7a", (String)"LoginMCServiceDbImpl_5", (String)"bos-dbengine", (Object[])new Object[0]));
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("tenantid", tenantId);
        map.put("keys", keys);
        Object obj = MCApiUtil.getMCAPIInfo(MC_API_GETWEBCLIENTFILESSERVICE, true, null, map);
        if (obj instanceof String) {
            return null;
        }
        Map centerMap = (Map)obj;
        return MCApiUtil.getWebClientFiles(centerMap);
    }

    @Override
    public void setWebClientFiles(WebClientFiles webClientFiles) throws Exception {
        PermissionManager.check();
        if (webClientFiles != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantid", webClientFiles.getTenantId());
            map.put("keys", webClientFiles.getKeys());
            map.put("isv", webClientFiles.getIsv());
            map.put("dcid", webClientFiles.getDcid());
            map.put("accountId", webClientFiles.getAccountId());
            map.put("files", this.getFilesMap(webClientFiles.getFiles()));
            map.put("relativePath", webClientFiles.getIsRelativePath());
            Object object = MCApiUtil.getMCAPIInfo(MC_API_WEBCLIENTFILESSAVESERVICE, true, null, map, MCApiUtil.getCustTimeout());
        }
    }

    private Object getFilesMap(List<File> files) {
        ArrayList List2 = new ArrayList();
        if (files != null) {
            for (File file : files) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("destpath", file.getDestPath());
                map.put("fileserverpath", file.getFileServerPath());
                map.put("name", file.getName());
                map.put("servertype", file.getServerType());
                map.put("needupdate", file.isNeedUpdate());
                List2.add(map);
            }
        }
        return List2;
    }

    @Override
    public void setMCData(String DCID, String key, String value) throws Exception {
        PermissionManager.check();
        if (StringUtils.isEmpty((String)DCID)) {
            throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230DCID\u4e3a\u7a7a", (String)"LoginMCServiceDbImpl_6", (String)"bos-dbengine", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)key)) {
            throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230key\u4e3a\u7a7a", (String)"LoginMCServiceDbImpl_7", (String)"bos-dbengine", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)value)) {
            throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230value\u4e3a\u7a7a", (String)"LoginMCServiceDbImpl_8", (String)"bos-dbengine", (Object[])new Object[0]));
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("DCID", DCID);
        map.put("key", key);
        map.put("value", value);
        Object obj = MCApiUtil.getMCAPIInfo(MC_API_SET_MC_DATA, true, null, map);
    }

    @Override
    public String getMCData(String DCID, String key) throws Exception {
        String returnValue;
        block5: {
            PermissionManager.check();
            returnValue = null;
            if (StringUtils.isEmpty((String)DCID)) {
                throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230DCID\u4e3a\u7a7a", (String)"LoginMCServiceDbImpl_6", (String)"bos-dbengine", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)key)) {
                throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230key\u4e3a\u7a7a", (String)"LoginMCServiceDbImpl_7", (String)"bos-dbengine", (Object[])new Object[0]));
            }
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("DCID", DCID);
            map.put("key", key);
            try {
                Object obj = MCApiUtil.getMCAPIInfo(MC_API_GET_MC_DATA, true, null, map);
                if (obj != null) {
                    returnValue = obj.toString();
                }
            }
            catch (KDException e) {
                if ("626".equals(e.getErrorCode().getCode())) break block5;
                throw e;
            }
        }
        return returnValue;
    }

    @Override
    public List<DBObject> getDbInstanceList(String dataCenterId) throws Exception {
        PermissionManager.check();
        ArrayList<DBObject> returnList = new ArrayList<DBObject>();
        if (StringUtils.isEmpty((String)dataCenterId)) {
            throw new Exception(DBResources.getString((String)"\u53c2\u6570\u9519\u8bef,\u68c0\u6d4b\u5230dataCenterId\u4e3a\u7a7a", (String)"LoginMCServiceDbImpl_9", (String)"bos-dbengine", (Object[])new Object[0]));
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("dataCenterId", dataCenterId);
        try {
            Object obj = MCApiUtil.getMCAPIInfo("/kapi/app/mc/GetDbInstanceListService", true, null, map);
            if (obj != null) {
                List dbMapList = (List)obj;
                for (Map dbMap : dbMapList) {
                    DBObject dbObject = new DBObject();
                    dbObject.setName(MCApiUtil.getString(dbMap.get("name")));
                    dbObject.setNumber(MCApiUtil.getString(dbMap.get("number")));
                    returnList.add(dbObject);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            throw e;
        }
        return returnList;
    }

    @Override
    public Boolean getGrayEnvironmentInfo() throws Exception {
        try {
            String clusterName = Instance.getClusterName();
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("clusterNumber", clusterName);
            Object obj = MCApiUtil.getMCAPIInfo(MC_API_GETGRAYENVIRONMENTINFO, true, null, map);
            if (obj != null) {
                Map objectMap = (Map)obj;
                String isBGDeploy = MCApiUtil.getString(objectMap.get("isBGDeploy"));
                if (StringUtils.isNotEmpty((String)isBGDeploy) && Boolean.parseBoolean(isBGDeploy)) {
                    return true;
                }
                String isCurrentGreen = MCApiUtil.getString(objectMap.get("isCurrentGreen"));
                if (StringUtils.isNotEmpty((String)isCurrentGreen) && Boolean.parseBoolean(isCurrentGreen)) {
                    return true;
                }
                return false;
            }
        }
        catch (KDException e) {
            this.logger.info(e.getMessage());
        }
        return false;
    }

    @Override
    public void updateGrayUserInfo(Map<String, Object> map) throws Exception {
        PermissionManager.check();
        try {
            MCApiUtil.getMCAPIInfo(MC_API_UPDATEGRAYUSERINFO, true, null, map);
        }
        catch (KDException e) {
            this.logger.info(e.getMessage());
            throw e;
        }
    }

    @Override
    public Map<String, Object> getGrayAppGroup() throws Exception {
        PermissionManager.check();
        try {
            String clusterName = Instance.getClusterName();
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("clusterNumber", clusterName);
            Object obj = MCApiUtil.getMCAPIInfo(MC_API_GETGRAYAPPGROUP, true, null, map);
            if (obj != null) {
                Map objectMap = (Map)obj;
                return objectMap;
            }
        }
        catch (KDException e) {
            this.logger.info(e.getMessage());
            throw e;
        }
        return null;
    }

    @Override
    public void upgradeGrayStrategy(Map<String, Object> userMap) throws Exception {
        PermissionManager.check();
        try {
            MCApiUtil.getMCAPIInfo(MC_API_UPGRADEGRAYSTRATEGY, true, null, userMap);
        }
        catch (KDException e) {
            this.logger.info(e.getMessage());
            throw e;
        }
    }

    @Override
    public String callMcApiService(String url, String contentType, Map<String, String> header, Map<String, Object> params, int timeOut) throws Exception {
        PermissionManager.check();
        try {
            return MCApiUtil.callMcApiService(url, contentType, header, params);
        }
        catch (KDException e) {
            this.logger.info(e.getMessage());
            throw e;
        }
    }
}

