/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dc.utils;

import com.alibaba.druid.pool.DataSourceDisableException;
import com.alibaba.druid.pool.DruidDataSource;
import java.sql.Connection;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.bundle.Resources;
import kd.bos.db.datasource.DataSourceChangedLogger;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.mc.DriverType;
import kd.bos.ksql.extension.KSQLExtensionsRegister;
import kd.bos.security.KDCallerInfo;
import kd.bos.security.KDReflection;
import kd.bos.security.PermissionManager;
import kd.bos.util.DisCardUtil;
import kd.bos.util.StringUtils;

public class MCDBUtil {
    private static Map<String, DruidDataSource> dsMap = new ConcurrentHashMap<String, DruidDataSource>();
    public static boolean IS_IN_TEST_ENV = false;
    private static Map<Integer, Driver> driverMap = new ConcurrentHashMap<Integer, Driver>();

    public static void removeDataSouce(String accountId) {
        PermissionManager.check();
        if (accountId == null) {
            return;
        }
        DataSourceChangedLogger.log("MCDBUtil on remove datasource, accountId=" + accountId);
        String prefix = accountId + '#';
        for (String key : new ArrayList<String>(dsMap.keySet())) {
            DataSourceChangedLogger.log("MCDBUtil check key with prefix " + prefix + ": " + key);
            if (!key.startsWith(prefix)) continue;
            DruidDataSource ds = dsMap.remove(key);
            DataSourceChangedLogger.log("MCDBUtil remove datasource: " + key);
            if (ds == null) continue;
            try {
                DataSourceChangedLogger.log("MCDBUtil close datasource: " + ds);
                ds.close();
            }
            catch (Exception e) {
                DataSourceChangedLogger.log("MCDBUtil close datasource error: " + e.getMessage());
                DisCardUtil.discard();
            }
        }
    }

    public static Connection getConnection(Account currentAccount, Properties properties) {
        if (currentAccount == null) {
            return null;
        }
        MCDBUtil.fixProperties(properties);
        try {
            String key = MCDBUtil.createDataSourceKey(currentAccount, properties);
            DruidDataSource ds = dsMap.get(key);
            if (ds == null) {
                MCDBUtil.initalDataSource(currentAccount, properties);
                ds = dsMap.get(key);
            } else if (ds.isClosed()) {
                dsMap.remove(key);
                MCDBUtil.initalDataSource(currentAccount, properties);
                ds = dsMap.get(key);
            }
            return KSQLExtensionsRegister.handleLoginConnectionAfterInit((Connection)ds.getConnection());
        }
        catch (Throwable e) {
            if (e instanceof DataSourceDisableException) {
                String msg = "Get db connection failed, datasource was closed(pwd changed or tenant removed), please retry.";
                DataSourceChangedLogger.log(msg);
                throw new RuntimeException(msg, e);
            }
            String msg = "Get db connection failed: " + e.getMessage();
            DataSourceChangedLogger.log(msg);
            throw new RuntimeException(msg, e);
        }
    }

    public static void initalDataSource(Account currentAccount, Properties properties) {
        PermissionManager.check();
        MCDBUtil.fixProperties(properties);
        String key = MCDBUtil.createDataSourceKey(currentAccount, properties);
        dsMap.computeIfAbsent(key, k -> MCDBUtil.getDataSource(properties));
    }

    private static DruidDataSource getDataSource(Properties properties) {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUrl(properties.getProperty("url"));
        dataSource.setUsername(properties.getProperty("username"));
        dataSource.setPassword(properties.getProperty("password"));
        dataSource.setDriverClassName(properties.getProperty("driverClassName"));
        dataSource.setConnectProperties(properties);
        dataSource.setInitialSize(2);
        dataSource.setMinIdle(1);
        dataSource.setMaxActive(MCDBUtil.getMaxActive());
        dataSource.setRemoveAbandoned(true);
        dataSource.setRemoveAbandonedTimeout(600);
        dataSource.setMaxWait(20000L);
        dataSource.setTimeBetweenEvictionRunsMillis(20000L);
        dataSource.setValidationQuery("select  1 from t_open_3rdapps");
        dataSource.setTestWhileIdle(true);
        dataSource.setTestOnBorrow(true);
        DataSourceChangedLogger.log("MCDBUtil createDataSource: " + dataSource.getUrl());
        return dataSource;
    }

    private static int getMaxActive() {
        int defaultVaue = 50;
        String maxActiveString = System.getProperty("login_conection_pools");
        if (StringUtils.isNotEmpty((String)maxActiveString) && StringUtils.isNumericString((String)maxActiveString)) {
            defaultVaue = Integer.parseInt(maxActiveString);
        }
        return defaultVaue;
    }

    public static Connection getConnection(Properties properties) throws Exception {
        KDCallerInfo caller;
        MCDBUtil.fixProperties(properties);
        if (KDReflection.isEnableSecurity() && KDReflection.isCustomerClass((Class)(caller = KDReflection.getCallerClassUntilNot((Class[])new Class[]{MCDBUtil.class})).getCallerClass())) {
            String msg = Resources.get((String)"bos-dbengine", (String)"MCDBUtil_0", (String)"\u7981\u6b62\u83b7\u53d6\u6570\u636e\u8fde\u63a5: ", (Object[])new Object[0]) + caller.getCallerClass().getName() + "#" + KDReflection.getCallerMethodName((int)caller.getCallStackDepth());
            throw KDReflection.securityException((String)msg);
        }
        String cls = properties.getProperty("driverClassName");
        int dbType = MCDBUtil.getDBTypeByDriver(cls);
        Driver driver = driverMap.computeIfAbsent(dbType, dbType2 -> {
            try {
                Map<Integer, Driver> map = driverMap;
                synchronized (map) {
                    return (Driver)Class.forName(cls).newInstance();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Create driver instance  " + cls + " failed: " + e.getMessage(), e);
            }
        });
        if (!properties.containsKey("user")) {
            properties.setProperty("user", properties.getProperty("username"));
        }
        String url = properties.getProperty("url");
        try {
            return KSQLExtensionsRegister.handleLoginConnectionAfterInit((Connection)driver.connect(url, properties));
        }
        catch (Exception e) {
            throw new Exception("MC getConnection error, url=" + url + ": " + e.getMessage(), e);
        }
    }

    private static int getDBTypeByDriver(String driver) {
        return DriverType.getDriverTypeByString(driver).getDbType();
    }

    public static Connection getConnection(String driverName, String url) throws Exception {
        return KSQLExtensionsRegister.handleLoginConnectionAfterInit((Connection)MCDBUtil.getConnection(MCDBUtil.getDBProperties(driverName, url)));
    }

    public static Properties getDBProperties(String driverName, String url) {
        Properties properties = new Properties();
        properties.setProperty("driverClassName", driverName);
        properties.setProperty("url", url);
        return properties;
    }

    private static void fixProperties(Properties properties) {
        if (!properties.containsKey("user")) {
            properties.setProperty("user", properties.getProperty("username"));
        }
        if (!properties.containsKey("username")) {
            properties.setProperty("username", properties.getProperty("user"));
        }
    }

    private static String createDataSourceKey(Account currentAccount, Properties properties) {
        return currentAccount.getAccountId() + '#' + properties.getProperty("username") + '#' + properties.getProperty("password");
    }
}

