/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sdk.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logging.LogTags;
import kd.bos.script.ScriptWrapper;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;

@KSObject(name="Log", namespace="")
public class KLog
implements ScriptWrapper<Log> {
    private static final String DEFAULT_LOG_NAME = "ScriptLog";
    private Log log;

    public KLog() {
        this(DEFAULT_LOG_NAME);
    }

    public KLog(String logName) {
        this.log = LogFactory.getLog((String)logName);
    }

    public KLog(Log log) {
        this.log = log;
    }

    @KSMethod
    public void info(Object msg) {
        this.log.info(KLog.toString(msg));
    }

    @KSMethod
    public void info(Object msg, Object tags) {
        this.log.info(KLog.toLogTags(tags), KLog.toString(msg));
    }

    @KSMethod
    public void debug(Object msg) {
        this.log.debug(KLog.toString(msg));
    }

    @KSMethod
    public void debug(Object msg, Object tags) {
        this.log.debug(KLog.toLogTags(tags), KLog.toString(msg));
    }

    @KSMethod
    public void warn(Object msg) {
        this.log.warn(KLog.toString(msg));
    }

    @KSMethod
    public void warn(Object msg, Object tags) {
        this.log.warn(KLog.toLogTags(tags), KLog.toString(msg));
    }

    @KSMethod
    public void error(Object msg) {
        this.log.error(KLog.toString(msg));
    }

    @KSMethod
    public void error(Object msg, Object tags) {
        this.log.error(KLog.toLogTags(tags), KLog.toString(msg));
    }

    private static String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Throwable) {
            Throwable t = (Throwable)obj;
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            return sw.toString();
        }
        return String.valueOf(obj);
    }

    private static LogTags toLogTags(Object tags) {
        if (tags != null) {
            if (tags instanceof Map) {
                Map obj = (Map)tags;
                LogTags lts = LogTags.build((String[])new String[0]);
                Set entrySet = obj.entrySet();
                for (Map.Entry entry : entrySet) {
                    lts.addTag(KLog.toString(entry.getKey()), KLog.toString(entry.getValue()));
                }
                return lts;
            }
            return LogTags.build((String[])new String[]{"NO_TAG_NAME", KLog.toString(tags)});
        }
        return null;
    }

    public Log unwrap() {
        return this.log;
    }
}

