/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sdk.orm;

import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.script.ScriptWrapper;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;

@KSObject(name="ORM", namespace="")
public class KORM
implements ScriptWrapper<ORM> {
    private ORM orm;

    @KSMethod
    public static KORM create() {
        return new KORM();
    }

    public KORM() {
        this(ORM.create());
    }

    public KORM(ORM orm) {
        this.orm = orm;
    }

    @KSMethod
    public Object save(DynamicObject obj) {
        return this.orm.save(obj);
    }

    @KSMethod
    public Object insert(DynamicObject obj) {
        return this.orm.insert(obj);
    }

    @KSMethod
    public boolean update(DynamicObject obj) {
        return this.orm.update(obj);
    }

    @KSMethod
    public boolean delete(DynamicObject obj) {
        return this.orm.delete(obj);
    }

    @KSMethod
    public boolean delete(String entityName, Object id) {
        return this.orm.delete(entityName, id);
    }

    @KSMethod
    public int delete(String entityName, String whereExp, Object[] params) {
        return this.orm.delete(entityName, QFilter.of((String)whereExp, (Object[])params).toArray());
    }

    @KSMethod
    public boolean exists(DynamicObject obj) {
        return this.orm.exists(obj.getDataEntityType().getName(), obj.getPkValue());
    }

    @KSMethod
    public boolean exists(String entityName, Object id) {
        return this.orm.exists(entityName, id);
    }

    @KSMethod
    public boolean exists(String entityName, String whereExp, Object[] params) {
        return this.orm.exists(entityName, QFilter.of((String)whereExp, (Object[])params).toArray());
    }

    @KSMethod
    public DynamicObject getById(String entityName, Object id) {
        return this.orm.getById(entityName, id);
    }

    @KSMethod
    public DynamicObject queryOne(String oql, Object[] params) {
        return this.orm.queryOne(oql, params);
    }

    @KSMethod
    public DynamicObjectCollection query(String oql, Object[] params) {
        return this.orm.query(oql, params);
    }

    @KSMethod
    public DataSet queryDataSet(String algoKey, String oql, Object[] params) {
        return this.orm.queryDataSet(algoKey, oql, params);
    }

    @KSMethod
    public DynamicObjectCollection newCollection(String entityName) {
        return new DynamicObjectCollection((DynamicObjectType)this.orm.getDataEntityType(entityName), null);
    }

    @KSMethod
    public DynamicObject newObject(String entityName) {
        return this.orm.newDynamicObject(entityName);
    }

    @KSMethod
    public DynamicObject newObject(DynamicObjectType type) {
        return this.orm.newDynamicObject(type);
    }

    @KSMethod
    public DynamicObject newObject(String entityName, Object id) {
        return this.orm.newDynamicObject(entityName, id);
    }

    @KSMethod
    public void clearDirty(DynamicObject obj) {
        this.orm.clearDirty(obj);
    }

    @KSMethod
    public void clearDirty(DynamicObjectCollection cc) {
        this.orm.clearDirty(cc);
    }

    @KSMethod
    public DynamicObjectCollection toPlainCollection(DataSet ds) {
        return this.orm.toPlainDynamicObjectCollection(ds);
    }

    @KSMethod
    public DynamicObjectCollection toPlainCollection(CachedDataSet cds, int begin, int length) {
        return this.orm.toPlainDynamicObjectCollection(cds, begin, length);
    }

    @KSMethod
    public Object setPrimaryKey(DynamicObject obj) {
        return this.orm.setPrimaryKey(obj);
    }

    @KSMethod
    public long genLongId() {
        return DB.genGlobalLongId();
    }

    @KSMethod
    public long genLongId(String entityName) {
        return this.orm.genLongId(entityName);
    }

    @KSMethod
    public long[] genLongIds(String entityName, int count) {
        return this.orm.genLongIds(entityName, count);
    }

    @KSMethod
    public String genStringId(String entityName) {
        return this.orm.genStringId(entityName);
    }

    @KSMethod
    public String[] genStringIds(String entityName, int count) {
        return this.orm.genStringIds(entityName, count);
    }

    public ORM unwrap() {
        return this.orm;
    }
}

