/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.starter;

import kd.bos.util.SystemProperties;
import kd.bos.xcache.server.Bootstrap;
import kd.bos.xcache.server.env.Environment;
import kd.bos.xcache.server.metric.MetricsCenter;
import kd.bos.xcache.starter.NoopXCacheService;
import kd.bos.xcache.starter.elect.ElectorClient;
import kd.bos.xcache.starter.elect.ElectorService;
import kd.bos.xcache.starter.env.MServiceEnvironment;
import kd.bos.xcache.starter.exception.XCacheErrorCodes;
import kd.bos.xcache.starter.util.ErrorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealXCacheService
extends NoopXCacheService {
    private static final Logger log = LoggerFactory.getLogger(RealXCacheService.class);
    private static final String METER_OF_MASTER_NODE = "master_node";
    private final Bootstrap bootstrap = new Bootstrap((Environment)new MServiceEnvironment());
    private volatile boolean isStared = false;
    private final String group = this.getGroupName();
    private final ElectorService electorService = new ElectorService(this.group);
    private final ElectorClient electorClient = new ElectorClient();

    @Override
    public synchronized void start() {
        if (this.isStared) {
            return;
        }
        this.isStared = this.doStart();
    }

    private boolean doStart() {
        try {
            this.bootstrap.start();
            this.electorService.start();
            MetricsCenter.get().register("server", METER_OF_MASTER_NODE, () -> this.electorClient.getHost(this.group));
            return true;
        }
        catch (Exception e) {
            this.doStop();
            ErrorUtil.logErrorAndExit(log, e, XCacheErrorCodes.SERVICE_STARTED_ERROR);
            return false;
        }
    }

    @Override
    public synchronized void stop() {
        if (!this.isStared) {
            return;
        }
        this.doStop();
        this.isStared = false;
    }

    private void doStop() {
        try {
            this.electorService.stop();
            this.bootstrap.stop();
        }
        catch (Exception e) {
            ErrorUtil.logError(log, e, XCacheErrorCodes.SERVICE_STOP_ERROR);
        }
    }

    @Override
    public boolean isStarted() {
        return this.isStared;
    }

    private String getGroupName() {
        return SystemProperties.getWithEnv((String)"xcache_group", (String)"default_group");
    }
}

