/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ha.adapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ha.adapter.CacheAdapter;
import kd.bos.cache.ha.adapter.MothedCall;
import kd.bos.cache.ha.adapter.MothedCallBack;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;

class DistributeCacheAdapter
implements CacheAdapter {
    private volatile DistributeSessionlessCache cache;
    private String regionKey;
    private boolean throwExecption;
    private CacheAdapter priorityAdapter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributeSessionlessCache getCache() {
        if (this.cache == null) {
            DistributeCacheAdapter distributeCacheAdapter = this;
            synchronized (distributeCacheAdapter) {
                if (this.cache == null) {
                    this.cache = StringUtils.isBlank((CharSequence)this.regionKey) ? CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache() : CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(this.regionKey);
                }
            }
        }
        return this.cache;
    }

    public DistributeCacheAdapter(String regionKey, CacheAdapter priorityAdapter) {
        this.regionKey = regionKey;
        if (priorityAdapter != null) {
            this.priorityAdapter = priorityAdapter;
            this.priorityAdapter.setThrowException(true);
        }
    }

    @Override
    public void setPriorityAdapter(CacheAdapter priorityAdapter) {
        this.priorityAdapter = priorityAdapter;
        if (this.priorityAdapter != null) {
            this.priorityAdapter.setThrowException(true);
        }
    }

    @Override
    public CacheAdapter getPriorityAdapter() {
        return this.priorityAdapter;
    }

    @Override
    public void setThrowException(boolean throwException) {
        this.throwExecption = throwException;
    }

    @Override
    public boolean isThrowException() {
        return this.throwExecption;
    }

    @Override
    public void setRegionKey(String regionKey) {
        this.regionKey = regionKey;
    }

    @Override
    public String getRegionKey() {
        return this.regionKey;
    }

    public int addList(String key, String[] values) {
        return this.callBothBack(isUpdate -> this.getPriorityAdapter().addList(key, values), isUpdate -> this.getCache().addList(key, values), 0);
    }

    public int addList(String key, String[] values, int timeoutSeconds) {
        return this.callBothBack(isUpdate -> this.getPriorityAdapter().addList(key, values, timeoutSeconds), isUpdate -> this.getCache().addList(key, values, timeoutSeconds), 0);
    }

    public int addList(String key, String[] values, int timeout, TimeUnit timeUnit) {
        return this.callBothBack(isUpdate -> this.getPriorityAdapter().addList(key, values, timeout, timeUnit), isUpdate -> this.getCache().addList(key, values, timeout, timeUnit), 0);
    }

    public int resetList(String key, String[] values, int timeout, TimeUnit timeUnit) {
        this.remove(key);
        return this.addList(key, values, timeout, timeUnit);
    }

    public int insertList(String key, int index, String[] values) {
        return this.callBothBack(isUpdate -> this.getPriorityAdapter().insertList(key, index, values), isUpdate -> this.getCache().insertList(key, index, values), 0);
    }

    public void setListObject(String key, int index, String value) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().setListObject(key, index, value), isUpdate -> this.getCache().setListObject(key, index, value));
    }

    public String[] getList(String key) {
        return this.callOneBack(isUpdate -> this.getPriorityAdapter().getList(key), isUpdate -> this.getCache().getList(key), new String[0]);
    }

    public String[] getList(String key, int index, int length) {
        return this.callOneBack(isUpdate -> this.getPriorityAdapter().getList(key, index, length), isUpdate -> this.getCache().getList(key, index, length), new String[0]);
    }

    public String getListObject(String key, int index) {
        return this.callOneBack(isUpdate -> this.getPriorityAdapter().getListObject(key, index), isUpdate -> this.getCache().getListObject(key, index), null);
    }

    public void removeListObject(String key, int index) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().removeListObject(key, index), isUpdate -> this.getCache().removeListObject(key, index));
    }

    public void removeListObjects(String key, int index, int length) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().removeListObjects(key, index, length), isUpdate -> this.getCache().removeListObjects(key, index, length));
    }

    public int getListLength(String key) {
        return this.callOneBack(isUpdate -> this.getPriorityAdapter().getListLength(key), isUpdate -> this.getCache().getListLength(key), 0);
    }

    public int addToSet(String key, String[] values) {
        return this.callBothBack(isUpdate -> this.getPriorityAdapter().addToSet(key, values), isUpdate -> this.getCache().addToSet(key, values), 0);
    }

    public int addToSet(String key, String[] values, int timeoutSeconds) {
        return this.callBothBack(isUpdate -> this.getPriorityAdapter().addToSet(key, values, timeoutSeconds), isUpdate -> this.getCache().addToSet(key, values, timeoutSeconds), 0);
    }

    public int addToSet(String key, String[] values, int timeout, TimeUnit timeUnit) {
        return this.callBothBack(isUpdate -> this.getPriorityAdapter().addToSet(key, values, timeout, timeUnit), isUpdate -> this.getCache().addToSet(key, values, timeout, timeUnit), 0);
    }

    public String[] getSetValues(String key) {
        return this.callOneBack(isUpdate -> this.getPriorityAdapter().getSetValues(key), isUpdate -> this.getCache().getSetValues(key), new String[0]);
    }

    public int getSetLength(String key) {
        return this.callOneBack(isUpdate -> this.getPriorityAdapter().getSetLength(key), isUpdate -> this.getCache().getSetLength(key), 0);
    }

    public void removeSetValues(String key, String[] values) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().removeSetValues(key, values), isUpdate -> this.getCache().removeSetValues(key, values));
    }

    public void put(String key, String value) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().put(key, value), isUpdate -> this.getCache().put(key, (Object)value));
    }

    public void put(String key, String value, int timeoutSeconds) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().put(key, value, timeoutSeconds), isUpdate -> this.getCache().put(key, (Object)value, timeoutSeconds));
    }

    public void put(String key, String value, int timeout, TimeUnit timeUnit) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().put(key, value, timeout, timeUnit), isUpdate -> this.getCache().put(key, (Object)value, timeout, timeUnit));
    }

    public void put(String type, Map<String, String> keyValues) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().put(type, keyValues), isUpdate -> this.getCache().put(type, keyValues));
    }

    public void put(String type, Map<String, String> keyValues, int timeoutSeconds) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().put(type, keyValues, timeoutSeconds), isUpdate -> this.getCache().put(type, keyValues, timeoutSeconds));
    }

    public void put(String type, Map<String, String> keyValues, int timeout, TimeUnit timeUnit) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().put(type, keyValues, timeout, timeUnit), isUpdate -> this.getCache().put(type, keyValues, timeout, timeUnit));
    }

    public void put(String type, String key, String value) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().put(type, key, value), isUpdate -> this.getCache().put(type, key, (Object)value));
    }

    public void put(String type, String key, String value, int timeoutSeconds) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().put(type, key, value, timeoutSeconds), isUpdate -> this.getCache().put(type, key, value, timeoutSeconds));
    }

    public void put(String type, String key, String value, int timeout, TimeUnit timeUnit) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().put(type, key, value, timeout, timeUnit), isUpdate -> this.getCache().put(type, key, value, timeout, timeUnit));
    }

    public String get(String key) {
        return this.callOneBack(isUpdate -> (String)this.getPriorityAdapter().get(key), isUpdate -> (String)this.getCache().get(key), null);
    }

    public String get(String type, String key) {
        return this.callOneBack(isUpdate -> (String)this.getPriorityAdapter().get(type, key), isUpdate -> (String)this.getCache().get(type, key), null);
    }

    public List<String> get(String type, String[] keys) {
        ArrayList<Object> values = new ArrayList<Object>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            values.add(null);
        }
        return this.callOneBack(isUpdate -> this.getPriorityAdapter().get(type, keys), isUpdate -> this.getCache().get(type, keys), values);
    }

    public Map<String, String> getAll(String type) {
        return this.callOneBack(isUpdate -> this.getPriorityAdapter().getAll(type), isUpdate -> this.getCache().getAll(type), new HashMap(0));
    }

    public void remove(String key) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().remove(key), isUpdate -> this.getCache().remove(key));
    }

    public void remove(String[] keys) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().remove(keys), isUpdate -> this.getCache().remove(keys));
    }

    public void remove(String type, String key) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().remove(type, key), isUpdate -> this.getCache().remove(type, key));
    }

    public void remove(String type, String[] keys) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().remove(type, keys), isUpdate -> this.getCache().remove(type, keys));
    }

    public void removeType(String type) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().removeType(type), isUpdate -> this.getCache().removeType(type));
    }

    public boolean contains(String key) {
        return this.callOneBack(isUpdate -> this.getPriorityAdapter().contains(key), isUpdate -> this.getCache().contains(key), false);
    }

    public boolean contains(String type, String key) {
        return this.callOneBack(isUpdate -> this.getPriorityAdapter().contains(type, key), isUpdate -> this.getCache().contains(type, key), false);
    }

    public List<String> getKeys(String type) {
        return this.callOneBack(isUpdate -> this.getPriorityAdapter().getKeys(type), isUpdate -> this.getCache().getKeys(type), new ArrayList(0));
    }

    public List<String> getKeysWithPrefix(String type, String prefix) {
        return this.callOneBack(isUpdate -> this.getPriorityAdapter().getKeysWithPrefix(type, prefix), isUpdate -> this.getCache().getKeysWithPrefix(type, prefix), new ArrayList(0));
    }

    public List<String> getKeysWithPrefix(String prefix) {
        return this.callOneBack(isUpdate -> this.getPriorityAdapter().getKeysWithPrefix(prefix), isUpdate -> this.getCache().getKeysWithPrefix(prefix), new ArrayList(0));
    }

    public long inc(String key) {
        return this.callBothBack(isUpdate -> this.getPriorityAdapter().inc(key), isUpdate -> this.getCache().inc(key), 0L);
    }

    public long inc(String key, int timeoutSeconds) {
        return this.callBothBack(isUpdate -> this.getPriorityAdapter().inc(key, timeoutSeconds), isUpdate -> this.getCache().inc(key, timeoutSeconds), 0L);
    }

    public long inc(String key, int timeout, TimeUnit timeUnit) {
        return this.callBothBack(isUpdate -> this.getPriorityAdapter().inc(key, timeout, timeUnit), isUpdate -> this.getCache().inc(key, timeout, timeUnit), 0L);
    }

    public long incrBy(String key, int amount) {
        return this.callBothBack(isUpdate -> this.getPriorityAdapter().incrBy(key, amount), isUpdate -> this.getCache().incrBy(key, amount), 0L);
    }

    public long decr(String key) {
        return this.callBothBack(isUpdate -> this.getPriorityAdapter().decr(key), isUpdate -> this.getCache().decr(key), 0L);
    }

    public long decr(String key, int timeoutSeconds) {
        return this.callBothBack(isUpdate -> this.getPriorityAdapter().decr(key, timeoutSeconds), isUpdate -> this.getCache().decr(key, timeoutSeconds), 0L);
    }

    public long decr(String key, int timeout, TimeUnit timeUnit) {
        return this.callBothBack(isUpdate -> this.getPriorityAdapter().decr(key, timeout, timeUnit), isUpdate -> this.getCache().decr(key, timeout, timeUnit), 0L);
    }

    public void expireAfter(String keyOrType, int second) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().expireAfter(keyOrType, second), isUpdate -> this.getCache().expireAfter(keyOrType, second));
    }

    public void expireAfter(String keyOrType, int timeout, TimeUnit timeUnit) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().expireAfter(keyOrType, timeout, timeUnit), isUpdate -> this.getCache().expireAfter(keyOrType, timeout, timeUnit));
    }

    public void expireAfterImmediateEffect(String keyOrType, int timeout, TimeUnit timeUnit) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().expireAfterImmediateEffect(keyOrType, timeout, timeUnit), isUpdate -> this.getCache().expireAfterImmediateEffect(keyOrType, timeout, timeUnit));
    }

    public Object eval(String lua, String key, List<String> params) {
        return this.callOneBack(isUpdate -> this.getPriorityAdapter().eval(lua, key, params), isUpdate -> this.getCache().eval(lua, key, params), null);
    }

    public void put(String key, byte[] value) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().put(key, value), isUpdate -> this.getCache().put(key, value));
    }

    public void put(String key, byte[] value, int timeoutSecond) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().put(key, value, timeoutSecond), isUpdate -> this.getCache().put(key, value, timeoutSecond));
    }

    public void hset(String key, byte[] field, byte[] value) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().hset(key, field, value), isUpdate -> this.getCache().hset(key, field, value));
    }

    public void hset(String key, byte[] field, byte[] value, int timeoutSeconds) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().hset(key, field, value, timeoutSeconds), isUpdate -> this.getCache().hset(key, field, value, timeoutSeconds));
    }

    public void hmset(String key, Map<byte[], byte[]> map) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().hmset(key, map), isUpdate -> this.getCache().hmset(key, map));
    }

    public void hmset(String key, Map<byte[], byte[]> map, int timeoutSeconds) {
        this.callBoth(isUpdate -> this.getPriorityAdapter().hmset(key, map, timeoutSeconds), isUpdate -> this.getCache().hmset(key, map, timeoutSeconds));
    }

    public byte[] hget(String key, byte[] bytes) {
        return this.callOneBack(isUpdate -> this.getPriorityAdapter().hget(key, bytes), isUpdate -> this.getCache().hget(key, bytes), null);
    }

    public Map<byte[], byte[]> hgetAll(String key) {
        return this.callOneBack(isUpdate -> this.getPriorityAdapter().hgetAll(key), isUpdate -> this.getCache().hgetAll(key), null);
    }

    public List<byte[]> hmget(String key, byte[] ... bytes) {
        return this.callOneBack(isUpdate -> this.getPriorityAdapter().hmget(key, bytes), isUpdate -> this.getCache().hmget(key, bytes), null);
    }

    public byte[] getByteValue(String key) {
        return this.callOneBack(isUpdate -> this.getPriorityAdapter().getByteValue(key), isUpdate -> this.getCache().getByteValue(key), null);
    }

    public void pipelinedMode() {
        this.callBoth(isUpdate -> this.getPriorityAdapter().pipelinedMode(), isUpdate -> this.getCache().pipelinedMode());
    }

    public void singleMode() {
        this.callBoth(isUpdate -> this.getPriorityAdapter().singleMode(), isUpdate -> this.getCache().singleMode());
    }

    public List<Object> syncAndReturn() {
        return this.callOneBack(isUpdate -> this.getPriorityAdapter().syncAndReturn(), isUpdate -> this.getCache().syncAndReturn(), new ArrayList());
    }

    private <R> R callOneBack(MothedCallBack<R> call1, MothedCallBack<R> call2, R defValue) {
        if (this.getPriorityAdapter() != null) {
            try {
                return call1.call(true);
            }
            catch (KDException kDException) {
                // empty catch block
            }
        }
        try {
            return call2.call(true);
        }
        catch (KDException e) {
            if (this.isThrowException()) {
                throw e;
            }
            return defValue;
        }
    }

    private void callBoth(MothedCall call1, MothedCall call2) {
        block5: {
            boolean isUpLevel;
            boolean bl = isUpLevel = this.getPriorityAdapter() == null;
            if (this.getPriorityAdapter() != null) {
                try {
                    call1.call(true);
                }
                catch (KDException e) {
                    isUpLevel = true;
                }
            }
            try {
                call2.call(isUpLevel);
            }
            catch (KDException e) {
                if (!this.isThrowException()) break block5;
                throw e;
            }
        }
    }

    private <R> R callBothBack(MothedCallBack<R> call1, MothedCallBack<R> call2, R defValue) {
        boolean isUpLevel;
        R val2;
        R val1;
        block5: {
            val1 = defValue;
            val2 = defValue;
            boolean bl = isUpLevel = this.getPriorityAdapter() == null;
            if (this.getPriorityAdapter() != null) {
                try {
                    val1 = call1.call(true);
                }
                catch (KDException e) {
                    isUpLevel = true;
                }
            }
            try {
                val2 = call2.call(isUpLevel);
            }
            catch (KDException e) {
                if (!this.isThrowException()) break block5;
                throw e;
            }
        }
        return isUpLevel ? val2 : val1;
    }

    public boolean isAvailable() {
        if (this.getPriorityAdapter() != null) {
            return this.getPriorityAdapter().isAvailable();
        }
        return this.getCache().isAvailable();
    }
}

