/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ha.db.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ha.db.dao.WriteHelper;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;

class DbCacheReader {
    DbCacheReader() {
    }

    public String[] loadList(String regionKey, String key) {
        Long id = this.loadId(regionKey, key);
        if (id == null) {
            return new String[0];
        }
        String sql = "select fseq, fvalue from t_log_dbcacheentry where fid = ? order by fseq asc";
        Object[] params = new SqlParameter[]{new SqlParameter("fid", -5, (Object)id)};
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> values = new ArrayList<String>(10);
                while (rs.next()) {
                    String value = rs.getString("fvalue");
                    values.add(value);
                }
                return values;
            }
        };
        List results = (List)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])params, (ResultSetHandler)action);
        return results.toArray(new String[0]);
    }

    public String[] loadList(String regionKey, String key, int index, int length) {
        if (index < 0) {
            return new String[0];
        }
        if (length <= 0) {
            return new String[0];
        }
        Long id = this.loadId(regionKey, key);
        if (id == null) {
            return new String[0];
        }
        String sql = "select fseq, fvalue from t_log_dbcacheentry where fid = ? and fseq >= ? and fseq < ? order by fseq asc";
        int seq = index + 1;
        Object[] params = new SqlParameter[]{new SqlParameter("fid", -5, (Object)id), new SqlParameter("fseq", 4, (Object)seq), new SqlParameter("fseq", 4, (Object)(seq + length))};
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> values = new ArrayList<String>(10);
                while (rs.next()) {
                    String value = rs.getString("fvalue");
                    values.add(value);
                }
                return values;
            }
        };
        List results = (List)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])params, (ResultSetHandler)action);
        return results.toArray(new String[0]);
    }

    public String loadListObject(String regionKey, String key, int index) {
        if (index < 0) {
            return null;
        }
        Long id = this.loadId(regionKey, key);
        if (id == null) {
            return null;
        }
        String sql = "select fseq, fvalue from t_log_dbcacheentry where fid = ? and fseq = ?";
        int seq = index + 1;
        Object[] params = new SqlParameter[]{new SqlParameter("fid", -5, (Object)id), new SqlParameter("fseq", 4, (Object)seq)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("fvalue");
                }
                return null;
            }
        };
        return (String)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public int loadListLength(String regionKey, String key) {
        Long id = this.loadId(regionKey, key);
        if (id == null) {
            return 0;
        }
        String sql = "select top 1 fseq from t_log_dbcacheentry where fid = ? order by fseq desc";
        Object[] params = new SqlParameter[]{new SqlParameter("fid", -5, (Object)id)};
        ResultSetHandler<Integer> action = new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("fseq");
                }
                return 0;
            }
        };
        return (Integer)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public String load(long id) {
        String sql = "select fvalue from t_log_dbcache where fid = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter("fid", -5, (Object)id)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("fvalue");
                }
                return null;
            }
        };
        return (String)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public String load(String regionKey, String key) {
        Long id = this.loadId(regionKey, key);
        if (id == null) {
            return null;
        }
        String sql = "select fvalue from t_log_dbcache where fid = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter("fid", -5, (Object)id)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("fvalue");
                }
                return null;
            }
        };
        return (String)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public String load(String regionKey, String type, String key) {
        Long id = this.loadId(regionKey, type, key);
        if (id == null) {
            return null;
        }
        String sql = "select fvalue from t_log_dbcache where fid = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter("fid", -5, (Object)id)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("fvalue");
                }
                return null;
            }
        };
        return (String)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public List<String> load(String regionKey, String type, final String[] keys) {
        if (keys == null || keys.length == 0) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> emptyList = new ArrayList<String>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            emptyList.add(null);
        }
        if (regionKey == null || type == null || "".equals(type)) {
            return emptyList;
        }
        final HashSet<String> keySet = new HashSet<String>(keys.length);
        for (String key : keys) {
            if (key == null || "".equals(key)) continue;
            keySet.add(key);
        }
        if (keySet.isEmpty()) {
            return emptyList;
        }
        String sql = "select fkey, fvalue from t_log_dbcache where fregion = ? and ftype = ? and fovertime >= ? order by fovertime asc ";
        Object[] params = new SqlParameter[]{new SqlParameter("fregion", 12, (Object)regionKey), new SqlParameter("ftype", 12, (Object)type), new SqlParameter("fovertime", -5, (Object)WriteHelper.getCurrTime().getTime())};
        ResultSetHandler<Map<String, String>> action = new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws SQLException {
                HashMap<String, String> keyValues = new HashMap<String, String>(keys.length);
                while (rs.next()) {
                    String key = rs.getString("fkey");
                    if (!keySet.contains(key)) continue;
                    keyValues.put(key, rs.getString("fvalue"));
                }
                return keyValues;
            }
        };
        Map dbKeyValues = (Map)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])params, (ResultSetHandler)action);
        ArrayList<String> results = new ArrayList<String>(keys.length);
        for (String key : keys) {
            if (key == null || "".equals(key)) {
                results.add(null);
                continue;
            }
            results.add((String)dbKeyValues.get(key));
        }
        return results;
    }

    public Map<String, String> loadAll(String regionKey, String type) {
        if (regionKey == null || type == null || "".equals(type)) {
            return new HashMap<String, String>(0);
        }
        String sql = "select fkey, fvalue from t_log_dbcache where fregion = ? and ftype = ? and fovertime >= ? order by fovertime asc ";
        Object[] params = new SqlParameter[]{new SqlParameter("fregion", 12, (Object)regionKey), new SqlParameter("ftype", 12, (Object)type), new SqlParameter("fovertime", -5, (Object)WriteHelper.getCurrTime().getTime())};
        ResultSetHandler<Map<String, String>> action = new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws SQLException {
                HashMap<String, String> keyValues = new HashMap<String, String>(10);
                while (rs.next()) {
                    String key = rs.getString("fkey");
                    if (key == null) continue;
                    keyValues.put(key, rs.getString("fvalue"));
                }
                return keyValues;
            }
        };
        return (Map)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public boolean contains(String regionKey, String key) {
        return this.loadId(regionKey, key) != null;
    }

    public boolean contains(String regionKey, String type, String key) {
        return this.loadId(regionKey, type, key) != null;
    }

    public List<String> loadKeys(String regionKey, String type) {
        if (regionKey == null || type == null || "".equals(type)) {
            return new ArrayList<String>(0);
        }
        String sql = "select fkey from t_log_dbcache where fregion = ? and ftype = ? and fovertime >= ? ";
        Object[] params = new SqlParameter[]{new SqlParameter("fregion", 12, (Object)regionKey), new SqlParameter("ftype", 12, (Object)type), new SqlParameter("fovertime", -5, (Object)WriteHelper.getCurrTime().getTime())};
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> keys = new ArrayList<String>(10);
                while (rs.next()) {
                    String key = rs.getString("fkey");
                    if (key == null) continue;
                    keys.add(key);
                }
                return keys;
            }
        };
        return (List)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public List<String> loadKeysWithPrefix(String regionKey, String type, final String prefix) {
        if (regionKey == null || type == null || "".equals(type)) {
            return new ArrayList<String>(0);
        }
        String sql = "select fkey from t_log_dbcache where fregion = ? and ftype = ? and fovertime >= ? ";
        Object[] params = new SqlParameter[]{new SqlParameter("fregion", 12, (Object)regionKey), new SqlParameter("ftype", 12, (Object)type), new SqlParameter("fovertime", -5, (Object)WriteHelper.getCurrTime().getTime())};
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> keys = new ArrayList<String>(10);
                while (rs.next()) {
                    String key = rs.getString("fkey");
                    if (key == null || prefix != null && !key.startsWith(prefix)) continue;
                    keys.add(key);
                }
                return keys;
            }
        };
        return (List)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public List<String> loadKeysWithPrefix(String regionKey, final String prefix) {
        if (regionKey == null) {
            return new ArrayList<String>(0);
        }
        String sql = "select ftype from t_log_dbcache where fregion = ? and fovertime >= ? ";
        Object[] params = new SqlParameter[]{new SqlParameter("fregion", 12, (Object)regionKey), new SqlParameter("fovertime", -5, (Object)WriteHelper.getCurrTime().getTime())};
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> keys = new ArrayList<String>(10);
                while (rs.next()) {
                    String key = rs.getString("ftype");
                    if (key == null || prefix != null && !key.startsWith(prefix)) continue;
                    keys.add(key);
                }
                return keys;
            }
        };
        return (List)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public Long loadId(String regionKey, String key) {
        if (regionKey == null || key == null || "".equals(key)) {
            return null;
        }
        String sql = "select top 1 fid from t_log_dbcache where fregion = ? and ftype = ? and fovertime >= ? order by fovertime desc";
        Object[] params = new SqlParameter[]{new SqlParameter("fregion", 12, (Object)regionKey), new SqlParameter("ftype", 12, (Object)key), new SqlParameter("fovertime", -5, (Object)WriteHelper.getCurrTime().getTime())};
        ResultSetHandler<Long> action = new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getLong("fid");
                }
                return null;
            }
        };
        return (Long)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public Long loadId(String regionKey, String type, String key) {
        if (regionKey == null || type == null || "".equals(type) || key == null || "".equals(key)) {
            return null;
        }
        String sql = "select top 1 fid from t_log_dbcache where fregion = ? and ftype = ? and fkey = ? and fovertime >= ? order by fovertime desc";
        Object[] params = new SqlParameter[]{new SqlParameter("fregion", 12, (Object)regionKey), new SqlParameter("ftype", 12, (Object)type), new SqlParameter("fkey", 12, (Object)key), new SqlParameter("fovertime", -5, (Object)WriteHelper.getCurrTime().getTime())};
        ResultSetHandler<Long> action = new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getLong("fid");
                }
                return null;
            }
        };
        return (Long)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public Map<String, Long> loadKeyToIds(String regionKey, String type, final String[] keys) {
        if (regionKey == null || type == null || "".equals(type) || keys == null || keys.length == 0) {
            return new HashMap<String, Long>(0);
        }
        SqlParameter regionParam = new SqlParameter("fregion", 12, (Object)regionKey);
        SqlParameter typeParam = new SqlParameter("ftype", 12, (Object)type);
        SqlParameter overtimeParam = new SqlParameter("fovertime", -5, (Object)WriteHelper.getCurrTime().getTime());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FId, FKey FROM ", new Object[0]).append("t_log_dbcache", new Object[0]);
        sqlBuilder.append(" WHERE FRegion = ? AND FType = ? AND FOvertime >= ? AND ", new Object[]{regionParam, typeParam, overtimeParam});
        sqlBuilder.appendIn("fkey", (Object[])keys);
        sqlBuilder.append(" ORDER BY FId ASC ", new Object[0]);
        ResultSetHandler<Map<String, Long>> action = new ResultSetHandler<Map<String, Long>>(){

            public Map<String, Long> handle(ResultSet rs) throws SQLException {
                HashMap<String, Long> map = new HashMap<String, Long>(keys.length);
                while (rs.next()) {
                    String key = rs.getString("fkey");
                    Long id = rs.getLong("fid");
                    if (key == null) continue;
                    map.put(key, id);
                }
                return map;
            }
        };
        return (Map)DB.query((DBRoute)DBRoute.log, (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
    }

    public Map<String, Long> loadKeyToIds(String regionKey, final String[] keys) {
        if (regionKey == null || keys == null || keys.length == 0) {
            return new HashMap<String, Long>(0);
        }
        SqlParameter regionParam = new SqlParameter("fregion", 12, (Object)regionKey);
        SqlParameter overtimeParam = new SqlParameter("fovertime", -5, (Object)WriteHelper.getCurrTime().getTime());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FId, FType FROM ", new Object[0]).append("t_log_dbcache", new Object[0]);
        sqlBuilder.append(" WHERE FRegion = ? AND FOvertime >= ? AND ", new Object[]{regionParam, overtimeParam});
        sqlBuilder.appendIn("ftype", (Object[])keys);
        sqlBuilder.append(" ORDER BY FId ASC ", new Object[0]);
        ResultSetHandler<Map<String, Long>> action = new ResultSetHandler<Map<String, Long>>(){

            public Map<String, Long> handle(ResultSet rs) throws SQLException {
                HashMap<String, Long> map = new HashMap<String, Long>(keys.length);
                while (rs.next()) {
                    String key = rs.getString("ftype");
                    Long id = rs.getLong("fid");
                    if (key == null) continue;
                    map.put(key, id);
                }
                return map;
            }
        };
        return (Map)DB.query((DBRoute)DBRoute.log, (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
    }

    public Set<Long> loadIds(String regionKey, final String[] keyOrTypes) {
        if (regionKey == null || keyOrTypes == null || keyOrTypes.length == 0) {
            return new HashSet<Long>(0);
        }
        SqlParameter regionParam = new SqlParameter("fregion", 12, (Object)regionKey);
        SqlParameter overtimeParam = new SqlParameter("fovertime", -5, (Object)WriteHelper.getCurrTime().getTime());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FId, FType FROM ", new Object[0]).append("t_log_dbcache", new Object[0]);
        sqlBuilder.append(" WHERE FRegion = ? AND FOvertime >= ? AND ", new Object[]{regionParam, overtimeParam});
        sqlBuilder.appendIn("ftype", (Object[])keyOrTypes);
        sqlBuilder.append(" ORDER BY FId ASC ", new Object[0]);
        ResultSetHandler<Set<Long>> action = new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws SQLException {
                HashSet<Long> set = new HashSet<Long>(keyOrTypes.length);
                while (rs.next()) {
                    Long id = rs.getLong("fid");
                    set.add(id);
                }
                return set;
            }
        };
        return (Set)DB.query((DBRoute)DBRoute.log, (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
    }
}

