/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ha.db.dao;

import java.util.Map;
import kd.bos.cache.ha.db.dao.AddListAction;
import kd.bos.cache.ha.db.dao.DbCacheWriteRunner;
import kd.bos.cache.ha.db.dao.ExpireAfterAction;
import kd.bos.cache.ha.db.dao.IncrAction;
import kd.bos.cache.ha.db.dao.InsertListAction;
import kd.bos.cache.ha.db.dao.PutKeyValueAction;
import kd.bos.cache.ha.db.dao.PutTypeKeyValueAction;
import kd.bos.cache.ha.db.dao.RemoveKeyValueAction;
import kd.bos.cache.ha.db.dao.RemoveListObjectAction;
import kd.bos.cache.ha.db.dao.RemoveTypeKeyValueAction;
import kd.bos.cache.ha.db.dao.SetListObjectAction;
import kd.bos.cache.ha.db.dao.WriteHelper;
import kd.bos.dataentity.OperateOption;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

class DbCacheWriter {
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)DbCacheWriter.class.getName(), (int)4);
    private OperateOption option;

    public DbCacheWriter() {
    }

    public DbCacheWriter(OperateOption option) {
        this.option = option;
    }

    public void setOption(OperateOption option) {
        this.option = option;
    }

    public OperateOption getOption() {
        return this.option;
    }

    public boolean isSync() {
        if (this.getOption() == null) {
            return false;
        }
        return "true".equals(this.getOption().getVariableValue("sync", "false"));
    }

    public int addList(String regionKey, String key, String[] values, int timeoutSeconds) {
        int seconds = timeoutSeconds > 0 ? timeoutSeconds : WriteHelper.getDefaultTimeout();
        AddListAction action = new AddListAction(regionKey, key, values, seconds);
        DbCacheWriteRunner writeRunner = new DbCacheWriteRunner(action);
        if (this.isSync()) {
            writeRunner.execute();
            return action.getListLength();
        }
        threadPool.execute((Runnable)writeRunner);
        return values.length;
    }

    public int insertList(String regionKey, String key, int index, String[] values) {
        InsertListAction action = new InsertListAction(regionKey, key, index, values, WriteHelper.getDefaultTimeout());
        DbCacheWriteRunner writeRunner = new DbCacheWriteRunner(action);
        if (this.isSync()) {
            writeRunner.execute();
        } else {
            threadPool.execute((Runnable)writeRunner);
        }
        return values.length;
    }

    public void setListObject(String regionKey, String key, int index, String value) {
        SetListObjectAction action = new SetListObjectAction(regionKey, key, index, value, WriteHelper.getDefaultTimeout());
        DbCacheWriteRunner writeRunner = new DbCacheWriteRunner(action);
        if (this.isSync()) {
            writeRunner.execute();
        } else {
            threadPool.execute((Runnable)writeRunner);
        }
    }

    public void removeListObject(String regionKey, String key, int index) {
        RemoveListObjectAction action = new RemoveListObjectAction(regionKey, key, index, 1);
        DbCacheWriteRunner writeRunner = new DbCacheWriteRunner(action);
        if (this.isSync()) {
            writeRunner.execute();
        } else {
            threadPool.execute((Runnable)writeRunner);
        }
    }

    public void removeListObjects(String regionKey, String key, int index, int length) {
        RemoveListObjectAction action = new RemoveListObjectAction(regionKey, key, index, length);
        DbCacheWriteRunner writeRunner = new DbCacheWriteRunner(action);
        if (this.isSync()) {
            writeRunner.execute();
        } else {
            threadPool.execute((Runnable)writeRunner);
        }
    }

    public void put(String regionKey, String key, String value, int timeoutSeconds) {
        int seconds = timeoutSeconds > 0 ? timeoutSeconds : WriteHelper.getDefaultTimeout();
        PutKeyValueAction action = new PutKeyValueAction(regionKey, key, value, seconds);
        DbCacheWriteRunner writeRunner = new DbCacheWriteRunner(action);
        if (this.isSync()) {
            writeRunner.execute();
        } else {
            threadPool.execute((Runnable)writeRunner);
        }
    }

    public void put(String regionKey, String type, Map<String, String> keyValues, int timeoutSeconds) {
        int seconds = timeoutSeconds > 0 ? timeoutSeconds : WriteHelper.getDefaultTimeout();
        PutTypeKeyValueAction action = new PutTypeKeyValueAction(regionKey, type, keyValues, seconds);
        DbCacheWriteRunner writeRunner = new DbCacheWriteRunner(action);
        if (this.isSync()) {
            writeRunner.execute();
        } else {
            threadPool.execute((Runnable)writeRunner);
        }
    }

    public void put(String regionKey, String type, String key, String value, int timeoutSeconds) {
        int seconds = timeoutSeconds > 0 ? timeoutSeconds : WriteHelper.getDefaultTimeout();
        PutTypeKeyValueAction action = new PutTypeKeyValueAction(regionKey, type, key, value, seconds);
        DbCacheWriteRunner writeRunner = new DbCacheWriteRunner(action);
        if (this.isSync()) {
            writeRunner.execute();
        } else {
            threadPool.execute((Runnable)writeRunner);
        }
    }

    public void remove(String regionKey, String key) {
        RemoveKeyValueAction action = new RemoveKeyValueAction(regionKey, key);
        DbCacheWriteRunner writeRunner = new DbCacheWriteRunner(action);
        if (this.isSync()) {
            writeRunner.execute();
        } else {
            threadPool.execute((Runnable)writeRunner);
        }
    }

    public void remove(String regionKey, String[] keys) {
        RemoveKeyValueAction action = new RemoveKeyValueAction(regionKey, keys);
        DbCacheWriteRunner writeRunner = new DbCacheWriteRunner(action);
        if (this.isSync()) {
            writeRunner.execute();
        } else {
            threadPool.execute((Runnable)writeRunner);
        }
    }

    public void remove(String regionKey, String type, String key) {
        RemoveTypeKeyValueAction action = new RemoveTypeKeyValueAction(regionKey, type, new String[]{key});
        DbCacheWriteRunner writeRunner = new DbCacheWriteRunner(action);
        if (this.isSync()) {
            writeRunner.execute();
        } else {
            threadPool.execute((Runnable)writeRunner);
        }
    }

    public void remove(String regionKey, String type, String[] keys) {
        RemoveTypeKeyValueAction action = new RemoveTypeKeyValueAction(regionKey, type, keys);
        DbCacheWriteRunner writeRunner = new DbCacheWriteRunner(action);
        if (this.isSync()) {
            writeRunner.execute();
        } else {
            threadPool.execute((Runnable)writeRunner);
        }
    }

    public void removeType(String regionKey, String type) {
        RemoveTypeKeyValueAction action = new RemoveTypeKeyValueAction(regionKey, type);
        DbCacheWriteRunner writeRunner = new DbCacheWriteRunner(action);
        if (this.isSync()) {
            writeRunner.execute();
        } else {
            threadPool.execute((Runnable)writeRunner);
        }
    }

    public long inc(String regionKey, String key, int timeoutSeconds) {
        int seconds = timeoutSeconds > 0 ? timeoutSeconds : WriteHelper.getDefaultTimeout();
        IncrAction action = new IncrAction(regionKey, key, 1, seconds);
        DbCacheWriteRunner writeRunner = new DbCacheWriteRunner(action);
        writeRunner.execute();
        return action.getNewVal();
    }

    public long incrBy(String regionKey, String key, int amount) {
        IncrAction action = new IncrAction(regionKey, key, amount, WriteHelper.getDefaultTimeout());
        DbCacheWriteRunner writeRunner = new DbCacheWriteRunner(action);
        writeRunner.execute();
        return action.getNewVal();
    }

    long decr(String regionKey, String key, int timeoutSeconds) {
        int seconds = timeoutSeconds > 0 ? timeoutSeconds : WriteHelper.getDefaultTimeout();
        IncrAction action = new IncrAction(regionKey, key, -1, seconds);
        DbCacheWriteRunner writeRunner = new DbCacheWriteRunner(action);
        writeRunner.execute();
        return action.getNewVal();
    }

    public void expireAfter(String regionKey, String keyOrType, int timeoutSeconds) {
        int seconds = timeoutSeconds > 0 ? timeoutSeconds : WriteHelper.getDefaultTimeout();
        ExpireAfterAction action = new ExpireAfterAction(regionKey, keyOrType, seconds);
        DbCacheWriteRunner writeRunner = new DbCacheWriteRunner(action);
        if (this.isSync()) {
            writeRunner.execute();
        } else {
            threadPool.execute((Runnable)writeRunner);
        }
    }

    public void expireAfterImmediateEffect(String regionKey, String keyOrType, int timeoutSeconds) {
        int seconds = timeoutSeconds > 0 ? timeoutSeconds : WriteHelper.getDefaultTimeout();
        ExpireAfterAction action = new ExpireAfterAction(regionKey, keyOrType, seconds);
        DbCacheWriteRunner writeRunner = new DbCacheWriteRunner(action);
        if (this.isSync()) {
            writeRunner.execute();
        } else {
            threadPool.execute((Runnable)writeRunner);
        }
    }

    public void clearOvertimeValues() {
        try (TXHandle h = TX.requiresNew();){
            WriteHelper.clearOvertimeValues();
        }
    }
}

