/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ha.db.dao;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.cache.ha.db.dao.DbCacheReader;
import kd.bos.cache.ha.db.dao.IWriteAction;
import kd.bos.cache.ha.db.dao.WriteHelper;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;

class IncrAction
implements IWriteAction {
    private String regionKey;
    private String key;
    private int amount;
    private long timeoutSeconds;
    private long newVal = 0L;

    public IncrAction(String regionKey, String key, int amount, int timeoutSeconds) {
        this.regionKey = regionKey;
        this.key = key;
        this.amount = amount;
        this.timeoutSeconds = timeoutSeconds;
    }

    private boolean validate() {
        return this.regionKey != null && this.key != null && !"".equals(this.key);
    }

    @Override
    public String getLockKey() {
        return WriteHelper.getLockKey(this.regionKey, this.key);
    }

    @Override
    public void execute() {
        String oldValStr;
        if (!this.validate()) {
            return;
        }
        DbCacheReader reader = new DbCacheReader();
        long oldVal = 0L;
        Long id = reader.loadId(this.regionKey, this.key);
        if (id != null && (oldValStr = reader.load(this.regionKey, this.key)) != null) {
            oldVal = Long.parseLong(oldValStr);
        }
        this.newVal = oldVal + (long)this.amount;
        ArrayList<SqlParameter[]> updateParams = new ArrayList<SqlParameter[]>(1);
        ArrayList<SqlParameter[]> insertParams = new ArrayList<SqlParameter[]>(1);
        Date currTime = WriteHelper.getCurrTime();
        long overtime = currTime.getTime() + this.timeoutSeconds * 1000L;
        if (id == null) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("fid", -5, (Object)DB.genGlobalLongId()), new SqlParameter("fregion", 12, (Object)this.regionKey), new SqlParameter("ftype", 12, (Object)this.key), new SqlParameter("fvalue", 2005, (Object)String.valueOf(this.newVal)), new SqlParameter("fcreatetime", 91, (Object)currTime), new SqlParameter("fovertime", -5, (Object)overtime)};
            insertParams.add(params);
        } else {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("fvalue", 2005, (Object)String.valueOf(this.newVal)), new SqlParameter("fovertime", -5, (Object)overtime), new SqlParameter("fid", -5, (Object)id)};
            updateParams.add(params);
        }
        if (!updateParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.log, (String)"update t_log_dbcache set fvalue = ?, fovertime = ? where fid = ?", updateParams);
        }
        if (!insertParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.log, (String)"insert t_log_dbcache(fid, fregion, ftype, fvalue, fcreatetime, fovertime) values (?, ?, ?, ?, ?, ?)", insertParams);
        }
    }

    public long getNewVal() {
        return this.newVal;
    }
}

