/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ha.db.dao;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.ha.db.dao.DbCacheReader;
import kd.bos.cache.ha.db.dao.IWriteAction;
import kd.bos.cache.ha.db.dao.WriteHelper;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;

class PutTypeKeyValueAction
implements IWriteAction {
    private String regionKey;
    private String type;
    private Map<String, String> keyValues;
    private long timeoutSeconds;
    private DbCacheReader reader;

    public PutTypeKeyValueAction(String regionKey, String type, String key, String value, int timeoutSeconds) {
        this.regionKey = regionKey;
        this.type = type;
        this.keyValues = new HashMap<String, String>(1);
        if (key != null && !"".equals(key) && value != null) {
            this.keyValues.put(key, value);
        }
        this.timeoutSeconds = timeoutSeconds;
    }

    public PutTypeKeyValueAction(String regionKey, String type, Map<String, String> values, int timeoutSeconds) {
        this.regionKey = regionKey;
        this.type = type;
        this.keyValues = values == null ? new HashMap<String, String>(0) : new HashMap<String, String>(values);
        this.timeoutSeconds = timeoutSeconds;
    }

    private boolean validate() {
        return this.regionKey != null && this.type != null && !"".equals(this.type) && !this.keyValues.isEmpty();
    }

    @Override
    public String getLockKey() {
        return WriteHelper.getLockKey(this.regionKey, this.type);
    }

    @Override
    public void execute() {
        if (!this.validate()) {
            return;
        }
        Map<String, Long> existIds = this.loadExistIds();
        ArrayList<SqlParameter[]> updateParams = new ArrayList<SqlParameter[]>(this.keyValues.size());
        ArrayList<SqlParameter[]> insertParams = new ArrayList<SqlParameter[]>(this.keyValues.size());
        Date currTime = WriteHelper.getCurrTime();
        long overtime = currTime.getTime() + this.timeoutSeconds * 1000L;
        for (Map.Entry<String, String> entry : this.keyValues.entrySet()) {
            SqlParameter[] params;
            Long id = existIds.get(entry.getKey());
            if (id == null) {
                params = new SqlParameter[]{new SqlParameter("fid", -5, (Object)DB.genGlobalLongId()), new SqlParameter("fregion", 12, (Object)this.regionKey), new SqlParameter("ftype", 12, (Object)this.type), new SqlParameter("fkey", 12, (Object)entry.getKey()), new SqlParameter("fvalue", 2005, (Object)entry.getValue()), new SqlParameter("fcreatetime", 91, (Object)currTime), new SqlParameter("fovertime", -5, (Object)overtime)};
                insertParams.add(params);
                continue;
            }
            params = new SqlParameter[]{new SqlParameter("fvalue", 2005, (Object)entry.getValue()), new SqlParameter("fovertime", -5, (Object)overtime), new SqlParameter("fid", -5, (Object)id)};
            updateParams.add(params);
        }
        if (!updateParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.log, (String)"update t_log_dbcache set fvalue = ?, fovertime = ? where fid = ?", updateParams);
        }
        if (!insertParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.log, (String)"insert t_log_dbcache(fid, fregion, ftype, fkey, fvalue, fcreatetime, fovertime) values (?, ?, ?, ?, ?, ?, ?)", insertParams);
        }
    }

    private DbCacheReader getReader() {
        if (this.reader == null) {
            this.reader = new DbCacheReader();
        }
        return this.reader;
    }

    private Map<String, Long> loadExistIds() {
        Map<String, Long> existIds = null;
        if (this.keyValues.size() == 1) {
            String key = this.keyValues.entrySet().iterator().next().getKey();
            Long id = this.getReader().loadId(this.regionKey, this.type, key);
            if (id == null) {
                existIds = new HashMap<String, Long>(0);
            } else {
                existIds = new HashMap<String, Long>(1);
                existIds.put(key, id);
            }
        } else {
            existIds = this.getReader().loadKeyToIds(this.regionKey, this.type, this.keyValues.keySet().toArray(new String[0]));
        }
        return existIds;
    }
}

