/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ha.db.dao;

import java.util.Arrays;
import kd.bos.cache.ha.db.dao.IWriteAction;
import kd.bos.cache.ha.db.dao.WriteHelper;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;

class RemoveTypeKeyValueAction
implements IWriteAction {
    private String regionKey;
    private String type;
    private String[] keys;

    public RemoveTypeKeyValueAction(String regionKey, String type) {
        this.regionKey = regionKey;
        this.type = type;
    }

    public RemoveTypeKeyValueAction(String regionKey, String type, String key) {
        this.regionKey = regionKey;
        this.type = type;
        if (key != null && !"".equals(key)) {
            this.keys = new String[]{key};
        }
    }

    public RemoveTypeKeyValueAction(String regionKey, String type, String[] keys) {
        this.regionKey = regionKey;
        this.type = type;
        if (keys != null && keys.length > 0) {
            this.keys = Arrays.copyOf(keys, keys.length);
        }
    }

    private boolean validate() {
        return this.regionKey != null && this.type != null && !"".equals(this.type);
    }

    @Override
    public String getLockKey() {
        return WriteHelper.getLockKey(this.regionKey, this.type);
    }

    @Override
    public void execute() {
        if (!this.validate()) {
            return;
        }
        SqlParameter regionParam = new SqlParameter("fregion", 12, (Object)this.regionKey);
        SqlParameter typeParam = new SqlParameter("ftype", 12, (Object)this.type);
        SqlBuilder sqlBuilder = new SqlBuilder();
        if (this.keys == null || this.keys.length == 0) {
            sqlBuilder.append("delete t_log_dbcache where fregion = ? and ftype = ?", new Object[]{regionParam, typeParam});
        } else if (this.keys.length == 1) {
            SqlParameter keyParam = new SqlParameter("fkey", 12, (Object)this.keys[0]);
            sqlBuilder.append("delete t_log_dbcache where fregion = ? and ftype = ? and FKey = ?", new Object[]{regionParam, typeParam, keyParam});
        } else {
            sqlBuilder.append("delete t_log_dbcache where fregion = ? and ftype = ?", new Object[]{regionParam, typeParam});
            sqlBuilder.append(" AND ", new Object[0]);
            sqlBuilder.appendIn("fkey", (Object[])this.keys);
        }
        DB.execute((DBRoute)DBRoute.log, (SqlBuilder)sqlBuilder);
    }
}

