/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ha.db.dao;

import java.util.Date;
import kd.bos.cache.ha.db.dao.DbCacheReader;
import kd.bos.cache.ha.db.dao.IWriteAction;
import kd.bos.cache.ha.db.dao.WriteHelper;

class SetListObjectAction
implements IWriteAction {
    private String regionKey;
    private String key;
    private int index;
    private String value;
    private Date currTime = WriteHelper.getCurrTime();
    private long timeoutSeconds;

    public SetListObjectAction(String regionKey, String key, int index, String value, int timeoutSeconds) {
        this.regionKey = regionKey;
        this.key = key;
        this.index = index;
        this.value = value;
        this.timeoutSeconds = timeoutSeconds;
    }

    private boolean validate() {
        return this.regionKey != null && this.key != null && !"".equals(this.key) && this.index >= 0 && this.value != null;
    }

    @Override
    public String getLockKey() {
        return WriteHelper.getLockKey(this.regionKey, this.key);
    }

    @Override
    public void execute() {
        if (!this.validate()) {
            return;
        }
        DbCacheReader reader = new DbCacheReader();
        int seq = this.index + 1;
        Long id = reader.loadId(this.regionKey, this.key);
        if (id != null) {
            WriteHelper.updateListOvertime(id, this.currTime, this.timeoutSeconds);
            WriteHelper.updateListValue(id, seq, this.value, this.currTime, this.timeoutSeconds);
        }
    }
}

