/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ha.db.dao;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;

class WriteHelper {
    private static final String DEFAULT_TIMEOUT_KEY = "redis.defaulttimeout";
    private static final int DEFAULT_TIMEOUT = 3600;

    private WriteHelper() {
    }

    public static Date getCurrTime() {
        return new Date();
    }

    public static int getDefaultTimeout() {
        String s = System.getProperty(DEFAULT_TIMEOUT_KEY);
        if (s != null) {
            try {
                return Integer.parseInt(s.trim());
            }
            catch (Exception t) {
                return 3600;
            }
        }
        return 3600;
    }

    public static String getLockKey(String regionKey, String type) {
        return String.format("%s.%s", regionKey, type);
    }

    public static long insertListType(String regionKey, String type, Date createTime, long timeoutSeconds) {
        String sql = "insert t_log_dbcache(fid, fregion, ftype, fcreatetime, fovertime) values (?, ?, ?, ?, ?)";
        long id = DB.genGlobalLongId();
        long overtime = createTime.getTime() + timeoutSeconds * 1000L;
        Object[] params = new SqlParameter[]{new SqlParameter("fid", -5, (Object)id), new SqlParameter("fregion", 12, (Object)regionKey), new SqlParameter("ftype", 12, (Object)type), new SqlParameter("fcreatetime", 91, (Object)createTime), new SqlParameter("fovertime", -5, (Object)overtime)};
        DB.execute((DBRoute)DBRoute.log, (String)sql, (Object[])params);
        return id;
    }

    public static void insertListValues(long id, int beginSeq, String[] values, Date createTime, long timeoutSeconds) {
        String sql = "insert t_log_dbcacheentry(fentryid, fid, fseq, fvalue, fcreatetime, fovertime) values (?, ?, ?, ?, ?, ?)";
        long overtime = createTime.getTime() + timeoutSeconds * 1000L;
        long[] entryIds = DB.genGlobalLongIds((int)values.length);
        ArrayList<SqlParameter[]> batchParams = new ArrayList<SqlParameter[]>(values.length);
        for (int i = 0; i < values.length; ++i) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("fregion", 12, (Object)entryIds[i]), new SqlParameter("fid", -5, (Object)id), new SqlParameter("fseq", 4, (Object)(beginSeq + i)), new SqlParameter("fvalue", 2005, (Object)values[i]), new SqlParameter("fcreatetime", 91, (Object)createTime), new SqlParameter("fovertime", -5, (Object)overtime)};
            batchParams.add(params);
        }
        DB.executeBatch((DBRoute)DBRoute.log, (String)sql, batchParams);
    }

    public static void updateListValue(long id, int seq, String value, Date currTime, long timeoutSeconds) {
        String sql = "update t_log_dbcacheentry set fvalue = ?, fovertime = ? where fid = ? and fseq = ?";
        long overtime = currTime.getTime() + timeoutSeconds * 1000L;
        Object[] params = new SqlParameter[]{new SqlParameter("fvalue", 2005, (Object)value), new SqlParameter("fovertime", -5, (Object)overtime), new SqlParameter("fid", -5, (Object)id), new SqlParameter("fseq", 4, (Object)seq)};
        DB.execute((DBRoute)DBRoute.log, (String)sql, (Object[])params);
    }

    public static void updateListSeq(long id, int beginSeq, int insertLength) {
        String sql = "update t_log_dbcacheentry set fseq = fseq + ? where fid = ? and fseq >= ?";
        Object[] params = new SqlParameter[]{new SqlParameter("Length", 4, (Object)insertLength), new SqlParameter("fid", -5, (Object)id), new SqlParameter("fseq", 4, (Object)beginSeq)};
        DB.execute((DBRoute)DBRoute.log, (String)sql, (Object[])params);
    }

    public static void updateListOvertime(long id, Date currTime, long timeoutSeconds) {
        String sql = "update t_log_dbcache set fovertime = ? where fid = ?";
        long overtime = currTime.getTime() + timeoutSeconds * 1000L;
        Object[] params = new SqlParameter[]{new SqlParameter("fovertime", -5, (Object)overtime), new SqlParameter("fid", -5, (Object)id)};
        DB.execute((DBRoute)DBRoute.log, (String)sql, (Object[])params);
        String entrySql = "update t_log_dbcacheentry set fovertime = ? where fid = ?";
        Object[] entryParams = new SqlParameter[]{new SqlParameter("fovertime", -5, (Object)overtime), new SqlParameter("fid", -5, (Object)id)};
        DB.execute((DBRoute)DBRoute.log, (String)entrySql, (Object[])entryParams);
    }

    public static void updateOvertime(long id, Date currTime, long timeoutSeconds) {
        String sql = "update t_log_dbcache set fovertime = ? where fid = ?";
        long overtime = currTime.getTime() + timeoutSeconds * 1000L;
        Object[] params = new SqlParameter[]{new SqlParameter("fovertime", -5, (Object)overtime), new SqlParameter("fid", -5, (Object)id)};
        DB.execute((DBRoute)DBRoute.log, (String)sql, (Object[])params);
    }

    public static void deleteListValues(long id, int beginSeq, int endSeq) {
        String sql = "delete t_log_dbcacheentry where fid = ? and fseq >= ? and fseq <= ?";
        Object[] params = new SqlParameter[]{new SqlParameter("fid", -5, (Object)id), new SqlParameter("fseq", 4, (Object)beginSeq), new SqlParameter("fseq", 4, (Object)endSeq)};
        DB.execute((DBRoute)DBRoute.log, (String)sql, (Object[])params);
    }

    public static void clearOvertimeValues() {
        long currTime = WriteHelper.getCurrTime().getTime();
        long overTime = currTime + 30000L;
        Object[] params = new SqlParameter[]{new SqlParameter("fovertime", -5, (Object)overTime)};
        DB.execute((DBRoute)DBRoute.log, (String)"delete t_log_dbcache where fovertime < ?", (Object[])params);
        DB.execute((DBRoute)DBRoute.log, (String)"delete t_log_dbcacheentry where fovertime < ?", (Object[])params);
    }
}

