/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.bootstrap.springboot;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.framework.lifecycle.services.ConfigurationService;
import kd.bos.instance.Instance;
import kd.bos.mservice.config.MserviceAssemblyConfig;
import kd.bos.mservice.config.MserviceConfigUtil;
import kd.bos.service.bootstrap.springboot.ConfigureWebServerFactory;
import kd.bos.service.bootstrap.springboot.SpringbootApplicationServer;
import kd.bos.util.StringUtils;
import kd.bos.util.WebPortUtil;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;

public class KDSpringApplicationRunListener
implements SpringApplicationRunListener {
    private static boolean isInitBootProperties;
    private final SpringApplication springApplication;
    private final String[] args;
    private Class primarySourceClass;
    private ConfigurableEnvironment environment;
    private static List<String> scanPackages;

    public KDSpringApplicationRunListener(SpringApplication springApplication, String[] args) {
        this.springApplication = springApplication;
        this.args = args;
        try {
            Field primarySourcesField = SpringApplication.class.getDeclaredField("primarySources");
            primarySourcesField.setAccessible(true);
            Set primarySourcesSet = (Set)primarySourcesField.get(springApplication);
            Iterator iterator = primarySourcesSet.iterator();
            if (iterator.hasNext()) {
                Class primarySourcesClass;
                this.primarySourceClass = primarySourcesClass = (Class)iterator.next();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void environmentPrepared(ConfigurableBootstrapContext bootstrapContext, ConfigurableEnvironment environment) {
        if (!isInitBootProperties) {
            this.environment = environment;
            this.resetAllProperties(environment);
            String mserviceAssemblyType = this.getProperty("mservice.assembly.type");
            if (mserviceAssemblyType != null) {
                this.initProperties();
                isInitBootProperties = true;
            }
        }
    }

    private void resetAllProperties(ConfigurableEnvironment env) {
        MutablePropertySources sources = ((AbstractEnvironment)env).getPropertySources();
        HashMap<String, String> sysprops = new HashMap<String, String>(System.getenv().size() + System.getProperties().size());
        sysprops.putAll(System.getenv());
        for (String key : System.getProperties().stringPropertyNames()) {
            sysprops.put(key, System.getProperty(key));
        }
        for (PropertySource source : sources) {
            String[] names;
            if (!(source instanceof EnumerablePropertySource)) continue;
            String[] stringArray = names = ((EnumerablePropertySource)source).getPropertyNames();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                Object propObj;
                String name;
                String tiansRealName = name = stringArray[i];
                if (name.startsWith("ts.")) {
                    tiansRealName = name.substring(3);
                }
                if (sysprops.containsKey(tiansRealName) || (propObj = source.getProperty(name)) == null) continue;
                String propStr = propObj.toString();
                System.setProperty(tiansRealName, propStr);
                sysprops.put(tiansRealName, propStr);
                if (!"server.servlet.context-path".equals(tiansRealName) || !sysprops.containsKey("webserver.context-path") && !sysprops.containsKey("JETTY_CONTEXT")) continue;
                System.setProperty("webserver.context-path", propStr);
                System.setProperty("JETTY_CONTEXT", propStr);
                sysprops.put("webserver.context-path", propStr);
            }
        }
        String springAppName = System.getProperty("spring.application.name");
        if (System.getProperty("appName") == null && springAppName != null) {
            System.setProperty("appName", springAppName);
        }
    }

    private String getProperty(String key) {
        return this.environment.getProperty(key);
    }

    private void initProperties() {
        int connectTimeout;
        int readTimeout;
        this.initComponentScanBasePackages();
        System.setProperty("spring.cloud.httpclientfactories.ok.enabled", "false");
        ConfigurationService service = new ConfigurationService();
        service.start();
        String webPort = WebPortUtil.getWebPort((String)WebPortUtil.getServerPort());
        System.setProperty("server.port", webPort);
        String appName = this.getProperty("appName");
        if (appName != null && this.getProperty("spring.application.name") == null) {
            System.setProperty("spring.application.name", appName.replaceAll("_", "-"));
        }
        this.initFeignClientContextPath();
        String rpctype = MserviceAssemblyConfig.MSERVICE_RPC_TYPE;
        if ("feign".equals(rpctype)) {
            System.setProperty("feign.config.auto", "true");
            readTimeout = Integer.getInteger("mservice.consumer.readTimeout", Integer.getInteger("feign.client.config.default.readTimeout", 580000));
            System.setProperty("feign.client.config.default.readTimeout", String.valueOf(readTimeout));
            connectTimeout = Integer.getInteger("mservice.consumer.connectTimeout", Integer.getInteger("feign.client.config.default.connectTimeout", 5000));
            System.setProperty("feign.client.config.default.connectTimeout", String.valueOf(connectTimeout));
            this.initFeignClientBasePackages();
        } else if ("dubbo".equals(rpctype)) {
            System.setProperty("spring.cloud.zookeeper.enabled", "false");
            System.setProperty("ribbon.zookeeper.enabled", "false");
            System.setProperty("spring.cloud.nacos.discovery.enabled", "false");
            System.setProperty("spring.cloud.zookeeper.discovery.enabled", "false");
            System.setProperty("spring.cloud.discovery.enabled", "false");
            if (null == this.getProperty("dubbo.config-center.timeout")) {
                System.setProperty("dubbo.config-center.timeout", "30000");
            }
            if ("eureka".equals(MserviceAssemblyConfig.MSERVICE_DISCOVERY_TYPE)) {
                MserviceAssemblyConfig.MSERVICE_DISCOVERY_TYPE = "zookeeper";
            }
            System.setProperty("dubbo.registry.group", Instance.getClusterName());
        } else if ("assembly".equals(rpctype)) {
            System.setProperty("feign.config.auto", "true");
            readTimeout = Integer.getInteger("mservice.consumer.readTimeout", Integer.getInteger("feign.client.config.default.readTimeout", 580000));
            System.setProperty("feign.client.config.default.readTimeout", String.valueOf(readTimeout));
            connectTimeout = Integer.getInteger("mservice.consumer.connectTimeout", Integer.getInteger("feign.client.config.default.connectTimeout", 5000));
            System.setProperty("feign.client.config.default.connectTimeout", String.valueOf(connectTimeout));
            if (null == this.getProperty("dubbo.config-center.timeout")) {
                System.setProperty("dubbo.config-center.timeout", "30000");
            }
            if ("eureka".equals(MserviceAssemblyConfig.MSERVICE_DISCOVERY_TYPE)) {
                MserviceAssemblyConfig.MSERVICE_DISCOVERY_TYPE = "zookeeper";
            }
            System.setProperty("dubbo.registry.group", Instance.getClusterName());
            this.initFeignClientBasePackages();
        }
        String discoverytype = MserviceAssemblyConfig.MSERVICE_DISCOVERY_TYPE;
        if ("zookeeper".equals(discoverytype)) {
            System.setProperty("eureka.client.enabled", "false");
            System.setProperty("ribbon.eureka.enabled", "false");
            System.setProperty("spring.cloud.discovery.enabled", "true");
            System.setProperty("spring.cloud.zookeeper.discovery.enabled", "true");
            System.setProperty("spring.cloud.nacos.discovery.enabled", "false");
            System.setProperty("spring.cloud.zookeeper.discovery.preferIpAddress", "true");
            System.setProperty("spring.cloud.loadbalancer.cache.ttl", System.getProperty("spring.cloud.loadbalancer.cache.ttl", "15"));
            String address = MserviceConfigUtil.getRegisterUrlByType((String)"zookeeper");
            if (address == null && (address = this.getProperty("dubbo.registry.address")) == null) {
                address = this.getProperty("configUrl");
            }
            if ("dubbo".equals(rpctype)) {
                System.setProperty("spring.cloud.discovery.enabled", "false");
                System.setProperty("spring.cloud.zookeeper.discovery.enabled", "false");
                System.setProperty("dubbo.registry.address", address);
            } else if ("feign".equals(rpctype)) {
                System.setProperty("spring.cloud.zookeeper.connect-string", address);
                System.setProperty("spring.cloud.kcommonregistry.connect-string", address);
            } else if ("assembly".equals(rpctype)) {
                String dubboAddress = this.getProperty("dubbo.registry.address");
                if (StringUtils.isEmpty((String)dubboAddress)) {
                    System.setProperty("dubbo.registry.address", address);
                }
                System.setProperty("spring.cloud.zookeeper.connect-string", address);
                System.setProperty("spring.cloud.kcommonregistry.connect-string", address);
            }
        } else if ("nacos".equals(discoverytype)) {
            System.setProperty("eureka.client.enabled", "false");
            System.setProperty("ribbon.eureka.enabled", "false");
            System.setProperty("spring.cloud.zookeeper.enabled", "false");
            System.setProperty("ribbon.zookeeper.enabled", "false");
            System.setProperty("spring.cloud.zookeeper.discovery.enabled", "false");
            String url = MserviceConfigUtil.getRegisterUrlByType((String)"nacos");
            if (url == null) {
                url = this.getProperty("nacos.server.addr");
                String userName = System.getProperty("nacos.registry.username");
                String password = System.getProperty("nacos.registry.password");
                if (userName != null) {
                    System.setProperty("spring.cloud.nacos.discovery.username", userName);
                    System.setProperty("spring.cloud.kcommonregistry.username", userName);
                }
                if (password != null) {
                    System.setProperty("spring.cloud.nacos.discovery.password", password);
                    System.setProperty("spring.cloud.kcommonregistry.password", password);
                }
            }
            if ("dubbo".equals(rpctype)) {
                System.setProperty("dubbo.registry.protocol", "nacos");
                System.setProperty("dubbo.registry.address", url);
            } else if ("feign".equals(rpctype)) {
                System.setProperty("spring.cloud.discovery.enabled", "true");
                System.setProperty("spring.cloud.nacos.discovery.enabled", "true");
                System.setProperty("spring.cloud.nacos.discovery.server-addr", url);
                System.setProperty("spring.cloud.kcommonregistry.connect-string", url);
                System.setProperty("spring.cloud.loadbalancer.cache.enabled", "false");
            } else if ("assembly".equals(rpctype)) {
                String protocol = this.getProperty("dubbo.registry.protocol");
                String address = this.getProperty("dubbo.registry.address");
                if (StringUtils.isEmpty((String)protocol) || "nacos".equals(protocol)) {
                    System.setProperty("dubbo.registry.protocol", "nacos");
                }
                if (StringUtils.isEmpty((String)address)) {
                    System.setProperty("dubbo.registry.address", url);
                }
                System.setProperty("spring.cloud.discovery.enabled", "true");
                System.setProperty("spring.cloud.nacos.discovery.enabled", "true");
                System.setProperty("spring.cloud.nacos.discovery.server-addr", url);
                System.setProperty("spring.cloud.kcommonregistry.connect-string", url);
                System.setProperty("spring.cloud.loadbalancer.cache.enabled", "false");
            }
        } else if ("eureka".equals(discoverytype)) {
            if (Boolean.getBoolean("eureka.usecustomclient")) {
                System.setProperty("eureka.client.enabled", "false");
            } else {
                System.setProperty("eureka.client.enabled", "true");
            }
            System.setProperty("spring.cloud.zookeeper.enabled", "false");
            System.setProperty("ribbon.zookeeper.enabled", "false");
            System.setProperty("spring.cloud.nacos.discovery.enabled", "false");
            System.setProperty("spring.cloud.zookeeper.discovery.enabled", "false");
            System.setProperty("spring.cloud.discovery.enabled", "true");
            System.setProperty("eureka.instance.prefer-ip-address", "true");
            String url = this.getProperty("eureka.url");
            if (url == null) {
                url = MserviceConfigUtil.getRegisterUrlByType((String)"eureka");
            }
            if (url != null) {
                if (!url.endsWith("/eureka/")) {
                    url = url.endsWith("/") ? url + "eureka/" : (url.endsWith("/eureka") ? url + "/" : url + "/eureka/");
                }
                System.setProperty("eureka.client.serviceUrl.defaultZone", url);
                System.setProperty("spring.cloud.kcommonregistry.connect-string", url);
            }
        }
        if (null == this.getProperty("spring.servlet.multipart.enabled")) {
            System.setProperty("spring.servlet.multipart.enabled", "false");
        }
        if (null == this.getProperty("server.max-http-header-size")) {
            System.setProperty("server.max-http-header-size", String.valueOf(16384));
        }
        if (null == this.getProperty("server.jetty.max-http-form-post-size")) {
            System.setProperty("server.jetty.max-http-form-post-size", "200000000");
        }
        if (null == this.getProperty("server.tomcat.max-http-form-post-size")) {
            System.setProperty("server.tomcat.max-http-form-post-size", "200000000");
        }
        String dp = this.getProperty("dubbo.registry.register");
        String mp = this.getProperty("mservice.registry.register");
        if (mp != null) {
            System.setProperty("dubbo.registry.register", mp);
        } else if (dp != null) {
            System.setProperty("mservice.registry.register", dp);
        }
        ConfigureWebServerFactory.init();
        this.setExcludeAutoConfigurations();
        this.setKcommonRegistryCenter();
    }

    private void setKcommonRegistryCenter() {
        if ("true".equals(System.getProperty("kregistrycenter.enable"))) {
            System.setProperty("spring.cloud.kcommon.discovery.enabled", "true");
            System.setProperty("spring.cloud.zookeeper.enabled", "false");
            System.setProperty("ribbon.zookeeper.enabled", "false");
            System.setProperty("spring.cloud.zookeeper.discovery.enabled", "false");
            System.setProperty("spring.cloud.nacos.discovery.enabled", "false");
            System.setProperty("eureka.client.enabled", "false");
            System.setProperty("ribbon.eureka.enabled", "false");
            String rpctype = MserviceAssemblyConfig.MSERVICE_RPC_TYPE;
            if ("dubbo".equals(rpctype)) {
                System.setProperty("spring.cloud.kcommon.discovery.enabled", "false");
            } else {
                System.setProperty("spring.cloud.kcommon.discovery.enabled", "true");
            }
        }
    }

    private void initFeignClientContextPath() {
        String contextPath = System.getProperty("webserver.context-path");
        if (StringUtils.isEmpty((String)contextPath)) {
            contextPath = System.getProperty("JETTY_CONTEXT", "ierp");
        } else {
            System.setProperty("JETTY_CONTEXT", contextPath);
        }
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        System.setProperty("feign.client.context.path", contextPath);
    }

    private void setExcludeAutoConfigurations() {
        if (!Boolean.parseBoolean(System.getProperty("mservice.boot.autoconfig.filter.enable", "false"))) {
            return;
        }
        Properties prop = new Properties();
        try (InputStream inStream = SpringbootApplicationServer.class.getClassLoader().getResourceAsStream("exclude-factories.properties");){
            prop.load(inStream);
            System.setProperty("spring.autoconfigure.exclude", prop.getProperty("exclude.autoconfig.class"));
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{e.getMessage()});
        }
    }

    private void initComponentScanBasePackages() {
        scanPackages.add(ClassUtils.getPackageName((String)this.primarySourceClass.getName()));
        scanPackages.add("kd.bos.mservice.rpc.feign");
        scanPackages.add("kd.bos.service.invoke.spring");
        String scanPackageClassStr = System.getProperty("spring.bean.scanpackage");
        if (scanPackageClassStr != null && scanPackageClassStr.length() > 0) {
            String[] scanPackageClasses;
            for (String scanPackageClas : scanPackageClasses = scanPackageClassStr.split(",|;")) {
                if (scanPackageClas.trim().length() <= 0) continue;
                scanPackages.add(scanPackageClas);
            }
        }
        try {
            SpringBootApplication annotation = this.primarySourceClass.getDeclaredAnnotation(SpringBootApplication.class);
            if (annotation == null) {
                return;
            }
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(annotation);
            Class<?> clazz = invocationHandler.getClass();
            Field field = clazz.getDeclaredField("memberValues");
            field.setAccessible(true);
            Map map = (Map)field.get(invocationHandler);
            String[] targets = scanPackages.toArray(new String[0]);
            map.put("scanBasePackages", targets);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[]{ex.getMessage()});
        }
    }

    private void initFeignClientBasePackages() {
        ArrayList<String> packageList = new ArrayList<String>();
        packageList.add("kd.bos.mservice.rpc.feign");
        String scanPackageClassStr = System.getProperty("feign.client.scanpackage");
        if (scanPackageClassStr != null && scanPackageClassStr.length() > 0) {
            String[] scanPackageClasses;
            for (String scanPackageClas : scanPackageClasses = scanPackageClassStr.split(",|;")) {
                if (scanPackageClas.trim().length() <= 0) continue;
                packageList.add(scanPackageClas);
            }
        }
        try {
            EnableFeignClients annotation = this.primarySourceClass.getDeclaredAnnotation(EnableFeignClients.class);
            if (annotation == null) {
                return;
            }
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(annotation);
            Class<?> clazz = invocationHandler.getClass();
            Field field = clazz.getDeclaredField("memberValues");
            field.setAccessible(true);
            Map map = (Map)field.get(invocationHandler);
            String[] oldBasePackages = (String[])map.get("basePackages");
            if (oldBasePackages.length != 0) {
                Collections.addAll(packageList, oldBasePackages);
            }
            String[] targets = packageList.toArray(new String[0]);
            map.put("basePackages", targets);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[]{ex.getMessage()});
        }
    }

    static {
        scanPackages = new ArrayList<String>();
    }
}

