/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.bootstrap.springboot.autoconfigure;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.service.bootstrap.springboot.SpringbootApplicationServer;
import kd.bos.util.StringUtils;
import org.springframework.boot.autoconfigure.AutoConfigurationImportFilter;
import org.springframework.boot.autoconfigure.AutoConfigurationMetadata;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Order(value=-2147483648)
public class KDAutoConfigurationImportFilter
implements AutoConfigurationImportFilter,
EnvironmentAware {
    private static final String MSERVICE_BOOT_AUTOCONFIG_FILTER_ENABLE = "mservice.boot.autoconfig.filter.enable";
    private static final String MSERVICE_AUTOCONFIG_CONFIG = "KAutoConfigSpringFactoryFiles.config";
    private static final AtomicBoolean isFilterEnable = new AtomicBoolean(false);
    private static final Set<String> ALL_AUTOCONFIG_FULLCLASSNAME_SET = new HashSet<String>();
    private static volatile boolean isMatchMethodInvoke;

    public void setEnvironment(Environment environment) {
        isFilterEnable.compareAndSet(false, Boolean.parseBoolean(environment.getProperty(MSERVICE_BOOT_AUTOCONFIG_FILTER_ENABLE, "false")));
        if (isFilterEnable.get()) {
            this.init(environment);
        }
    }

    private void init(Environment environment) {
        this.loadAutoConfigClasses("META-INF/bos-autoconfig-spring.factories");
        this.loadAutoConfigClasses("META-INF/trd-autoconfig-spring.factories");
        String extSpringFactoryFiles = environment.getProperty(MSERVICE_AUTOCONFIG_CONFIG);
        if (StringUtils.isNotEmpty((String)extSpringFactoryFiles)) {
            String[] extSpringFactoryFileArray;
            for (String tempFile : extSpringFactoryFileArray = extSpringFactoryFiles.split(",")) {
                this.loadAutoConfigClasses(tempFile);
            }
        }
    }

    private void loadAutoConfigClasses(String fileName) {
        Properties prop = new Properties();
        try (InputStream inStream = SpringbootApplicationServer.class.getClassLoader().getResourceAsStream(fileName);){
            String[] autoConfigClasses;
            prop.load(inStream);
            for (String tempClassName : autoConfigClasses = prop.getProperty("autoconfig.class").split(",")) {
                ALL_AUTOCONFIG_FULLCLASSNAME_SET.add(tempClassName.trim());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean[] match(String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
        boolean[] resultBooleans = new boolean[autoConfigurationClasses.length];
        if (!isFilterEnable.get()) {
            Arrays.fill(resultBooleans, true);
            return resultBooleans;
        }
        if (isMatchMethodInvoke) {
            Arrays.fill(resultBooleans, true);
            return resultBooleans;
        }
        for (int i = 0; i < autoConfigurationClasses.length; ++i) {
            String tempClassName = autoConfigurationClasses[i];
            if (!ALL_AUTOCONFIG_FULLCLASSNAME_SET.contains(tempClassName)) continue;
            resultBooleans[i] = true;
        }
        isMatchMethodInvoke = true;
        return resultBooleans;
    }
}

