/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.bootstrap.springboot.webserver.jetty;

import kd.bos.metric.MetricSystem;
import kd.bos.service.bootstrap.springboot.webserver.AbstractConfigureWebServer;
import kd.bos.service.bootstrap.springboot.webserver.ConfigureWebServer;
import kd.bos.service.bootstrap.springboot.webserver.jetty.JettyServletWebServerFactoryImpl;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JettyConfigureWebServer
extends AbstractConfigureWebServer
implements ConfigureWebServer {
    @Bean
    @ConditionalOnProperty(name={"webserver.type"}, havingValue="jetty", matchIfMissing=true)
    public JettyServletWebServerFactory jettyEmbeddedServletContainerFactory(JettyServerCustomizer jettyServerCustomizer) {
        JettyServletWebServerFactoryImpl factory = new JettyServletWebServerFactoryImpl(JettyConfigureWebServer.getContextPath(), JettyConfigureWebServer.getPort());
        factory.addServerCustomizers(new JettyServerCustomizer[]{jettyServerCustomizer});
        return factory;
    }

    @Bean
    @ConditionalOnProperty(name={"webserver.type"}, havingValue="jetty", matchIfMissing=true)
    public JettyServerCustomizer jettyServerCustomizer() {
        return server -> {
            Integer maxThreads = Integer.parseInt(System.getProperty("JETTY_MAXTHREADS", "200"));
            QueuedThreadPool threadPool = (QueuedThreadPool)server.getBean(QueuedThreadPool.class);
            threadPool.setMaxThreads(maxThreads.intValue());
            threadPool.setMinThreads(20);
            threadPool.setName("http-request-pool");
            MetricSystem.registerGauge((String)"kd.metrics.jettyserver.http.threadpool.maxThreads", () -> maxThreads);
            MetricSystem.registerGauge((String)"kd.metrics.jettyserver.http.threadpool.busyThreads", () -> threadPool.getBusyThreads());
        };
    }
}

