/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.bootstrap.springboot.webserver.jetty;

import java.io.IOException;
import java.util.concurrent.locks.LockSupport;
import kd.bos.eye.httpserver.EyeInstaller;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.httpserver.MonitorInstaller;
import kd.bos.msgjet.websocket.jetty.MsgWebSocketHandler;
import kd.bos.service.web.WebResourceUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.DescriptorProcessor;
import org.eclipse.jetty.webapp.StandardDescriptorProcessor;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.embedded.jetty.JettyWebServer;

public class JettyServletWebServerFactoryImpl
extends JettyServletWebServerFactory {
    private static final Log log = LogFactory.getLog(JettyServletWebServerFactoryImpl.class);
    private Server server;

    public JettyServletWebServerFactoryImpl() {
    }

    public JettyServletWebServerFactoryImpl(int port) {
        super(port);
    }

    public JettyServletWebServerFactoryImpl(String contextPath, int port) {
        super(contextPath, port);
    }

    protected JettyWebServer getJettyWebServer(Server server) {
        this.server = server;
        try {
            this.install();
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        JettyWebServer jetty = super.getJettyWebServer(server);
        return jetty;
    }

    protected void postProcessWebAppContext(WebAppContext webAppContext) {
        String webResourcPath = JettyServletWebServerFactoryImpl.getProperty("JETTY_WEBRES_PATH", null);
        if (webResourcPath != null) {
            webAppContext.setResourceBase(webResourcPath + "/");
        } else {
            String webappPath = System.getProperty("JETTY_WEBAPP_PATH", "webapp");
            webAppContext.setResourceBase(webappPath + "/");
        }
        try {
            String source = System.getProperty("JETTY_WEBXML_PATH", JettyServletWebServerFactoryImpl.class.getClassLoader().getResource(WebResourceUtils.getWebReousrceXmlPath()).getPath());
            Resource webInfResource = null;
            try {
                webInfResource = webAppContext.newResource("jar:" + source);
            }
            catch (Exception e) {
                webInfResource = webAppContext.newResource("file:" + source);
            }
            webAppContext.getMetaData().setWebXml(webInfResource);
            webAppContext.getMetaData().addDescriptorProcessor((DescriptorProcessor)new StandardDescriptorProcessor());
            int max = Integer.getInteger("org.eclipse.jetty.server.Request.maxFormContentSize", 200000000);
            webAppContext.setMaxFormContentSize(max);
            webAppContext.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
            if (Instance.isLightWeightDeploy()) {
                webAppContext.setInitParameter("useFileMappedBuffer", "false");
                webAppContext.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
            }
            MonitorInstaller.install((Object)webAppContext);
            EyeInstaller.install((ServletContextHandler)webAppContext);
            MonitorInstaller.installIerp((Object)webAppContext);
            EyeInstaller.installIerp((Object)webAppContext);
            super.postProcessWebAppContext(webAppContext);
        }
        catch (Exception e) {
            log.error("Starting to exit the service\uff1a", (Throwable)e);
            LockSupport.parkNanos(1000000000L);
            System.exit(-1);
        }
    }

    private void install() throws IOException {
        ServletContextHandler monitorContext = new ServletContextHandler();
        MonitorInstaller.install((Object)monitorContext);
        EyeInstaller.install((ServletContextHandler)monitorContext);
        MonitorInstaller.installIerp((Object)monitorContext);
        EyeInstaller.installIerp((Object)monitorContext);
        MsgWebSocketHandler msgHandler = new MsgWebSocketHandler();
        ContextHandler msgWebsocketContext = new ContextHandler();
        msgWebsocketContext.setContextPath(this.getContextPath() + "/msgwatch/*");
        msgWebsocketContext.setHandler((Handler)msgHandler);
        ContextHandler msgWebsocketContext1 = new ContextHandler();
        msgWebsocketContext1.setContextPath("/msgwatch/*");
        msgWebsocketContext1.setHandler((Handler)msgHandler);
        ContextHandlerCollection handler = new ContextHandlerCollection();
        handler.addHandler(this.server.getHandler());
        handler.addHandler((Handler)monitorContext);
        handler.addHandler((Handler)msgWebsocketContext);
        handler.addHandler((Handler)msgWebsocketContext1);
        this.server.setHandler((Handler)handler);
    }

    private static String getProperty(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        value = System.getenv(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }
}

