/*
 * Decompiled with CFR 0.152.
 */
package kd.bos;

import java.util.Map;
import java.util.UUID;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.StringUtils;

public class SessionIdUtils {
    static String APP_TOKEN_TIMEOUT_KEY = "apptoken.timeout";
    static int DEFAULT_TIMEOUT = 7200;
    private static final String TRUE_STRING = "true";
    private static final String[] arr = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    public static int getTokenTimeout(String tenantId) {
        return SystemPropertyUtils.getInteger(tenantId, APP_TOKEN_TIMEOUT_KEY, DEFAULT_TIMEOUT);
    }

    public static String newSessionId() {
        if (Boolean.getBoolean("bos.session.longid")) {
            return SessionIdUtils.randomWord(Integer.getInteger("bos.session.idlength", 126)) + SessionIdUtils.getHourSubOfDay();
        }
        return UUID.randomUUID().toString() + SessionIdUtils.getHourSubOfDay();
    }

    public static String getHourSubOfDay() {
        long curTime = System.currentTimeMillis();
        long timeOfDay = curTime % 86400000L;
        int hour = (int)timeOfDay / 3600000;
        return hour <= 9 ? "0" + hour : "" + hour;
    }

    private static String randomWord(int length) {
        return StringUtils.randomWord((int)length);
    }

    public static String getTenantIdBySessionId(String key) {
        String accountId;
        Account account;
        String[] arrays;
        String tenantId = null;
        if (StringUtils.isNotEmpty((String)key) && 2 == (arrays = key.split("_")).length && (account = AccountUtils.getAccountById((String)(accountId = arrays[0]))) != null) {
            tenantId = account.getTenantId();
        }
        return tenantId;
    }

    public static Account getAccountByKey(String key) {
        Account account = null;
        String accountId = SessionIdUtils.getAccountIdFromKey(key);
        if (StringUtils.isNotEmpty((String)accountId)) {
            account = AccountUtils.getAccountById((String)accountId);
        }
        return account;
    }

    public static String getAccountIdFromKey(String key) {
        String[] arrays;
        String accountId = "";
        if (StringUtils.isNotEmpty((String)key) && 2 == (arrays = key.split("_")).length) {
            accountId = arrays[0];
        }
        return accountId;
    }

    public static int getTimeout(String key) {
        int timeout = 6000;
        String tenantId = SessionIdUtils.getTenantIdBySessionId(key);
        if (StringUtils.isNotEmpty((String)tenantId)) {
            timeout = SessionDAO.getSessionTimeout(tenantId);
        }
        return timeout;
    }

    public static boolean isAPI(String key) {
        String client;
        boolean isAPI = false;
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO(key);
        Map<String, String> sessionInfo = sessionDAO.getAttributesAsMap(new String[]{"client"});
        if (sessionInfo != null && "api".equalsIgnoreCase(client = sessionInfo.get("client"))) {
            isAPI = true;
        }
        return isAPI;
    }

    public static int getAPITimeout(String key) {
        int timeout = 6000;
        String tenantId = SessionIdUtils.getTenantIdBySessionId(key);
        if (StringUtils.isNotEmpty((String)tenantId)) {
            timeout = SessionIdUtils.getTokenTimeout(tenantId);
        }
        return timeout;
    }
}

