/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.parameter;

import kd.bos.base.parameter.TenantServiceUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.session.service.DBUtils;
import kd.bos.util.StringUtils;

public class ParameterService {
    public static final String oldPortalFormId = "pc_main_console";
    public static final String newPortalFormId = "home_page";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("new_portal", new DistributeCacheHAPolicy(true, true));

    private static String buildCacheType(String accountId) {
        return String.format("%s.%s", "portalsetting", accountId);
    }

    private static String buildCacheKey(String key, String userId) {
        return String.format("%s.%s", key, userId);
    }

    public static void removeNewPortalSetting(String accountId, String key, String userId) {
        cache.remove(ParameterService.buildCacheType(accountId), ParameterService.buildCacheKey(key, userId));
    }

    public static boolean isSupportNewPortal() {
        return ParameterService.enableNewPortal() && ParameterService.isPersonalSettingNewPortal();
    }

    public static boolean enableNewPortal() {
        return true;
    }

    private static boolean isPersonalSettingNewPortal() {
        RequestContext rc = RequestContext.get();
        long userId = rc.getCurrUserId();
        return ParameterService.isPersonalSettingNewPortal(userId, rc.getAccountId());
    }

    public static boolean isPersonalSettingNewPortal(long userId, String accountId) {
        boolean isSupport;
        String key;
        String type = ParameterService.buildCacheType(accountId);
        String value = (String)cache.get(type, key = ParameterService.buildCacheKey("newportal", userId + ""));
        if (value != null) {
            isSupport = Boolean.parseBoolean(value);
        } else {
            Account account = AccountUtils.getAccountById((String)accountId);
            isSupport = ParameterService.getPersonalSetting(userId, account);
            cache.put(type, key, (Object)String.valueOf(isSupport));
        }
        return isSupport;
    }

    private static boolean getPersonalSetting(Long userId, Account account) {
        String selectSql = "select fusenewportal from t_bas_user_paras_config where fuserid = ?";
        Object[] params = new Object[]{userId};
        return (Boolean)DBUtils.query(account, DBRoute.base, selectSql, params, rs -> {
            if (rs.next()) {
                String useNewPortal = rs.getString("fusenewportal");
                return StringUtils.getBooleanValue((String)useNewPortal);
            }
            boolean isNewTenant = TenantServiceUtils.isNewTenantOfNewPortal();
            return isNewTenant;
        });
    }
}

