/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.database;

import kd.bos.cache.database.Call;
import kd.bos.cache.database.DbSessionableCacheException;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadTruck;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public abstract class CacheWrapper {
    private static final ThreadPool service = ThreadPools.newFixedThreadPool(CacheWrapper.class.getName(), 3);
    private static final Log log = LogFactory.getLog(CacheWrapper.class);

    protected abstract boolean isAvailable();

    protected <T> T doLoop(Call<T> callable, Call<T> dbCahce) {
        if (!this.isAvailable()) {
            return this.executeBackup(dbCahce);
        }
        int retryTimes = Integer.getInteger("ha.redis.try.times", 1);
        int i = 0;
        while (true) {
            try {
                return callable.call();
            }
            catch (KDException e) {
                ErrorCode errorCode = e.getErrorCode();
                if (errorCode == BosErrorCode.redisNotAvailable) continue;
                throw e;
                if (++i <= retryTimes) continue;
                return this.executeBackup(dbCahce);
            }
            break;
        }
    }

    protected void doInvoker(Invoker defaultInvoker, Invoker backupInvoker) {
        if (!this.isAvailable()) {
            service.execute(() -> {
                try {
                    ThreadTruck.put((Object)"isDtsExclude", (Object)Boolean.TRUE);
                    backupInvoker.invoker();
                }
                catch (DbSessionableCacheException ex) {
                    log.error("redis error: ", (Throwable)ex);
                }
                finally {
                    ThreadTruck.remove((Object)"isDtsExclude");
                }
            });
            return;
        }
        try {
            defaultInvoker.invoker();
        }
        catch (KDException e) {
            ErrorCode errorCode = e.getErrorCode();
            if (errorCode == BosErrorCode.redisNotAvailable) {
                service.execute(() -> {
                    try {
                        ThreadTruck.put((Object)"isDtsExclude", (Object)Boolean.TRUE);
                        backupInvoker.invoker();
                    }
                    catch (DbSessionableCacheException ex) {
                        log.error("redis error: ", (Throwable)ex);
                    }
                    finally {
                        ThreadTruck.remove((Object)"isDtsExclude");
                    }
                });
            }
            throw e;
        }
    }

    protected <T> T callBack(Call<T> defaultCall, Call<T> backupCall) {
        if (!this.isAvailable()) {
            return this.executeBackup(backupCall);
        }
        try {
            return defaultCall.call();
        }
        catch (KDException e) {
            ErrorCode errorCode = e.getErrorCode();
            if (errorCode == BosErrorCode.redisNotAvailable) {
                return this.executeBackup(backupCall);
            }
            throw e;
        }
    }

    protected <T> T callBackWrite(Call<T> defaultCall, Call<T> backupCall) {
        return this.callBack(defaultCall, backupCall);
    }

    private <T> T executeBackup(Call<T> backupCall) {
        try {
            ThreadTruck.put((Object)"isDtsExclude", (Object)Boolean.TRUE);
            T t = backupCall.call();
            return t;
        }
        catch (DbSessionableCacheException ex) {
            log.error("redis error: ", (Throwable)ex);
            throw ex;
        }
        finally {
            ThreadTruck.remove((Object)"isDtsExclude");
        }
    }

    static interface Invoker {
        public void invoker();
    }
}

