/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.database;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.cache.database.DbSessionableCacheException;
import kd.bos.cache.database.SessionLessExecutor;
import kd.bos.cache.database.SqlExecutor;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadTruck;

class ExpireClearService {
    private static final Log log = LogFactory.getLog(ExpireClearService.class);
    private static final ScheduledExecutorService service = Executors.newScheduledThreadPool(1, new ThreadFactory(){
        private final AtomicInteger it = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "ExpireClearService-" + this.it.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    });

    ExpireClearService() {
    }

    public static void start() {
        service.scheduleWithFixedDelay(() -> {
            try {
                ThreadTruck.put((Object)"isDtsExclude", (Object)Boolean.TRUE);
                SqlExecutor.instance.deleteExpired();
                SessionLessExecutor.instance.deleteExpired();
            }
            catch (DbSessionableCacheException e) {
                log.error("redis error: ", (Throwable)e);
            }
            finally {
                ThreadTruck.remove((Object)"isDtsExclude");
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }
}

