/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.database;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.cache.redis.AbstractRedisSessionCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ha.component.KeepAliveListener;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import org.apache.log4j.Logger;
import redis.clients.jedis.exceptions.JedisClusterOperationException;
import redis.clients.jedis.exceptions.JedisException;

public class SessionCacheKeepListener
implements KeepAliveListener {
    private static final Logger LOGGER = Logger.getLogger(SessionCacheKeepListener.class);
    private static Map<String, ErrorCode> EXCEPTIONE_RRORCODE_MAP;
    private AtomicInteger tryTimesInteger = new AtomicInteger(0);

    public boolean isAvailable() {
        boolean isAvailable;
        block23: {
            isAvailable = true;
            try (JedisClient jedisClient = RedisFactory.getJedisClient((String)this.getUrl());){
                jedisClient.type("sessionable-ha-pingpong");
            }
            catch (Exception e) {
                KDException kdException;
                Throwable throwable;
                try {
                    if (EXCEPTIONE_RRORCODE_MAP == null) {
                        Field exceptionErrorcodeField = AbstractRedisSessionCache.class.getDeclaredField("JEDISEXCEPTION_MAPPER_ERRORCODE");
                        exceptionErrorcodeField.setAccessible(true);
                        EXCEPTIONE_RRORCODE_MAP = (Map)exceptionErrorcodeField.get(null);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error((Object)"cannot not reflect AbstractRedisSessionCache.JEDISEXCEPTION_MAPPER_ERRORCODE");
                    return false;
                }
                ErrorCode errorCode = BosErrorCode.otherUnknow;
                if (e instanceof JedisException) {
                    errorCode = EXCEPTIONE_RRORCODE_MAP.get(e.getClass().getSimpleName());
                    if (errorCode == null) {
                        JedisClusterOperationException jedisClusterOperationException;
                        errorCode = BosErrorCode.jedisUnkownException;
                        if (e instanceof JedisClusterOperationException && (jedisClusterOperationException = (JedisClusterOperationException)e).getMessage().equals("Cluster retry deadline exceeded.")) {
                            errorCode = BosErrorCode.redisNotAvailable;
                        }
                    }
                } else if (e instanceof KDException && (throwable = (kdException = (KDException)((Object)e)).getCause()) instanceof JedisException && (errorCode = EXCEPTIONE_RRORCODE_MAP.get(throwable.getClass().getSimpleName())) == null) {
                    JedisClusterOperationException jedisClusterOperationException;
                    errorCode = BosErrorCode.jedisUnkownException;
                    if (throwable instanceof JedisClusterOperationException && (jedisClusterOperationException = (JedisClusterOperationException)throwable).getMessage().equals("Cluster retry deadline exceeded.")) {
                        errorCode = BosErrorCode.redisNotAvailable;
                    }
                }
                if (errorCode != BosErrorCode.redisNotAvailable) break block23;
                this.tryTimesInteger.getAndIncrement();
                int retryTimes = Integer.getInteger("ha.redis.try.times", 1);
                if (this.tryTimesInteger.get() < retryTimes) break block23;
                isAvailable = false;
            }
        }
        return isAvailable;
    }

    public void notifyOffline() {
    }

    public void notifyOnline() {
        this.tryTimesInteger.set(0);
    }

    public String getUrl() {
        String configKey = CacheConfigKeys.getSessionableConfigKey();
        return System.getProperty(configKey);
    }
}

