/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.tempfile;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.tempfile.TempFileExtension;
import kd.bos.cache.tempfile.TempFileExtensionFactory;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class BaseTempFileCache {
    private final Log logger = LogFactory.getLog(BaseTempFileCache.class);
    private static final String TEMPFILE_MAX_TIMEOUT_S = "tempfile.max.timeout";
    private static final int DEFAULT_MAX_TIMEOUT = 86400;
    private static final String TEMPFILE_MAXSIZE = "tempfile.maxsize";
    private static final int TEMPFILE_MAXSIZE_DEFAULT = 1536;
    protected static final String ID_MAP_KEY = "id";
    protected static final String CONFIG_MAP_KEY = "configKey";
    private static TempFileExtension tempFileCheck = TempFileExtensionFactory.get();

    protected String makeUrl(String configKey, String id) {
        configKey = this.encodeConfigKey(configKey);
        return String.format("tempfile/download.do?configKey=%s&id=%s", configKey, id);
    }

    protected String encodeConfigKey(String configKey) {
        return configKey;
    }

    protected String decodeConfigKey(String configKey) {
        return configKey;
    }

    protected String createId() {
        return "tempfile-" + ID.genLongId();
    }

    protected int toExpireTime(int timeout) {
        int expire = (int)TimeUnit.SECONDS.toSeconds(timeout);
        if (expire < 0) {
            String s = System.getProperty("redis.defaulttimeout");
            if (s != null) {
                try {
                    expire = Integer.parseInt(s.trim());
                }
                catch (Exception var3) {
                    this.logger.error("redis.defaulttimeout is not legal integer: " + s);
                }
            }
            expire = 3600;
        }
        return expire;
    }

    protected Map<String, String> parseUrl(String url) {
        String[] pairstr = url.split("\\?");
        String[] pairs = pairstr[1].split("&");
        HashMap<String, String> m = new HashMap<String, String>(pairs.length);
        for (String pair : pairs) {
            String[] p = pair.split("=");
            m.put(p[0], p[1]);
        }
        return m;
    }

    protected void doZip(InputStream in, ZipOutputStream out, String entryName) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        out.putNextEntry(entry);
        int len = 0;
        byte[] buffer = new byte[8192];
        BufferedInputStream fis = new BufferedInputStream(in);
        while ((len = fis.read(buffer)) > 0) {
            out.write(buffer, 0, len);
            out.flush();
        }
        out.closeEntry();
        fis.close();
    }

    protected String getRealId(String id, boolean isCheck) {
        return tempFileCheck.checkAsId(id, isCheck);
    }

    @Deprecated
    protected byte[] checkFile(byte[] bytes, String fileName) {
        this.logger.warn(tempFileCheck.getClass().toString());
        return tempFileCheck.checkFile(bytes, fileName);
    }

    protected InputStream checkFile(InputStream inputStream, String fileName) {
        return tempFileCheck.checkFile(inputStream, fileName);
    }

    protected int checkTimeout(int timeout) {
        int maxTimeout = this.getMaxTimeout();
        if (timeout <= 0 || timeout > maxTimeout) {
            this.logger.error((Throwable)new IllegalArgumentException("not allowed tempfile timeout: " + timeout + "s. Max timeout: " + maxTimeout + "s."));
            timeout = maxTimeout;
        }
        return timeout;
    }

    private int getMaxTimeout() {
        String configTimeout = System.getProperty(TEMPFILE_MAX_TIMEOUT_S);
        int timeout = 86400;
        if (StringUtils.isNotEmpty((String)configTimeout)) {
            try {
                timeout = Integer.parseInt(configTimeout);
            }
            catch (Exception e) {
                this.logger.error("Config for [tempfile.max.timeout] has a error value: " + configTimeout);
            }
        }
        return timeout;
    }

    protected void checkMaxsize(String filename, int bytelen) {
        boolean isCheck = ConfigurationUtil.getBoolean((String)"redis.tempfile.checkmax.enable", (Boolean)true);
        int maxM = ConfigurationUtil.getInteger((String)TEMPFILE_MAXSIZE, (Integer)1536);
        int maxlen = 0;
        maxlen = maxM >= 2048 ? 0x7FFFFFF7 : maxM * 1024 * 1024;
        if (isCheck && bytelen > maxlen) {
            throw new KDException(BosErrorCode.uploadFailed, new Object[]{"The Redis mode of TempfileCache supports max size is " + maxM + "M, please configure 'tempfile.cachetype=disk' in MC."});
        }
    }
}

