/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.tempfile;

import com.google.common.base.Charsets;
import com.google.common.io.ByteSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.TempFileCacheType;
import kd.bos.cache.TempFileOutput;
import kd.bos.cache.tempfile.BaseTempFileCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.cache.tempfile.extesion.TempFileCacheExtHandlerFactory;
import kd.bos.context.RequestContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.DiskCacheUtils;
import kd.bos.util.resource.Resources;
import org.apache.tools.zip.ZipOutputStream;

public class DiskTempFileCache
extends BaseTempFileCache
implements TempFileCache,
TempFileCacheDownloadable {
    private static final String CONFIG_KEY = "tempfile.disk";
    private static final String SUFFIX_FILE_NAME = ".filename";
    private static final String PREFIX_URL = "url: ";
    private final Log logger = LogFactory.getLog(DiskTempFileCache.class);

    public String saveAsUrl(String filename, InputStream in, int timeout) {
        timeout = this.checkTimeout(timeout);
        in = this.checkFile(in, filename);
        String id = this.createId();
        TempFileCacheExtHandlerFactory.createHandler().beforeSave(filename, id);
        String fileNameKey = id + SUFFIX_FILE_NAME;
        try {
            DiskCacheUtils.cacheData((String)id, (InputStream)in);
            DiskCacheUtils.cacheData((String)fileNameKey, (InputStream)new ByteArrayInputStream(filename.getBytes(Charsets.UTF_8)));
            DiskCacheUtils.setTimeout((String)id, (int)timeout);
            DiskCacheUtils.setTimeout((String)fileNameKey, (int)timeout);
            return this.makeUrl(CONFIG_KEY, id);
        }
        catch (Exception e) {
            DiskCacheUtils.remove((String)id);
            DiskCacheUtils.remove((String)fileNameKey);
            throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[0]);
        }
    }

    public String saveAsUrl(String filename, byte[] bytes, int timeout) {
        InputStream in;
        try {
            in = ByteSource.wrap((byte[])bytes).openBufferedStream();
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[0]);
        }
        return this.saveAsUrl(filename, in, timeout);
    }

    public Map<String, String> save(String filename, InputStream in, int timeout) {
        timeout = this.checkTimeout(timeout);
        String id = this.createId();
        TempFileCacheExtHandlerFactory.createHandler().beforeSave(filename, id);
        String fileNameKey = id + SUFFIX_FILE_NAME;
        try {
            DiskCacheUtils.cacheData((String)id, (InputStream)in);
            DiskCacheUtils.cacheData((String)fileNameKey, (InputStream)new ByteArrayInputStream(filename.getBytes(Charsets.UTF_8)));
            DiskCacheUtils.setTimeout((String)id, (int)timeout);
            DiskCacheUtils.setTimeout((String)fileNameKey, (int)timeout);
            HashMap<String, String> items = new HashMap<String, String>();
            items.put("configKey", CONFIG_KEY);
            items.put("id", id);
            return items;
        }
        catch (Exception e) {
            DiskCacheUtils.remove((String)id);
            DiskCacheUtils.remove((String)fileNameKey);
            throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[0]);
        }
    }

    public Map<String, String> save(String filename, byte[] bytes, int timeout) {
        timeout = this.checkTimeout(timeout);
        InputStream in = null;
        try {
            in = ByteSource.wrap((byte[])bytes).openBufferedStream();
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[0]);
        }
        return this.save(filename, in, timeout);
    }

    public InputStream getInputStream(String url) {
        try {
            Map<String, String> m = this.parseUrl(url);
            String id = m.get("id");
            String configKey = m.get("configKey");
            configKey = this.decodeConfigKey(configKey);
            return this.get(configKey, id).getInputStream();
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.downloadFailed, PREFIX_URL + url, (Throwable)e);
        }
    }

    public boolean exists(String url) {
        try {
            Map<String, String> m = this.parseUrl(url);
            String id = m.get("id");
            return DiskCacheUtils.exists((String)id);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.downloadFailed, PREFIX_URL + url, (Throwable)e);
        }
    }

    public String saveAsFullUrl(String filename, InputStream in, int timeout) {
        String url = this.saveAsUrl(filename, in, timeout);
        return this.getUrlPrefix() + url;
    }

    public String saveAsFullUrl(String filename, byte[] bytes, int timeout) {
        String url = this.saveAsUrl(filename, bytes, timeout);
        return this.getUrlPrefix() + url;
    }

    public void remove(String url) {
        try {
            Map<String, String> m = this.parseUrl(url);
            String id = m.get("id");
            String configKey = m.get("configKey");
            configKey = this.decodeConfigKey(configKey);
            this.delete(configKey, id);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.deleteFailed, PREFIX_URL + url, (Throwable)e);
        }
    }

    public TempFileCacheDownloadable.Content download(HttpServletRequest request) {
        String id = request.getParameter("id");
        String configKey = request.getParameter("configKey");
        configKey = this.decodeConfigKey(configKey);
        return this.get(configKey, id, true);
    }

    public TempFileCacheDownloadable.Content download(Map<String, String> params) {
        String id = params.get("id");
        String configKey = params.get("configKey");
        configKey = this.decodeConfigKey(configKey);
        return this.get(configKey, id, true);
    }

    public TempFileCacheDownloadable.Content get(String configKey, String id) {
        return this.get(configKey, id, false);
    }

    public TempFileCacheDownloadable.Content get(String configKey, String id, boolean isCheck) {
        id = this.getRealId(id, isCheck);
        String fileNameKey = id + SUFFIX_FILE_NAME;
        try {
            InputStream in = DiskCacheUtils.getData((String)id);
            String filename = this.inputStreamToString(DiskCacheUtils.getData((String)fileNameKey));
            if (in == null) {
                return null;
            }
            return new TempFileCacheDownloadable.Content(in.available(), in, filename);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.downloadFailed, "get key:" + id + ", configKey:" + configKey, (Throwable)e);
        }
    }

    private void delete(String configKey, String id) {
        try {
            String fileNameKey = id + SUFFIX_FILE_NAME;
            DiskCacheUtils.remove((String)id);
            DiskCacheUtils.remove((String)fileNameKey);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.deleteFailed, "delete key:" + id + ", configKey:" + configKey, (Throwable)e);
        }
    }

    private String getUrlPrefix() {
        RequestContext rc = RequestContext.get();
        if (rc == null || rc.getClientFullContextPath() == null) {
            throw new KDException(BosErrorCode.storageFileSaveFailed, new Object[]{"Can't saveAsFullUrl() in not web request, use saveAsUrl() instead."});
        }
        return rc.getClientFullContextPath();
    }

    private String inputStreamToString(InputStream in) {
        if (in == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byt = new byte[4096];
        try {
            int i;
            while ((i = in.read(byt)) != -1) {
                stringBuilder.append(new String(byt, 0, i));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(Resources.getString((String)"InputStream\u8f6c\u6362\u4e3aString\u9519\u8bef", (String)"DiskTempFileCache_0", (String)"bos-framework", (Object[])new Object[0]), e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                this.logger.error((Throwable)e);
            }
        }
        return stringBuilder.toString();
    }

    public String compress(String zipName, String[] urls, int timeout) {
        timeout = this.checkTimeout(timeout);
        String id = this.createId();
        String fileNameKey = id + SUFFIX_FILE_NAME;
        try (ZipOutputStream out = new ZipOutputStream(DiskCacheUtils.cacheOutputStream((String)id));){
            for (String url : urls) {
                Map<String, String> m = this.parseUrl(url);
                String urlId = m.get("id");
                String urlConfigKey = m.get("configKey");
                TempFileCacheDownloadable.Content content = this.get(urlConfigKey, urlId);
                try (InputStream in = content.getInputStream();){
                    this.doZip(in, out, content.getFilename());
                }
            }
            DiskCacheUtils.cacheData((String)fileNameKey, (InputStream)new ByteArrayInputStream(zipName.getBytes(Charsets.UTF_8)));
            DiskCacheUtils.setTimeout((String)id, (int)timeout);
            DiskCacheUtils.setTimeout((String)fileNameKey, (int)timeout);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[0]);
        }
        return this.makeUrl(CONFIG_KEY, id);
    }

    @Deprecated
    public String filesZip(String zipName, String[] urls, int timeout) {
        return this.compress(zipName, urls, timeout);
    }

    public TempFileOutput newOutput(String filename, int timeout) {
        timeout = this.checkTimeout(timeout);
        return new DiskTempFileOutput(filename, timeout);
    }

    public String type() {
        return TempFileCacheType.DISK.getName();
    }

    class DiskTempFileOutput
    implements TempFileOutput {
        private String id;
        private OutputStream out;
        private String filename;
        private int timeout;

        public DiskTempFileOutput(String filename, int timeout) {
            this.id = DiskTempFileCache.this.createId();
            this.filename = filename;
            this.out = DiskCacheUtils.cacheOutputStream((String)this.id);
            this.timeout = timeout;
        }

        @Deprecated
        public String flush() {
            return this.saveAsUrl();
        }

        public void write(byte[] bytes) {
            try {
                this.out.write(bytes);
            }
            catch (IOException e) {
                try {
                    this.out.close();
                }
                catch (IOException e1) {
                    DiskTempFileCache.this.logger.error((Throwable)e);
                }
                throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[0]);
            }
        }

        @Deprecated
        public void write(byte[] bytes, int off, int len) {
            try {
                this.out.write(bytes, off, len);
            }
            catch (IOException e) {
                try {
                    this.out.close();
                }
                catch (IOException e1) {
                    DiskTempFileCache.this.logger.error((Throwable)e);
                }
                throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[0]);
            }
        }

        public String saveAsUrl() {
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    DiskTempFileCache.this.logger.error((Throwable)e);
                }
            }
            TempFileCacheExtHandlerFactory.createHandler().beforeSave(this.filename, this.id);
            String fileNameKey = this.id + DiskTempFileCache.SUFFIX_FILE_NAME;
            DiskCacheUtils.cacheData((String)fileNameKey, (InputStream)new ByteArrayInputStream(this.filename.getBytes()));
            DiskCacheUtils.setTimeout((String)this.id, (int)this.timeout);
            DiskCacheUtils.setTimeout((String)fileNameKey, (int)this.timeout);
            return DiskTempFileCache.this.makeUrl(DiskTempFileCache.CONFIG_KEY, this.id);
        }
    }
}

