/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.tempfile;

import com.google.common.io.ByteSource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.TempFileCacheType;
import kd.bos.cache.TempFileOutput;
import kd.bos.cache.tempfile.BaseTempFileCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.cache.tempfile.TempFileInputStream;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.config.FileServiceConfig;
import kd.bos.fileservice.config.FileServiceTenantConfig;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.FileUtils;
import kd.bos.util.SystemProperties;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipOutputStream;

public class MockTempFileCache
extends BaseTempFileCache
implements TempFileCache,
TempFileCacheDownloadable {
    private static final Log LOGGER = LogFactory.getLog(MockTempFileCache.class);
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String PREFIX_URL = "url: ";
    private static final String ZIP_TEMP_DIR = SystemProperties.get((String)"java.io.tmpdir") + "/ierpupload";
    private final FileService fileService = FileServiceFactory.getAttachmentFileService();
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));

    public String saveAsUrl(String filename, InputStream in, int timeout) {
        throw new UnsupportedOperationException();
    }

    public String saveAsUrl(String filename, byte[] bytes, int timeout) {
        throw new UnsupportedOperationException();
    }

    public String saveAsFullUrl(String filename, InputStream in, int timeout) {
        throw new UnsupportedOperationException();
    }

    public String saveAsFullUrl(String filename, byte[] bytes, int timeout) {
        throw new UnsupportedOperationException();
    }

    public Map<String, String> save(String filename, InputStream in, int timeout) {
        throw new UnsupportedOperationException();
    }

    public Map<String, String> save(String filename, byte[] bytes, int timeout) {
        throw new UnsupportedOperationException();
    }

    public InputStream getInputStream(String url) {
        try {
            Map<String, String> m = this.parseUrl(url);
            String id = m.get("id");
            String configKey = m.get("configKey");
            configKey = this.decodeConfigKey(configKey);
            return this.get(configKey, id).getInputStream();
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.downloadFailed, PREFIX_URL + url, (Throwable)e);
        }
    }

    public boolean exists(String url) {
        try {
            Map<String, String> m = this.parseUrl(url);
            String id = m.get("id");
            return cache.contains(id);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.fileIsExistFailed, PREFIX_URL + url, (Throwable)e);
        }
    }

    public void remove(String url) {
        try {
            Map<String, String> m = this.parseUrl(url);
            String id = m.get("id");
            cache.remove(id);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.deleteFailed, PREFIX_URL + url, (Throwable)e);
        }
    }

    public TempFileOutput newOutput(String filename, int timeout) {
        return new MockTempFileOutput(filename, timeout);
    }

    @Deprecated
    public String filesZip(String zipName, String[] urls, int timeout) {
        return this.compress(zipName, urls, timeout);
    }

    public String compress(String zipName, String[] urls, int timeout) {
        String zipFilePath = this.getZipFilePath(null);
        zipFilePath = FileUtils.checkFileUrl((String)zipFilePath);
        this.filesZipToTempdir(urls, zipFilePath);
        return this.saveAndDelZipFile(zipName, timeout, zipFilePath);
    }

    private String getZipFilePath(String fileName) {
        Path tempDir = Paths.get(ZIP_TEMP_DIR, new String[0]);
        if (!tempDir.toFile().exists()) {
            try {
                Files.createDirectories(tempDir, new FileAttribute[0]);
            }
            catch (Exception ex) {
                throw new KDException((Throwable)ex, BosErrorCode.createDirectoryFailed, new Object[]{"can't create directory, path:'" + ZIP_TEMP_DIR + "'"});
            }
        }
        if (fileName != null) {
            return ZIP_TEMP_DIR + "/" + fileName;
        }
        String id = this.createId();
        return ZIP_TEMP_DIR + "/" + id + ".zip";
    }

    private void filesZipToTempdir(String[] urls, String zipFilePath) {
        File zipFile = new File(FileUtils.checkFileUrl((String)zipFilePath));
        try (OutputStream out = Files.newOutputStream(zipFile.toPath(), new OpenOption[0]);
             ZipOutputStream zos = new ZipOutputStream(out);){
            for (String url : urls) {
                Map<String, String> m = this.parseUrl(url);
                String urlId = m.get("id");
                String urlConfigKey = m.get("configKey");
                TempFileCacheDownloadable.Content content = this.get(urlConfigKey, urlId);
                try (InputStream in = content.getInputStream();){
                    this.doZip(in, zos, content.getFilename());
                }
            }
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[]{"filesZipToTempdir failed."});
        }
    }

    /*
     * Exception decompiling
     */
    private String saveAndDelZipFile(String zipName, int timeout, String zipFileUrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public TempFileCacheDownloadable.Content download(HttpServletRequest request) {
        String id = request.getParameter("id");
        String configKey = request.getParameter("configKey");
        configKey = this.decodeConfigKey(configKey);
        return this.get(configKey, id);
    }

    public TempFileCacheDownloadable.Content download(Map<String, String> params) {
        String id = params.get("id");
        String configKey = params.get("configKey");
        configKey = this.decodeConfigKey(configKey);
        return this.get(configKey, id);
    }

    public TempFileCacheDownloadable.Content get(String configKey, String id) {
        String path = (String)cache.get(id);
        if (path == null) {
            return null;
        }
        try {
            int fileSize;
            if (!this.fileService.exists(path)) {
                return null;
            }
            String realPath = this.fileService.getFileServiceExt().getRealPath(path);
            String fileName = realPath.substring(realPath.lastIndexOf("/") + 1);
            InputStream inputStream = this.fileService.getInputStream(path);
            try {
                Long sizeFromFileServer;
                if (FileServiceExtFactory.hasAttachFileServiceExt() || FileServiceConfig.FILE_SECURITY_DECRYPT_ENABLE.getBoolean() || FileServiceTenantConfig.FILE_SECURITY_ENCRYPT_ENABLE.getBooleanTenant() || !FileServiceFactory.isDefaultAttachmentFileStorageClass()) {
                    final String localTempPath = FileUtils.checkFileUrl((String)(TEMP_DIR + "/MOCK-" + UUID.randomUUID().toString().replace("-", "")));
                    try (OutputStream out = Files.newOutputStream(Paths.get(localTempPath, new String[0]), new OpenOption[0]);
                         InputStream in = inputStream;){
                        sizeFromFileServer = IOUtils.copyLarge((InputStream)in, (OutputStream)out);
                    }
                    inputStream = new FilterInputStream(Files.newInputStream(Paths.get(localTempPath, new String[0]), new OpenOption[0])){
                        private boolean closed;
                        {
                            super(x0);
                            this.closed = false;
                        }

                        @Override
                        public void close() throws IOException {
                            if (!this.closed) {
                                this.closed = true;
                                try {
                                    super.close();
                                }
                                finally {
                                    Files.deleteIfExists(Paths.get(localTempPath, new String[0]));
                                }
                            }
                        }
                    };
                } else {
                    sizeFromFileServer = this.fileService.getFileSize(path);
                }
                fileSize = sizeFromFileServer > Integer.MAX_VALUE ? Integer.MAX_VALUE : sizeFromFileServer.intValue();
            }
            catch (Exception e) {
                LOGGER.error("get FileSize from fileServer failed", (Throwable)e);
                fileSize = inputStream.available();
            }
            return new TempFileCacheDownloadable.Content(fileSize, (InputStream)new TempFileInputStream(inputStream, fileSize), fileName);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.downloadFailed, PREFIX_URL + path, (Throwable)e);
        }
    }

    public String type() {
        return TempFileCacheType.MOCK.getName();
    }

    class MockTempFileOutput
    implements TempFileOutput {
        private ByteArrayOutputStream out = new ByteArrayOutputStream();
        private String filename;
        private int timeout;
        private int bytelen = 0;

        public MockTempFileOutput(String filename, int timeout) {
            timeout = MockTempFileCache.this.checkTimeout(timeout);
            this.filename = filename;
            this.timeout = timeout;
        }

        @Deprecated
        public String flush() {
            return this.saveAsUrl();
        }

        public void write(byte[] bytes) {
            try {
                this.bytelen += bytes.length;
                MockTempFileCache.this.checkMaxsize(this.filename, this.bytelen);
                this.out.write(bytes);
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[]{"save tempfile by mock upload failed."});
            }
            finally {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    LOGGER.error((Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public void write(byte[] bytes, int off, int len) {
            try {
                this.bytelen += bytes.length;
                MockTempFileCache.this.checkMaxsize(this.filename, this.bytelen);
                this.out.write(bytes, off, len);
            }
            finally {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    LOGGER.error((Throwable)e);
                }
            }
        }

        public String saveAsUrl() {
            try {
                InputStream in = ByteSource.wrap((byte[])this.out.toByteArray()).openBufferedStream();
                return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(this.filename, in, this.timeout);
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[]{"save tempfile by mock upload failed."});
            }
        }
    }
}

