/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.tempfile;

import java.io.IOException;
import java.io.InputStream;

public class TempFileInputStream
extends InputStream {
    private int readSize;
    private final int totalSize;
    private byte[] buf;
    private int pos = 0;
    private final InputStream wrappedStream;

    public TempFileInputStream(InputStream in, int totalSize) {
        this.wrappedStream = in;
        this.totalSize = totalSize;
    }

    private synchronized int preRead() throws IOException {
        int read;
        int preLen = 0xA00000;
        byte[] preBuf = new byte[preLen];
        int prePos = 0;
        int len = 8192;
        byte[] readBuf = new byte[len];
        while (preLen > 0 && (read = this.wrappedStream.read(readBuf, 0, len = Math.min(len, preLen))) != -1) {
            System.arraycopy(readBuf, 0, preBuf, prePos, read);
            preLen -= read;
            prePos += read;
        }
        this.buf = new byte[prePos];
        this.pos = 0;
        System.arraycopy(preBuf, 0, this.buf, 0, prePos);
        return prePos;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.readSize >= this.totalSize) {
            return -1;
        }
        if ((this.buf == null || this.pos >= this.buf.length) && this.preRead() == 0) {
            return -1;
        }
        ++this.readSize;
        return this.buf[this.pos++] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int read;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.readSize >= this.totalSize) {
            return -1;
        }
        for (int need = len = Math.min(this.totalSize - this.readSize, len); need > 0; need -= read) {
            if ((this.buf == null || this.pos >= this.buf.length) && this.preRead() == 0) {
                return len - need == 0 ? -1 : len - need;
            }
            read = Math.min(this.buf.length - this.pos, need);
            System.arraycopy(this.buf, this.pos, b, off, read);
            this.pos += read;
            this.readSize += read;
            off += read;
        }
        return len;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if ((n = Math.min((long)(this.totalSize - this.readSize), n)) < 0L) {
            return 0L;
        }
        int need = (int)n;
        while (need > 0) {
            if ((this.buf == null || this.pos >= this.buf.length) && this.preRead() == 0) {
                return n - (long)need;
            }
            int skip = Math.min(this.buf.length - this.pos, need);
            need -= skip;
            this.pos += skip;
            this.readSize += skip;
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        if (this.wrappedStream != null) {
            this.wrappedStream.close();
        }
    }

    @Override
    public synchronized int available() throws IOException {
        return this.totalSize - this.readSize;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

