/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.gray;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import kd.bos.framework.gray.LongIdSet;
import kd.bos.framework.gray.RoaringUtils;
import org.roaringbitmap.longlong.LongIterator;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public class RoaringLongIdSet
implements LongIdSet {
    private Roaring64NavigableMap map;

    protected RoaringLongIdSet() {
        this.map = new Roaring64NavigableMap();
    }

    protected RoaringLongIdSet(Roaring64NavigableMap map) {
        this.map = map;
    }

    @Override
    public Set<Long> getAll() {
        HashSet<Long> set = new HashSet<Long>(2);
        LongIterator li = this.map.getLongIterator();
        while (li.hasNext()) {
            set.add(li.next());
        }
        return set;
    }

    @Override
    public void add(long user) {
        this.map.addLong(user);
    }

    @Override
    public long count() {
        return this.map.getLongCardinality();
    }

    @Override
    public String toSeriablizeString() throws IOException {
        return RoaringUtils.seriablize(this.map);
    }

    @Override
    public boolean exist(long user) {
        return this.map.contains(user);
    }
}

