/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.gray;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public class RoaringUtils {
    public static String seriablize(Roaring64NavigableMap map) throws IOException {
        map.runOptimize();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        map.serialize((DataOutput)new DataOutputStream(baos));
        byte[] out = baos.toByteArray();
        byte[] gzipout = RoaringUtils.gzipCompress(out);
        if (gzipout == null) {
            return null;
        }
        String hexStr = RoaringUtils.toHex(gzipout);
        return hexStr;
    }

    public static Roaring64NavigableMap deseriablize(String inputStr) throws IOException {
        byte[] input = RoaringUtils.fromHex(inputStr);
        Roaring64NavigableMap map = new Roaring64NavigableMap();
        map.deserialize((DataInput)new DataInputStream(new ByteArrayInputStream(RoaringUtils.gzipUncompress(input))));
        return map;
    }

    public static byte[] gzipCompress(byte[] source) throws IOException {
        if (source == null || source.length == 0) {
            return source;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream gout = new GZIPOutputStream(bos);
        gout.write(source);
        gout.close();
        bos.close();
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gzipUncompress(byte[] source) throws IOException {
        if (source == null || source.length == 0) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(source);
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPInputStream gin = null;){
            int n;
            gin = new GZIPInputStream(bais);
            while ((n = gin.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
            out.close();
            ((InputStream)bais).close();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    private static byte[] fromHex(String hex) {
        byte[] binary = new byte[hex.length() / 2];
        for (int i = 0; i < binary.length; ++i) {
            binary[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return binary;
    }

    private static String toHex(byte[] array) {
        BigInteger bi = new BigInteger(1, array);
        String hex = bi.toString(16);
        int paddingLength = array.length * 2 - hex.length();
        if (paddingLength > 0) {
            return String.format("%0" + paddingLength + "d", 0) + hex;
        }
        return hex;
    }
}

