/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.lifecycle;

import java.util.ArrayList;
import kd.bos.framework.lifecycle.Service;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.util.WebPortUtil;

public class PreHeatService
implements Service {
    private static String[] webPreHeatServiceClasses = null;
    private static String[] msPreHeatServiceClasses = null;
    private static Log log = LogFactory.getLog(PreHeatService.class);
    private boolean fIsStarted = false;

    @Override
    public String getName() {
        return "PreHeatService";
    }

    @Override
    public void start() {
        boolean isWeb = WebPortUtil.isWebNode();
        ArrayList<Service> preService = Instance.isWebMserviceInOne() ? PreHeatService.getServiceList(msPreHeatServiceClasses) : (isWeb ? PreHeatService.getServiceList(webPreHeatServiceClasses) : PreHeatService.getServiceList(msPreHeatServiceClasses));
        if (preService != null) {
            preService.forEach(ps -> ThreadPools.executeOnce("Preheat-" + ps.getName(), () -> ps.start()));
        }
        this.fIsStarted = true;
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isStarted() {
        return this.fIsStarted;
    }

    private static ArrayList<Service> getServiceList(String[] serviceClasses) {
        ArrayList<Service> list = new ArrayList<Service>();
        for (int i = 0; i < serviceClasses.length; ++i) {
            Service s = PreHeatService.createByClass(serviceClasses[i]);
            if (s == null) continue;
            list.add(s);
        }
        return list;
    }

    private static Service createByClass(String className) {
        try {
            return (Service)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.error("Can't create preheat service by " + className, (Throwable)e);
            return null;
        }
    }

    static {
        webPreHeatServiceClasses = new String[0];
        msPreHeatServiceClasses = new String[]{"kd.bos.framework.lifecycle.services.StartupPKTempTableClearService", "kd.bos.framework.preheat.DataSourcePreheatService", "kd.bos.framework.preheat.PKTempTablePreheatService", "kd.bos.mvc.MVCService", "kd.bos.framework.preheat.FullTextPreheatService", "kd.bos.flydb.starter.FlyDBService", "kd.bos.algox.service.AlgoXService", "kd.bos.mservice.preheat.DataPreHeatService", "kd.bos.license.service.LicensePreheatService"};
    }
}

