/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.lifecycle;

import java.util.ArrayList;
import kd.bos.framework.lifecycle.Service;

class ServiceItem {
    private String name;
    private String className;
    private String[] depends;
    private Service instance;
    private ArrayList<ServiceItem> children = new ArrayList();
    private ArrayList<ServiceItem> parents = new ArrayList();
    private boolean disable;
    private boolean started;
    private boolean ended;

    public ServiceItem(String name, String value) {
        this.name = name;
        String[] parts = value.split(";");
        this.className = parts[0];
        if (parts.length > 1) {
            this.depends = parts[1].split(",");
            for (int i = 0; i < this.depends.length; ++i) {
                this.depends[i] = this.depends[i].trim();
            }
        }
    }

    public boolean isAllInputFinished() {
        if (this.parents == null) {
            return true;
        }
        for (ServiceItem item : this.parents) {
            if (item.started) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    public Service getInstance() {
        return this.instance;
    }

    public void setInstance(Service instance) {
        this.instance = instance;
    }

    public ArrayList<ServiceItem> getChildren() {
        return this.children;
    }

    public void setChildren(ArrayList<ServiceItem> children) {
        this.children = children;
    }

    public ArrayList<ServiceItem> getParents() {
        return this.parents;
    }

    public void setParents(ArrayList<ServiceItem> parents) {
        this.parents = parents;
    }

    public boolean isDisable() {
        return this.disable;
    }

    public void setDisable(boolean disable) {
        this.disable = disable;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public boolean isEnded() {
        return this.ended;
    }

    public void setEnded(boolean ended) {
        this.ended = ended;
    }

    public String toString() {
        return this.name + "@" + this.className;
    }
}

