/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.lifecycle;

import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.extension.ExtensionFactory;
import kd.bos.framework.lifecycle.Service;
import kd.bos.framework.lifecycle.ServiceItem;
import kd.bos.framework.lifecycle.SysServiceLayer;
import kd.bos.util.SafeLogUtils;

public class SysServiceLayerManager {
    public static final String[] LEVEL = new String[]{"microKernelLayer", System.getProperty("application.layer.name", "cosmicLayer")};
    private static ExtensionFactory<SysServiceLayer> lookupFactory = ExtensionFactory.getExtensionFacotry(SysServiceLayer.class);

    public static Service[] loadService() {
        ArrayList<Service> services = new ArrayList<Service>(2);
        for (int i = 0; i < LEVEL.length; ++i) {
            try {
                if (!lookupFactory.existsExtension(LEVEL[i])) continue;
                services.addAll(Arrays.asList(((SysServiceLayer)lookupFactory.getExtension(LEVEL[i])).loadService()));
                continue;
            }
            catch (Exception e) {
                SafeLogUtils.info(SysServiceLayer.class, (String)(LEVEL[i] + " not load service"), (Throwable)e);
            }
        }
        return services.toArray(new Service[services.size()]);
    }

    public static ServiceItem[] loadServiceItem() {
        ArrayList<ServiceItem> services = new ArrayList<ServiceItem>(2);
        for (int i = 0; i < LEVEL.length; ++i) {
            try {
                ServiceItem[] items;
                if (!lookupFactory.existsExtension(LEVEL[i]) || (items = ((SysServiceLayer)lookupFactory.getExtension(LEVEL[i])).loadServiceItem()) == null) continue;
                services.addAll(Arrays.asList(items));
                continue;
            }
            catch (Exception e) {
                SafeLogUtils.info(SysServiceLayer.class, (String)(LEVEL[i] + " not load service"), (Throwable)e);
            }
        }
        return services.toArray(new ServiceItem[services.size()]);
    }

    public static String getWebReousrceXmlPath() {
        for (int i = LEVEL.length - 1; i >= 0; --i) {
            try {
                if (!lookupFactory.existsExtension(LEVEL[i])) continue;
                return ((SysServiceLayer)lookupFactory.getExtension(LEVEL[i])).getWebReousrceXmlPath();
            }
            catch (Exception e) {
                SafeLogUtils.info(SysServiceLayer.class, (String)(LEVEL[i] + " not load service"), (Throwable)e);
            }
        }
        return null;
    }

    public static boolean isRegisterDefaultInterface() {
        for (int i = LEVEL.length - 1; i >= 0; --i) {
            try {
                if (!lookupFactory.existsExtension(LEVEL[i])) continue;
                return ((SysServiceLayer)lookupFactory.getExtension(LEVEL[i])).isRegisterDefaultInterface();
            }
            catch (Exception e) {
                SafeLogUtils.info(SysServiceLayer.class, (String)(LEVEL[i] + " not load service"), (Throwable)e);
            }
        }
        return false;
    }

    public static boolean isNeedDebugModel() {
        for (int i = LEVEL.length - 1; i >= 0; --i) {
            try {
                if (!lookupFactory.existsExtension(LEVEL[i])) continue;
                return ((SysServiceLayer)lookupFactory.getExtension(LEVEL[i])).isNeedDebugModel();
            }
            catch (Exception e) {
                SafeLogUtils.info(SysServiceLayer.class, (String)(LEVEL[i] + " not load service"), (Throwable)e);
            }
        }
        return false;
    }

    public static boolean isMicroKernel() {
        for (int i = LEVEL.length - 1; i >= 0; --i) {
            try {
                if (!lookupFactory.existsExtension(LEVEL[i])) continue;
                return ((SysServiceLayer)lookupFactory.getExtension(LEVEL[i])).isMicroKernel();
            }
            catch (Exception e) {
                SafeLogUtils.info(SysServiceLayer.class, (String)(LEVEL[i] + " not load service"), (Throwable)e);
            }
        }
        return true;
    }

    public static String getConfigureClassName() {
        for (int i = LEVEL.length - 1; i >= 0; --i) {
            try {
                if (!lookupFactory.existsExtension(LEVEL[i])) continue;
                return ((SysServiceLayer)lookupFactory.getExtension(LEVEL[i])).getConfigureClassName();
            }
            catch (Exception e) {
                SafeLogUtils.info(SysServiceLayer.class, (String)(LEVEL[i] + " not load service"), (Throwable)e);
            }
        }
        return "kd.bos.config.client.impl.ConfigurationFactoryNew";
    }
}

