/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.lifecycle.dlock;

import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.elect.ElectFactory;
import kd.bos.elect.Elector;
import kd.bos.elect.ElectorListener;
import kd.bos.framework.lifecycle.Service;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DLockCleanService
implements Service {
    private static final Log logger = LogFactory.getLog(DLockCleanService.class);
    private AtomicBoolean started = new AtomicBoolean();
    private Thread dLockCleanThread;

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void start() {
        Elector elector = ElectFactory.getElector((String)"DLock.clean_elector");
        elector.registerListener(new ElectorListener(){

            public void notifyLostMaster() {
                logger.info("DLock.clean_elector notifyLostMaster start.");
                DLockCleanService.this.stop();
                logger.info("DLock.clean_elector notifyLostMaster end.");
            }

            public void notifyMaster() {
                try {
                    logger.info("DLock.clean_elector notifyMaster start.");
                    DLockCleanService.this.dLockCleanThread = (Thread)Class.forName("kd.bos.dlock.service.DLockCleanThread").getConstructor(String.class).newInstance("DLockCleanThread");
                    DLockCleanService.this.dLockCleanThread.setDaemon(true);
                    DLockCleanService.this.dLockCleanThread.start();
                    DLockCleanService.this.started.set(true);
                    logger.info("DLock.clean_elector notifyMaster end.");
                }
                catch (Exception e) {
                    throw new RuntimeException("DLockCleanService start failed: " + e.getMessage(), e);
                }
            }
        });
        elector.start();
    }

    @Override
    public void stop() {
        if (this.dLockCleanThread != null) {
            this.dLockCleanThread.interrupt();
        }
        this.started.set(false);
    }

    @Override
    public boolean isStarted() {
        return this.started.get();
    }
}

