/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.lifecycle.services;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import kd.bos.cache.redis.RedisSessionableCache;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.elect.ElectFactory;
import kd.bos.elect.Elector;
import kd.bos.elect.ElectorListener;
import kd.bos.framework.lifecycle.Service;
import kd.bos.framework.lifecycle.services.sessionmanager.SessionManagerListener;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.thread.ThreadLocalUtils;
import kd.bos.trace.util.TraceIdUtil;

public class SessionManagerService
implements Service {
    private boolean mIsStarted = false;
    private RedisSessionableCache cache;
    private long sleeptimes = 1000000000L;
    private static final String SESSIONM_MANAGER_SLEEP_SECONDS = "sessionmanager.sleepsecond";
    private static final String SESSION_ACCOUNT_SPLITSTR = "@@@";
    private static Log log = LogFactory.getLog(SessionManagerService.class);

    @Override
    public String getName() {
        return "SessionIdManager";
    }

    @Override
    public void start() {
        if (Instance.isLightWeightDeploy()) {
            this.cache = new RedisSessionableCache();
        }
        this.mIsStarted = true;
        final AtomicBoolean isChoose = new AtomicBoolean(false);
        Elector elector = ElectFactory.getElector((String)"SessionManagerService_elector");
        elector.registerListener(new ElectorListener(){

            public void notifyLostMaster() {
                isChoose.set(false);
            }

            public void notifyMaster() {
                isChoose.set(true);
            }
        });
        elector.start();
        isChoose.set(elector.isMaster());
        new Thread(() -> {
            while (this.mIsStarted) {
                if (!isChoose.get()) {
                    LockSupport.parkNanos(1000000000L);
                    continue;
                }
                try {
                    ThreadLifeCycleManager.start();
                    if (Instance.isLightWeightDeploy()) {
                        Map sessionIds = this.cache.getPartSessionIdsWithAccountId();
                        sessionIds.forEach((sessionId, sessionaccountid) -> {
                            if (!this.cache.existsSession(sessionId)) {
                                this.doWithSessionId((String)sessionId, (String)sessionaccountid);
                            }
                        });
                    } else {
                        for (int loop = 0; loop < 16; ++loop) {
                            try {
                                String[] sessionids;
                                this.cache = new RedisSessionableCache();
                                Map sessions = this.cache.getPartSessionIdsWithAccountId();
                                this.cache.pipelinedMode();
                                for (String sessionId2 : sessionids = sessions.keySet().toArray(new String[0])) {
                                    this.cache.existsSession(sessionId2);
                                }
                                List existsls = this.cache.syncAndReturn();
                                for (int i = 0; i < sessionids.length; ++i) {
                                    if (!Boolean.FALSE.equals(existsls.get(i))) continue;
                                    String sessionId3 = sessionids[i];
                                    this.doWithSessionId(sessionId3, (String)sessions.get(sessionId3));
                                }
                                continue;
                            }
                            catch (Exception e) {
                                log.warn((Throwable)e);
                                continue;
                            }
                            finally {
                                if (this.cache != null) {
                                    this.cache.syncAndClose();
                                }
                                LockSupport.parkNanos(100000000L);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.warn((Throwable)e);
                }
                finally {
                    ThreadLocalUtils.clearCurrentThreadLocals();
                }
                LockSupport.parkNanos((long)Integer.getInteger(SESSIONM_MANAGER_SLEEP_SECONDS, 120).intValue() * this.sleeptimes);
            }
        }, "SessionIdRecyleManager").start();
    }

    private void doWithSessionId(String sessionId, String sessionaccountid) {
        RequestContext rc = RequestContextCreator.createOnlySession(sessionId);
        String[] ids = sessionaccountid.split(SESSION_ACCOUNT_SPLITSTR);
        if (ids.length == 2) {
            rc.setTenantId(ids[0]);
            rc.setAccountId(ids[1]);
        } else {
            rc.setAccountId(sessionaccountid);
        }
        rc.setTraceId(TraceIdUtil.createTraceIdString());
        if (log.isDebugEnabled()) {
            log.debug("session has time out with tenant&account: " + sessionaccountid);
        }
        this.cache.removeSessionId(new String[]{sessionId});
        SessionManagerListener.destory(sessionId);
    }

    @Override
    public void stop() {
        this.mIsStarted = false;
    }

    @Override
    public boolean isStarted() {
        return this.mIsStarted;
    }
}

