/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.preheat;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.context.RequestContextCreator;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.datasource.DataSourceFactory;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.framework.lifecycle.Service;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DataSourcePreheatService
implements Service {
    private static Log log = LogFactory.getLog(DataSourcePreheatService.class);

    @Override
    public String getName() {
        return DataSourcePreheatService.class.getSimpleName();
    }

    @Override
    public void start() {
        if (!Boolean.parseBoolean(System.getProperty("db.datasource.preheart", "true"))) {
            return;
        }
        log.info("Preheating Datasource, IDService and ORM.");
        String[] appIds = Instance.getAppIds();
        if (appIds == null || appIds.length == 0) {
            appIds = new String[]{DBRoute.basedata.getRouteKey(), DBRoute.permission.getRouteKey(), DBRoute.log.getRouteKey(), DBRoute.workflow.getRouteKey()};
        }
        boolean preheartOnce = false;
        for (Account account : this.getAllAccountsOfCurrentEnv()) {
            String tenantId = account.getTenantId();
            String accountId = account.getAccountId();
            RequestContextCreator.createForPreheat(tenantId, accountId);
            List<String> routeKeys = this.queryDbRouteKeys(appIds);
            if (routeKeys.isEmpty()) continue;
            for (String routeKey : routeKeys) {
                try {
                    DataSourceFactory.getDataSource((String)tenantId, (String)routeKey, (String)accountId, (boolean)false);
                    if (preheartOnce) continue;
                    this.preheatIDServiceandORM();
                    preheartOnce = true;
                }
                catch (Exception e) {
                    log.warn("PreHeat datasource failed: tenantId=" + tenantId + ", routeKey=" + routeKey + ", accountId=" + accountId + ", cause by " + e.getMessage(), (Throwable)e);
                }
            }
            this.onDataSourcePreheated();
        }
    }

    private List<Account> getAllAccountsOfCurrentEnv() {
        try {
            return AccountUtils.getAllAccountsOfCurrentEnv();
        }
        catch (Exception ignored) {
            log.warn("Current env don't have tenant");
            return Collections.emptyList();
        }
    }

    private List<String> queryDbRouteKeys(String[] appIds) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("/*dialect*/select distinct fdbroute from t_meta_bizapp where ", new Object[0]);
        builder.appendIn("fnumber", (Object[])appIds);
        return (List)DB.query((DBRoute)DBRoute.of((String)"sys.meta"), (SqlBuilder)builder, rs -> {
            ArrayList<String> result = new ArrayList<String>(appIds.length);
            while (rs.next()) {
                result.add(rs.getString(1));
            }
            return result;
        });
    }

    private void preheatIDServiceandORM() {
        try {
            DB.genGlobalLongId();
            Method preheat = Class.forName("kd.bos.orm.ORMPreheater").getMethod("preheat", new Class[0]);
            preheat.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            log.warn("Preheat IDService or ORM failed: " + e.getMessage(), (Throwable)e);
        }
    }

    private void onDataSourcePreheated() {
        try {
            Method onDataSourcePreheated = Class.forName("kd.bos.orm.ORMPreheater").getMethod("onDataSourcePreheated", new Class[0]);
            onDataSourcePreheated.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            log.warn("onDataSourcePreheated failed: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isStarted() {
        return true;
    }
}

