/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.context.OperationContextCreator;
import kd.bos.framework.lifecycle.Service;
import kd.bos.framework.resource.ResourceRecycleImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class ResourceRecycleService
implements Service {
    private static Log log = LogFactory.getLog((String)"kd.bos.framework.resource.ResourceRecycleService");
    private boolean started = false;
    private static List<ResourceRecycleImpl> taskList = new ArrayList<ResourceRecycleImpl>();

    @Override
    public String getName() {
        return "ResourceRecycleService";
    }

    @Override
    public void start() {
        List<Map<String, String>> ls = this.getRunableConfig();
        for (Map<String, String> m : ls) {
            String runableClassName = m.get("runableClass");
            String interval = m.get("interval_second");
            String taskName = m.get("taskName");
            try {
                ResourceRecycleImpl impl = new ResourceRecycleImpl(runableClassName, taskName, Integer.parseInt(interval));
                impl.start();
                taskList.add(impl);
            }
            catch (Exception e) {
                OperationContextCreator.getOrCreateForBos();
                log.error("start recycle task exception,class " + runableClassName, (Throwable)e);
            }
        }
        this.started = true;
    }

    private List<Map<String, String>> getRunableConfig() {
        ArrayList<Map<String, String>> ls = new ArrayList<Map<String, String>>();
        String json = System.getProperty("bos.resource.recycle");
        if (StringUtils.isEmpty((String)json)) {
            return Collections.EMPTY_LIST;
        }
        try {
            List l = (List)JSONUtils.cast((String)json, List.class);
            return l;
        }
        catch (Exception e) {
            OperationContextCreator.getOrCreateForBos();
            log.error("start recycle task config exception,json: " + json, (Throwable)e);
            return ls;
        }
    }

    @Override
    public void stop() {
        for (ResourceRecycleImpl task : taskList) {
            task.stop();
        }
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }
}

