/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.task;

import java.util.HashSet;
import java.util.Set;
import kd.bos.thread.ThreadLifeCycleManager;

public class BackendTask {
    private String taskId;
    private long delaySecond = 0L;
    private long periodSecond = 3600L;
    private Set<String> runAppids = new HashSet<String>(2);
    private boolean isSingleTask = true;
    private Runnable runnable;

    public long getDelaySecond() {
        return this.delaySecond;
    }

    public BackendTask withDelaySecond(long delaySecond) {
        this.delaySecond = delaySecond;
        return this;
    }

    public long getPeriodSecond() {
        return this.periodSecond;
    }

    public BackendTask withPeriodSecond(long periodSecond) {
        this.periodSecond = periodSecond;
        return this;
    }

    public Set<String> getRunAppids() {
        return this.runAppids;
    }

    public BackendTask withRunAppids(Set<String> runAppids) {
        this.runAppids = runAppids;
        return this;
    }

    public BackendTask withRunAppId(String appId) {
        this.runAppids.add(appId);
        return this;
    }

    public boolean isSingleTask() {
        return this.isSingleTask;
    }

    public BackendTask withSingleTask(boolean isSingleTask) {
        this.isSingleTask = isSingleTask;
        return this;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public BackendTask withRunnable(Runnable runnable) {
        this.runnable = ThreadLifeCycleManager.wrapRunnable((Runnable)runnable);
        return this;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public BackendTask withTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }
}

