/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.task;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.cache.redis.backendcheck.RedisBackendCheckService;
import kd.bos.elect.ElectFactory;
import kd.bos.elect.Elector;
import kd.bos.elect.ElectorListener;
import kd.bos.framework.task.BackendTask;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BackendTaskManage {
    private static Map<String, BackendTask> tasks = new ConcurrentHashMap<String, BackendTask>(2);
    private static volatile boolean started = false;
    private static ScheduledExecutorService es = null;
    private static Log log = LogFactory.getLog(BackendTaskManage.class);

    public static void registerByMap(Map<String, Object> m, Runnable task) {
        BackendTask btask = new BackendTask();
        btask.withRunnable(task).withTaskId((String)m.get("taskId")).withDelaySecond((Long)m.get("delaySecond")).withPeriodSecond((Long)m.get("periodSecond")).withRunAppids((Set)m.get("runAppids")).withSingleTask((Boolean)m.get("isSingleTask"));
        BackendTaskManage.register(btask);
    }

    public static synchronized void register(BackendTask task) {
        String taskid = task.getTaskId();
        if (tasks.containsKey(taskid)) {
            log.info("has_registerkey:" + taskid);
            return;
        }
        tasks.put(taskid, task);
        if (started) {
            if (es == null) {
                es = Executors.newScheduledThreadPool(3);
            }
            BackendTaskManage.startTask(task);
        }
    }

    public static synchronized void start() {
        started = true;
        if (tasks.isEmpty()) {
            return;
        }
        es = Executors.newScheduledThreadPool(3);
        tasks.forEach((taskid, task) -> BackendTaskManage.startTask(task));
    }

    private static void startTask(BackendTask task) {
        Set<String> appIds = task.getRunAppids();
        if (BackendTaskManage.checkAppIds(appIds)) {
            if (task.isSingleTask()) {
                final AtomicBoolean isChoose = new AtomicBoolean(false);
                Elector elector = ElectFactory.getElector((String)task.getTaskId());
                elector.registerListener(new ElectorListener(){

                    public void notifyLostMaster() {
                        isChoose.set(false);
                    }

                    public void notifyMaster() {
                        isChoose.set(true);
                    }
                });
                elector.start();
                isChoose.set(elector.isMaster());
                log.info(String.format("schedule backend task %s %s seconds after", task.getTaskId(), task.getDelaySecond()));
                es.scheduleWithFixedDelay(() -> {
                    log.info(String.format("run backend task %s ", task.getTaskId()));
                    if (elector.isMaster()) {
                        log.info(String.format("run backend task %s ", task.getTaskId()));
                        task.getRunnable().run();
                    }
                }, task.getDelaySecond(), task.getPeriodSecond(), TimeUnit.SECONDS);
            } else {
                log.info(String.format("schedule backend task %s %s seconds after", task.getTaskId(), task.getDelaySecond()));
                es.scheduleWithFixedDelay(task.getRunnable(), task.getDelaySecond(), task.getPeriodSecond(), TimeUnit.SECONDS);
            }
        }
    }

    private static boolean checkAppIds(Set<String> appIds) {
        if (!Instance.isAppSplit()) {
            return true;
        }
        String[] curAppIds = Instance.getAppIds();
        if (curAppIds != null) {
            for (String appid : curAppIds) {
                if (!appIds.contains(appid)) continue;
                return true;
            }
        }
        return false;
    }

    public static void stop() {
        es.shutdown();
    }

    static {
        if (Boolean.getBoolean("redis.checkbackend.autoregistry")) {
            String[] redisUrlKeys;
            String needCleanRedisKey = System.getProperty("redis.checkbackend.keys", CacheConfigKeys.getSessionlessConfigKey(null));
            for (String redisUrlKey : redisUrlKeys = needCleanRedisKey.split(",|;")) {
                String redisUrl = System.getProperty(redisUrlKey);
                if (redisUrl != null) {
                    RedisBackendCheckService.register((String)redisUrl, (long)36000L);
                    continue;
                }
                log.warn("backend redis key is empty: " + redisUrlKey);
            }
        }
    }
}

