/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.zoowhisper.superzoo;

import java.util.List;
import java.util.Map;
import kd.bos.framework.zoowhisper.NodeChangeListener;
import kd.bos.framework.zoowhisper.NodeChangeListenerWithInit;
import kd.bos.framework.zoowhisper.ZooEventifyCenter;
import kd.bos.framework.zoowhisper.superzoo.m.ElectorManager;
import kd.bos.framework.zoowhisper.superzoo.m.InstanceManager;
import kd.bos.framework.zoowhisper.superzoo.m.LocalListernersManager;
import kd.bos.framework.zoowhisper.superzoo.rpc.EndPointInvokeUtil;
import kd.bos.framework.zoowhisper.superzoo.rpc.MessageCenterWorkService;
import kd.bos.framework.zoowhisper.superzoo.store.StoreManager;
import kd.bos.instance.Instance;
import kd.bos.util.SafeLogUtils;
import kd.bos.util.StringUtils;

public class SuperZooEventifyCenter
implements ZooEventifyCenter {
    @Override
    public void addWatch(String region, String path, NodeChangeListener configChangeListener) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        LocalListernersManager.addWatch(path, configChangeListener);
        StoreManager.getInstance(region).saveNodeWatchPath(Instance.getInstanceId(), path);
        InstanceManager.add(Instance.getInstanceId(), false);
        EndPointInvokeUtil.notifyMasterUpdateWatchList(Instance.getInstanceId(), path);
        if (configChangeListener instanceof NodeChangeListenerWithInit) {
            Map<String, String> allMessages = StoreManager.getInstance(region).getChildren(path);
            ((NodeChangeListenerWithInit)configChangeListener).init(allMessages);
        }
    }

    @Override
    public void setNode(String region, String path, String nodeName, String nodeValue) {
        if (StringUtils.isEmpty((String)nodeName)) {
            throw new IllegalArgumentException("nodeName Cannot be empty");
        }
        this.saveNode(region, path, nodeName, nodeValue, true);
    }

    @Override
    public void setNode(String region, String path, String nodeName, String nodeValue, boolean isScheduleSave) {
        this.setNode(region, path, nodeName, nodeValue);
    }

    @Override
    public void setNodeWithPersistent(String region, String path, String nodeName, String nodeValue) {
        if (StringUtils.isEmpty((String)nodeName)) {
            throw new IllegalArgumentException("nodeName Cannot be empty");
        }
        this.saveNode(region, path, nodeName, nodeValue, false);
    }

    private void saveNode(String region, String path, String nodeName, String nodeValue, boolean isEphemeral) {
        if (StringUtils.isEmpty((String)nodeName)) {
            throw new IllegalArgumentException("nodeName Cannot be empty");
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        StoreManager.getInstance(region).saveNode(path, nodeName, nodeValue, isEphemeral);
        String rNodeValue = StoreManager.getInstance(region).getNodeValue(path + nodeName);
        if (!rNodeValue.equals(nodeValue)) {
            SafeLogUtils.error(ZooEventifyCenter.class, (String)String.format("[superzoo]path:%s,set:%s,get:%s", path + nodeName, nodeValue, rNodeValue), (Throwable)new Exception("not save node value"));
        }
        MessageCenterWorkService.reciveNodeChangeEvent(path + nodeName);
        InstanceManager.add(Instance.getInstanceId(), false);
        EndPointInvokeUtil.notifyMasterNodeChange(Instance.getInstanceId(), path + nodeName);
    }

    @Override
    public void deleteNode(String region, String path, String nodeName) {
        if (StringUtils.isEmpty((String)nodeName)) {
            throw new IllegalArgumentException("nodeName Cannot be empty");
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        StoreManager.getInstance(region).deleteNode(path, nodeName);
        EndPointInvokeUtil.notifyMasterNodeChange(Instance.getInstanceId(), path + nodeName);
    }

    @Override
    public void deleteDirectory(String region, String path) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        StoreManager.getInstance(region).deleteDirectory(path);
    }

    @Override
    public Map<String, String> getChildren(String region, String path) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return StoreManager.getInstance(region).getChildren(path);
    }

    @Override
    public boolean existsNode(String region, String fullPath) {
        return StoreManager.getInstance(region).existsNode(fullPath);
    }

    @Override
    public boolean existsNode(String region, String parentPath, String nodeName) {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        return this.existsNode(region, parentPath + nodeName);
    }

    @Override
    public List<String> getChildrenNames(String region, String path) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return StoreManager.getInstance(region).getChildrenNames(path);
    }

    @Override
    public String getNodeValue(String region, String path, String nodeName) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        String value = StoreManager.getInstance(region).getNodeValue(path + nodeName);
        return value;
    }

    @Override
    public Map<String, String> getChildrenForCrossCluster(String region, String clusterName, String path) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return StoreManager.getInstance(region).getChildren(clusterName, path);
    }

    @Override
    public String getAddress(String region) {
        return StoreManager.getInstance(region).getAddress();
    }

    static {
        try {
            ElectorManager.init();
        }
        catch (Exception e) {
            SafeLogUtils.error(ZooEventifyCenter.class, (String)"[superzoo]init elector error", (Throwable)e);
        }
    }
}

