/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.zoowhisper.superzoo.m;

import kd.bos.elect.ElectFactory;
import kd.bos.elect.Elector;
import kd.bos.elect.ElectorListener;
import kd.bos.framework.zoowhisper.superzoo.m.InstanceManager;
import kd.bos.framework.zoowhisper.superzoo.m.InstanceManagerTaskService;
import kd.bos.framework.zoowhisper.superzoo.m.LocalWatchListManager;
import kd.bos.instance.Instance;
import kd.bos.util.AppUtils;
import kd.bos.util.SafeLogUtils;

public class ElectorManager {
    private static Elector elector;
    private static final String ELECT_APPID;

    public static void init() {
        elector = ElectFactory.getElector((String)"SuperzooListener_elector");
        if (ElectorManager.isCurrentNodeJoinElect(ELECT_APPID)) {
            elector.registerListener(new ElectorListener(){

                public void notifyLostMaster() {
                    SafeLogUtils.info(ElectorManager.class, (String)"[superzoo]currentNode lost master");
                    InstanceManagerTaskService.stopInstanceWatchEvent();
                }

                public void notifyMaster() {
                    SafeLogUtils.info(ElectorManager.class, (String)"[superzoo]currentNode been master");
                    LocalWatchListManager.reloadWatchList();
                    InstanceManager.reloadInstances();
                    InstanceManagerTaskService.startInstanceWatchEvent();
                }
            });
            elector.start();
        }
    }

    public static String getMasterInstanceId() {
        return elector.getMaster().getInstanceId();
    }

    public static boolean isMaster() {
        String getMasterInstanceId = ElectorManager.getMasterInstanceId();
        boolean ismaster = Instance.getInstanceId().equals(getMasterInstanceId);
        if (!ismaster) {
            SafeLogUtils.error(ElectorManager.class, (String)("[superzoo]" + getMasterInstanceId + " notmaster"), (Throwable)new Exception(getMasterInstanceId + " not master"));
        }
        return ismaster;
    }

    private static boolean isCurrentNodeJoinElect(String string) {
        if (Instance.isAppSplit()) {
            String[] appids = Instance.getAppIds();
            if (appids == null) {
                return false;
            }
            for (String appid : appids) {
                if (!appid.equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }
        String[] deployAppIds = Instance.getAppIds();
        boolean isCurrentDeployAlone = AppUtils.isDeployAloneApps((String[])deployAppIds);
        if (isCurrentDeployAlone) {
            for (String deployAppId : deployAppIds) {
                if (!string.equals(deployAppId)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    static {
        ELECT_APPID = System.getProperty("bos.superzoo.electNode.appId", "bos");
    }
}

