/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.zoowhisper.superzoo.m;

import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import kd.bos.framework.zoowhisper.superzoo.m.InstanceManager;
import kd.bos.framework.zoowhisper.superzoo.m.LocalWatchListManager;
import kd.bos.framework.zoowhisper.superzoo.rpc.EndPointInvokeUtil;
import kd.bos.framework.zoowhisper.superzoo.store.StoreManager;
import kd.bos.instance.LivingLookout;
import kd.bos.instance.ServiceStatus;
import kd.bos.util.SafeLogUtils;

public class InstanceManagerTaskService {
    private static ScheduledExecutorService es;
    private static volatile boolean isRunning;
    private static AtomicInteger atomicInteger;

    public static synchronized void startInstanceWatchEvent() {
        isRunning = true;
        if (es != null) {
            try {
                es.shutdown();
            }
            catch (Exception e) {
                SafeLogUtils.error(InstanceManagerTaskService.class, (String)"[superzoo]shut done exception", (Throwable)e);
            }
        }
        es = InstanceManagerTaskService.getEs();
        AtomicLong reloadTime = new AtomicLong(System.currentTimeMillis());
        es.scheduleWithFixedDelay(() -> {
            long time = System.currentTimeMillis();
            if (isRunning && ServiceStatus.isRpcServiceStarted()) {
                try {
                    InstanceManagerTaskService.doWatch();
                    if (System.currentTimeMillis() - reloadTime.get() > 180000L) {
                        reloadTime.set(System.currentTimeMillis());
                        InstanceManager.reloadInstances();
                    }
                }
                catch (Error | Exception e) {
                    SafeLogUtils.error(InstanceManagerTaskService.class, (String)"[superzoo]doWatch excetion", (Throwable)e);
                }
            } else {
                SafeLogUtils.info(InstanceManagerTaskService.class, (String)"[superzoo]this task is stopped ,not isRunning");
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    private static void doWatch() {
        Set<String> instances = InstanceManager.getAllInstances();
        instances.forEach(instanceId -> {
            try {
                boolean isLiving = LivingLookout.isInstanceAlive((String)instanceId);
                if (!isLiving) {
                    StoreManager storeManager = StoreManager.getInstance("");
                    Set<String> ephemeralPaths = storeManager.getEphemeralPaths((String)instanceId);
                    ephemeralPaths.forEach(path -> storeManager.deleteNode((String)path));
                    storeManager.deleteNodeByInstanceId((String)instanceId);
                    ephemeralPaths.forEach(path -> {
                        Set<String> watchInstances = LocalWatchListManager.getWatchSet(path);
                        EndPointInvokeUtil.notifySlaveNodeChangeEvent(watchInstances, path);
                    });
                    Set<String> parentPaths = ephemeralPaths.stream().map(StoreManager::getParent).collect(Collectors.toSet());
                    if (!parentPaths.isEmpty()) {
                        storeManager.removeNodeWathPath((String)instanceId, parentPaths.toArray(new String[0]));
                        LocalWatchListManager.removeInstanceWatch(instanceId, parentPaths);
                    }
                    storeManager.removeEphemeralPaths((String)instanceId);
                    InstanceManager.remove(instanceId);
                }
            }
            catch (Exception e) {
                SafeLogUtils.error(InstanceManagerTaskService.class, (String)("[superzoo]watchException:" + instanceId), (Throwable)e);
            }
        });
    }

    private static ScheduledExecutorService getEs() {
        return Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "ClusterMessageEventService-" + atomicInteger.incrementAndGet());
            }
        });
    }

    public static synchronized void stopInstanceWatchEvent() {
        isRunning = false;
        es.shutdown();
    }

    static {
        isRunning = false;
        atomicInteger = new AtomicInteger(0);
    }
}

