/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.zoowhisper.superzoo.rpc;

import java.util.Set;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.framework.zoowhisper.superzoo.m.ElectorManager;
import kd.bos.framework.zoowhisper.superzoo.m.InstanceManager;
import kd.bos.framework.zoowhisper.superzoo.m.LocalWatchListManager;
import kd.bos.framework.zoowhisper.superzoo.rpc.EndPointInvokeUtil;
import kd.bos.util.SafeLogUtils;

public class MessageCenterMasterService {
    public static void notifyUpdateWatchList(String instanceId, String path) {
        if (!ElectorManager.isMaster()) {
            SafeLogUtils.info(MessageCenterMasterService.class, (String)"[superzoo]currentnode is not master node");
            throw new KDException(BosErrorCode.bOS, new Object[]{"currentnode is not master node,not execute MessageCenterMasterService.notifyUpdateWatchList"});
        }
        LocalWatchListManager.updateWatchList(instanceId, path);
        InstanceManager.add(instanceId, true);
    }

    public static void notifyNodeChange(String eventInstanceId, String nodePath) {
        if (!ElectorManager.isMaster()) {
            SafeLogUtils.info(MessageCenterMasterService.class, (String)"[superzoo]currentnode is not master node");
            throw new KDException(BosErrorCode.bOS, new Object[0]);
        }
        Set<String> watchInstanceList = LocalWatchListManager.getWatchSet(nodePath);
        EndPointInvokeUtil.notifySlaveNodeChangeEvent(watchInstanceList, nodePath);
        InstanceManager.add(eventInstanceId, true);
    }
}

