/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.zoowhisper.superzoo.store;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.framework.zoowhisper.superzoo.store.RedisStoreManager;

public interface StoreManager {
    public static final String SPLITKEY = "#@#";

    public static StoreManager getInstance(String region) {
        String type = System.getProperty("bos.messageeventcenter.type", "redis");
        if ("redis".equals(type)) {
            return RedisStoreManager.get(region);
        }
        throw new KDException(BosErrorCode.bOS, new Object[]{"not support type " + type});
    }

    public Map<String, String> getChildren(String var1);

    public List<String> getChildrenNames(String var1);

    public void saveNode(String var1, String var2, String var3, boolean var4);

    public void deleteNode(String var1, String var2);

    public void deleteNode(String var1);

    public void saveNodeWatchPath(String var1, String var2);

    public void removeNodeWathPath(String var1, String[] var2);

    public Map<String, Set<String>> getPathWatchList();

    public String getNodeValue(String var1);

    public void saddInstance(String var1);

    public void sremoveInstance(String var1);

    public String[] reloadInstances();

    public Set<String> getEphemeralPaths(String var1);

    public void removeEphemeralPaths(String var1);

    public static String getParent(String nodePath) {
        if (nodePath.endsWith("/")) {
            nodePath = nodePath.substring(0, nodePath.length() - 1);
        }
        nodePath = nodePath.substring(0, nodePath.lastIndexOf("/") + 1);
        return nodePath;
    }

    public Map<String, String> getChildren(String var1, String var2);

    public boolean existsNode(String var1);

    public void deleteNodeByInstanceId(String var1);

    public void deleteDirectory(String var1);

    public String getAddress();
}

