/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.zoowhisper.zookeeper;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.config.client.zk.ZookeeperConfiguration;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.framework.zoowhisper.NodeChangeListener;
import kd.bos.framework.zoowhisper.NodeChangeListenerWithInit;
import kd.bos.framework.zoowhisper.ZooEventifyCenter;
import kd.bos.framework.zoowhisper.zookeeper.Runner;
import kd.bos.util.StringUtils;
import kd.bos.util.SystemProperties;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;

public class ZKZooEventityCenter
implements ZooEventifyCenter {
    private static ScheduledExecutorService es = Executors.newScheduledThreadPool(1, new ThreadFactory(){
        private AtomicInteger atomicInteger = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "ZKZooEventityCenter-" + this.atomicInteger.incrementAndGet());
        }
    });

    @Override
    public void addWatch(String region, String path, NodeChangeListener configChangeListener) {
        String configUrl = this.getZkAddr(region);
        String zkStorePath = ZKFactory.getZkRootPath((String)configUrl) + path;
        ZookeeperConfiguration zkconfig = new ZookeeperConfiguration(configUrl, zkStorePath);
        if (configChangeListener instanceof NodeChangeListenerWithInit) {
            ((NodeChangeListenerWithInit)configChangeListener).init(zkconfig.toMap());
        }
        zkconfig.addConfigurationChangeListener((k, v) -> configChangeListener.onChange((String)k, (String)v));
    }

    @Override
    public void setNode(String region, String path, String nodeName, String nodeValue) {
        if (StringUtils.isEmpty((String)nodeName)) {
            throw new IllegalArgumentException("nodeName Cannot be empty");
        }
        String configUrl = this.getZkAddr(region);
        String zkStorePath = ZKFactory.getZkRootPath((String)configUrl) + path;
        String nodePath = zkStorePath + "/" + nodeName;
        es.scheduleWithFixedDelay(new Runner(zkStorePath, nodePath, configUrl, nodeValue), 0L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void setNode(String region, String path, String nodeName, String nodeValue, boolean isScheduleSave) {
        if (isScheduleSave) {
            this.setNode(region, path, nodeName, nodeValue);
            return;
        }
        if (StringUtils.isEmpty((String)nodeName)) {
            throw new IllegalArgumentException("nodeName Cannot be empty");
        }
        String configUrl = this.getZkAddr(region);
        String zkStorePath = ZKFactory.getZkRootPath((String)configUrl) + path;
        String nodePath = zkStorePath + "/" + nodeName;
        try {
            CuratorFramework client = ZKFactory.getZKClient((String)configUrl);
            Stat exists = null;
            exists = (Stat)client.checkExists().forPath(nodePath);
            if (exists == null) {
                ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)client.create().creatingParentContainersIfNeeded().withMode(CreateMode.EPHEMERAL)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(nodePath, nodeValue.getBytes(StandardCharsets.UTF_8));
            } else {
                client.setData().forPath(nodePath, nodeValue.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.bOS, "ZooEventity setNode", (Throwable)e);
        }
    }

    @Override
    public void setNodeWithPersistent(String region, String path, String nodeName, String nodeValue) {
        if (StringUtils.isEmpty((String)nodeName)) {
            throw new IllegalArgumentException("nodeName Cannot be empty");
        }
        String configUrl = this.getZkAddr(region);
        String zkStorePath = ZKFactory.getZkRootPath((String)configUrl) + path;
        String nodePath = zkStorePath + "/" + nodeName;
        try {
            CuratorFramework client = ZKFactory.getZKClient((String)configUrl);
            Stat exists = null;
            exists = (Stat)client.checkExists().forPath(nodePath);
            if (exists == null) {
                ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)client.create().creatingParentContainersIfNeeded().withMode(CreateMode.PERSISTENT)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(nodePath, nodeValue.getBytes(StandardCharsets.UTF_8));
            } else {
                client.setData().forPath(nodePath, nodeValue.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.bOS, "ZooEventity setNodeWithPersistent", (Throwable)e);
        }
    }

    @Override
    public void deleteNode(String region, String path, String nodeName) {
        if (StringUtils.isEmpty((String)nodeName)) {
            throw new IllegalArgumentException("nodeName Cannot be empty");
        }
        String configUrl = this.getZkAddr(region);
        String zkStorePath = ZKFactory.getZkRootPath((String)configUrl) + path;
        String nodePath = zkStorePath + "/" + nodeName;
        CuratorFramework client = ZKFactory.getZKClient((String)configUrl);
        try {
            client.delete().forPath(nodePath);
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NoNodeException) {
                return;
            }
            throw new KDException(BosErrorCode.bOS, "ZooEventity deleteNode", (Throwable)e);
        }
    }

    @Override
    public void deleteDirectory(String region, String path) {
        String configUrl = this.getZkAddr(region);
        String zkStorePath = ZKFactory.getZkRootPath((String)configUrl) + path;
        CuratorFramework client = ZKFactory.getZKClient((String)configUrl);
        Stat exists = null;
        try {
            exists = (Stat)client.checkExists().forPath(zkStorePath);
            if (exists == null) {
                return;
            }
            client.delete().deletingChildrenIfNeeded().forPath(zkStorePath);
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NoNodeException) {
                return;
            }
            throw new KDException(BosErrorCode.bOS, "ZooEventity deleteDirectory", (Throwable)e);
        }
    }

    @Override
    public Map<String, String> getChildren(String region, String path) {
        String configUrl = this.getZkAddr(region);
        try {
            CuratorFramework client = ZKFactory.getZKClient((String)configUrl);
            String zkStorePath = ZKFactory.getZkRootPath((String)configUrl) + path;
            List child = (List)client.getChildren().forPath(zkStorePath);
            HashMap<String, String> resMap = new HashMap<String, String>(2);
            for (String hk : child) {
                byte[] datas = (byte[])client.getData().forPath(zkStorePath + "/" + hk);
                String json = null;
                if (datas != null) {
                    json = new String(datas, StandardCharsets.UTF_8);
                }
                resMap.put(hk, json);
            }
            return resMap;
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NoNodeException) {
                return Collections.emptyMap();
            }
            throw new KDException(BosErrorCode.bOS, "ZooEventity getChildren", (Throwable)e);
        }
    }

    @Override
    public boolean existsNode(String region, String fullPath) {
        String configUrl = this.getZkAddr(region);
        try {
            CuratorFramework client = ZKFactory.getZKClient((String)configUrl);
            String zkStorePath = ZKFactory.getZkRootPath((String)configUrl) + fullPath;
            return client.checkExists().forPath(zkStorePath) != null;
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.bOS, "ZooEventity existsNode", (Throwable)e);
        }
    }

    @Override
    public boolean existsNode(String region, String parentPath, String nodeName) {
        if (StringUtils.isEmpty((String)nodeName)) {
            throw new IllegalArgumentException("nodeName Cannot be empty");
        }
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        return this.existsNode(region, parentPath + nodeName);
    }

    @Override
    public List<String> getChildrenNames(String region, String path) {
        String configUrl = this.getZkAddr(region);
        try {
            CuratorFramework client = ZKFactory.getZKClient((String)configUrl);
            String zkStorePath = ZKFactory.getZkRootPath((String)configUrl) + path;
            List child = (List)client.getChildren().forPath(zkStorePath);
            return child;
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NoNodeException) {
                return Collections.emptyList();
            }
            throw new KDException(BosErrorCode.bOS, "ZooEventity getChildrenNames", (Throwable)e);
        }
    }

    @Override
    public String getNodeValue(String region, String path, String nodeName) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        String configUrl = this.getZkAddr(region);
        try {
            CuratorFramework client = ZKFactory.getZKClient((String)configUrl);
            String zkStorePath = ZKFactory.getZkRootPath((String)configUrl) + path;
            Stat exists = (Stat)client.checkExists().forPath(zkStorePath + nodeName);
            if (exists == null) {
                return null;
            }
            String json = new String((byte[])client.getData().forPath(zkStorePath + nodeName), StandardCharsets.UTF_8);
            return json;
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.bOS, "ZooEventity getNodeValue", (Throwable)e);
        }
    }

    @Override
    public Map<String, String> getChildrenForCrossCluster(String region, String clusterName, String path) {
        return this.getChildren(region, path);
    }

    @Override
    public String getAddress(String region) {
        return "zookeeper@" + this.getZkAddr(region);
    }

    private String getZkAddr(String region) {
        String configUrl = SystemProperties.getWithEnv((String)region);
        if (configUrl == null) {
            configUrl = SystemProperties.getWithEnv((String)"configUrl");
        }
        return configUrl;
    }
}

